/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.caching.RequestCacheControlStruct;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.ballerinalang.runtime.message.MessageDataSource;
import org.ballerinalang.util.codegen.ProgramFile;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

class WebSubResourceDispatcher {
    WebSubResourceDispatcher() {
    }

    static HttpResource findResource(HttpService service, HTTPCarbonMessage inboundRequest, WebSubServicesRegistry servicesRegistry) throws BallerinaConnectorException, ServerConnectorException {
        String resourceName;
        String method = (String)inboundRequest.getProperty("HTTP_METHOD");
        HttpResource httpResource = null;
        if ("TOPIC_ID_HEADER".equals(servicesRegistry.getTopicIdentifier()) && "POST".equals(method)) {
            String topic = inboundRequest.getHeader(servicesRegistry.getTopicHeader());
            BMap topicResourceMapForHeader = (BMap)servicesRegistry.getTopicResourceMap().get((Object)"TOPIC_ID_HEADER");
            resourceName = WebSubResourceDispatcher.retrieveResourceName(topic, (BMap<String, BString>)topicResourceMapForHeader);
        } else if (servicesRegistry.getTopicIdentifier() != null && "POST".equals(method)) {
            if (inboundRequest.getProperty("httpResource") == null) {
                inboundRequest.setProperty("httpResource", (Object)"deferredForPayloadBasedDispatching");
                return null;
            }
            ProgramFile programFile = service.getBalService().getServiceInfo().getPackageInfo().getProgramFile();
            if (servicesRegistry.getTopicIdentifier().equals("TOPIC_ID_PAYLOAD_KEY")) {
                resourceName = WebSubResourceDispatcher.retrieveResourceName(programFile, inboundRequest, servicesRegistry.getTopicPayloadKeys(), servicesRegistry.getTopicResourceMap());
            } else {
                String topic = inboundRequest.getHeader(servicesRegistry.getTopicHeader());
                resourceName = WebSubResourceDispatcher.retrieveResourceName(programFile, inboundRequest, topic, servicesRegistry.getTopicPayloadKeys(), servicesRegistry.getTopicResourceMap());
            }
        } else {
            resourceName = WebSubResourceDispatcher.retrieveResourceName(method);
        }
        for (HttpResource resource : service.getResources()) {
            if (!resource.getName().equals(resourceName)) continue;
            httpResource = resource;
            break;
        }
        if (httpResource == null) {
            if ("onIntentVerification".equals(resourceName)) {
                String annotatedTopic = ((Annotation)service.getBalService().getAnnotationList("ballerina.websub", "SubscriberServiceConfig").get(0)).getValue().getStringField("topic");
                if (annotatedTopic.isEmpty() && service instanceof WebSubHttpService) {
                    annotatedTopic = ((WebSubHttpService)service).getTopic();
                }
                inboundRequest.setProperty("annotatedTopic", (Object)annotatedTopic);
                inboundRequest.setProperty("httpResource", (Object)"annotatedTopic");
            } else {
                inboundRequest.setProperty("HTTP_STATUS_CODE", (Object)404);
                throw new BallerinaConnectorException("no matching WebSub Subscriber service  resource " + resourceName + " found for method : " + method);
            }
        }
        return httpResource;
    }

    private static String retrieveResourceName(String method) {
        switch (method) {
            case "POST": {
                return "onNotification";
            }
            case "GET": {
                return "onIntentVerification";
            }
        }
        throw new BallerinaConnectorException("method not allowed for WebSub Subscriber Services : " + method);
    }

    private static String retrieveResourceName(ProgramFile programFile, HTTPCarbonMessage inboundRequest, String topicHeader, BStringArray payloadKeys, BMap<String, BMap<String, BString>> topicResourceMap) {
        BMap topicResourceMapForHeader;
        String topicHeaderPrefix = topicHeader + "::";
        BStruct httpRequest = WebSubResourceDispatcher.getHttpRequest(programFile, inboundRequest);
        BJSON jsonBody = WebSubResourceDispatcher.retrieveJsonBody((BValue)httpRequest);
        inboundRequest.setProperty("entityAccessedRequest", (Object)httpRequest);
        for (String key : payloadKeys.getStringArray()) {
            if (!jsonBody.value().has(key)) continue;
            BMap topicResourceMapForValue = (BMap)topicResourceMap.get((Object)key);
            String valueForKey = jsonBody.value().get(key).stringValue();
            String topic = topicHeaderPrefix + valueForKey;
            if (!topicResourceMapForValue.hasKey((Object)topic)) continue;
            return WebSubResourceDispatcher.retrieveResourceName(topic, (BMap<String, BString>)topicResourceMapForValue);
        }
        if (topicResourceMap.hasKey((Object)"TOPIC_ID_HEADER") && (topicResourceMapForHeader = (BMap)topicResourceMap.get((Object)"TOPIC_ID_HEADER")).hasKey((Object)topicHeader)) {
            return WebSubResourceDispatcher.retrieveResourceName(topicHeader, (BMap<String, BString>)topicResourceMapForHeader);
        }
        throw new BallerinaConnectorException("Matching resource not found for dispatching based on Header and Payload Key");
    }

    private static String retrieveResourceName(ProgramFile programFile, HTTPCarbonMessage inboundRequest, BStringArray payloadKeys, BMap<String, BMap<String, BString>> topicResourceMap) {
        BStruct httpRequest = WebSubResourceDispatcher.getHttpRequest(programFile, inboundRequest);
        BJSON jsonBody = WebSubResourceDispatcher.retrieveJsonBody((BValue)httpRequest);
        inboundRequest.setProperty("entityAccessedRequest", (Object)httpRequest);
        for (String key : payloadKeys.getStringArray()) {
            String valueForKey;
            BMap topicResourceMapForValue;
            if (!jsonBody.value().has(key) || !(topicResourceMapForValue = (BMap)topicResourceMap.get((Object)key)).hasKey((Object)(valueForKey = jsonBody.value().get(key).stringValue()))) continue;
            return WebSubResourceDispatcher.retrieveResourceName(valueForKey, (BMap<String, BString>)topicResourceMapForValue);
        }
        throw new BallerinaConnectorException("Matching resource not found for dispatching based on Payload Key");
    }

    private static BJSON retrieveJsonBody(BValue httpRequest) {
        BStruct entityStruct = MimeUtil.extractEntity((BStruct)((BStruct)httpRequest));
        if (entityStruct != null) {
            if (entityStruct.getNativeData("message_datasource") instanceof BJSON) {
                return (BJSON)entityStruct.getNativeData("message_datasource");
            }
            throw new BallerinaConnectorException("Non-JSON payload received for payload key based dispatching");
        }
        throw new BallerinaConnectorException("Error retrieving payload for payload key based dispatching");
    }

    private static String retrieveResourceName(String topic, BMap<String, BString> topicResourceMap) {
        if (topicResourceMap.get((Object)topic) != null) {
            return ((BString)topicResourceMap.get((Object)topic)).stringValue();
        }
        throw new BallerinaConnectorException("resource not specified for topic : " + topic);
    }

    private static BStruct getHttpRequest(ProgramFile programFile, HTTPCarbonMessage httpCarbonMessage) {
        BStruct httpRequest = WebSubResourceDispatcher.createBStruct(programFile, "ballerina.http", "Request");
        BStruct inRequestEntity = WebSubResourceDispatcher.createBStruct(programFile, "ballerina.mime", "Entity");
        BStruct mediaType = WebSubResourceDispatcher.createBStruct(programFile, "ballerina.mime", "MediaType");
        BStruct cacheControlStruct = WebSubResourceDispatcher.createBStruct(programFile, "ballerina.http", "RequestCacheControl");
        RequestCacheControlStruct requestCacheControl = new RequestCacheControlStruct(cacheControlStruct);
        HttpUtil.populateInboundRequest((BStruct)httpRequest, (BStruct)inRequestEntity, (BStruct)mediaType, (HTTPCarbonMessage)httpCarbonMessage, (RequestCacheControlStruct)requestCacheControl);
        HttpUtil.populateEntityBody(null, (BStruct)httpRequest, (BStruct)inRequestEntity, (boolean)true);
        EntityBodyHandler.addMessageDataSource((BStruct)inRequestEntity, (MessageDataSource)EntityBodyHandler.constructJsonDataSource((BStruct)inRequestEntity));
        inRequestEntity.addNativeData("entity_byte_channel", null);
        return httpRequest;
    }

    private static BStruct createBStruct(ProgramFile programFile, String packagePath, String structName) {
        return BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)packagePath, (String)structName, (Object[])new Object[0]);
    }
}

