/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import org.ballerinalang.connector.api.Service;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.ballerinalang.net.websub.WebSubSubscriberServiceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSubServicesRegistry
extends HTTPServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WebSubServicesRegistry.class);
    private String topicIdentifier;
    private String topicHeader;
    private BStringArray topicPayloadKeys;
    private BMap<String, BMap<String, BString>> topicResourceMap;

    public WebSubServicesRegistry(WebSocketServicesRegistry webSocketServicesRegistry) {
        super(webSocketServicesRegistry);
    }

    String getTopicIdentifier() {
        return this.topicIdentifier;
    }

    public void setTopicIdentifier(String topicIdentifier) {
        this.topicIdentifier = topicIdentifier;
    }

    String getTopicHeader() {
        return this.topicHeader;
    }

    public void setTopicHeader(String topicHeader) {
        this.topicHeader = topicHeader;
    }

    BStringArray getTopicPayloadKeys() {
        return this.topicPayloadKeys;
    }

    public void setTopicPayloadKeys(BStringArray topicPayloadKeys) {
        this.topicPayloadKeys = topicPayloadKeys;
    }

    public void setTopicResourceMap(BMap<String, BMap<String, BString>> topicResourceMap) {
        this.topicResourceMap = topicResourceMap;
    }

    BMap<String, BMap<String, BString>> getTopicResourceMap() {
        return this.topicResourceMap;
    }

    public void registerWebSubSubscriberService(Service service) {
        WebSubHttpService httpService = WebSubHttpService.buildWebSubSubscriberHttpService(service);
        this.servicesInfoMap.put(httpService.getBasePath(), httpService);
        logger.info("Service deployed : " + service.getName() + " with context " + httpService.getBasePath());
        this.sortedServiceURIs.add(httpService.getBasePath());
        this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
        WebSubSubscriberServiceValidator.validateResources(httpService, this.topicHeader, this.topicResourceMap);
    }
}

