/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSubSubscriberServiceValidator {
    private static final Logger logger = LoggerFactory.getLogger(WebSubSubscriberServiceValidator.class);

    WebSubSubscriberServiceValidator() {
    }

    static void validateResources(HttpService service, String topicHeader, BMap<String, BMap<String, BString>> topicResourceMap) {
        if (topicHeader != null && topicResourceMap != null) {
            WebSubSubscriberServiceValidator.validateCustomResources(service.getResources(), topicResourceMap);
        } else {
            WebSubSubscriberServiceValidator.validateDefaultResources(service.getResources());
        }
    }

    private static void validateDefaultResources(List<HttpResource> resources) {
        block8: for (HttpResource resource : resources) {
            String resourceName;
            switch (resourceName = resource.getName()) {
                case "onIntentVerification": {
                    WebSubSubscriberServiceValidator.validateOnIntentVerificationResource(resource.getBalResource());
                    continue block8;
                }
                case "onNotification": {
                    WebSubSubscriberServiceValidator.validateOnNotificationResource(resource.getBalResource());
                    continue block8;
                }
            }
            throw new BallerinaException(String.format("Invalid resource name %s for WebSubSubscriberService. Allowed resource names [%s, %s]", resourceName, "onIntentVerification", "onNotification"));
        }
    }

    private static void validateOnIntentVerificationResource(Resource resource) {
        List paramDetails = resource.getParamDetails();
        WebSubSubscriberServiceValidator.validateParamNumber(paramDetails, 2, resource.getName());
        WebSubSubscriberServiceValidator.validateStructType(resource.getName(), (ParamDetail)paramDetails.get(0), "ballerina.websub", "Listener");
        WebSubSubscriberServiceValidator.validateStructType(resource.getName(), (ParamDetail)paramDetails.get(1), "ballerina.websub", "IntentVerificationRequest");
    }

    private static void validateOnNotificationResource(Resource resource) {
        List paramDetails = resource.getParamDetails();
        WebSubSubscriberServiceValidator.validateParamNumber(paramDetails, 1, resource.getName());
        WebSubSubscriberServiceValidator.validateStructType(resource.getName(), (ParamDetail)paramDetails.get(0), "ballerina.websub", "NotificationRequest");
    }

    private static void validateParamNumber(List<ParamDetail> paramDetails, int expectedSize, String resourceName) {
        if (paramDetails == null || paramDetails.size() < expectedSize) {
            throw new BallerinaException(String.format("Invalid resource signature for WebSub Resource \"%s\"", resourceName));
        }
    }

    private static void validateStructType(String resourceName, ParamDetail paramDetail, String packageName, String structName) {
        if (!paramDetail.getVarType().getPackagePath().equals(packageName)) {
            throw new BallerinaException(String.format("Invalid parameter type %s:%s %s in resource %s. Requires %s:%s", paramDetail.getVarType().getPackagePath(), paramDetail.getVarType().getName(), paramDetail.getVarName(), resourceName, packageName, structName));
        }
        if (!paramDetail.getVarType().getName().equals(structName)) {
            throw new BallerinaException(String.format("Invalid parameter type %s:%s %s in resource %s. Requires %s:%s", paramDetail.getVarType().getPackagePath(), paramDetail.getVarType().getName(), paramDetail.getVarName(), resourceName, packageName, structName));
        }
    }

    private static void validateCustomResources(List<HttpResource> resources, BMap<String, BMap<String, BString>> topicResourceMap) {
        List<String> resourceNames = WebSubSubscriberServiceValidator.retrieveResourceNames(topicResourceMap);
        List<String> invalidResourceNames = WebSubSubscriberServiceValidator.retrieveInvalidResourceNames(resources, resourceNames);
        if (!resourceNames.isEmpty()) {
            logger.warn("Resource(s) specified in topic-resource mapping not found: " + resourceNames);
        }
        if (!invalidResourceNames.isEmpty()) {
            throw new BallerinaException("Resource name(s) not included in the topic-resource mapping found: " + invalidResourceNames);
        }
    }

    private static List<String> retrieveResourceNames(BMap<String, BMap<String, BString>> topicResourceMap) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String key : topicResourceMap.keySet()) {
            BMap topicResourceSubMap = (BMap)topicResourceMap.get((Object)key);
            for (String topic : topicResourceSubMap.keySet()) {
                resourceNames.add(((BString)topicResourceSubMap.get((Object)topic)).stringValue());
            }
        }
        return resourceNames;
    }

    private static List<String> retrieveInvalidResourceNames(List<HttpResource> resources, List<String> resourceNames) {
        ArrayList<String> invalidResourceNames = new ArrayList<String>();
        for (HttpResource resource : resources) {
            String resourceName = resource.getName();
            if (!resourceNames.contains(resourceName)) {
                invalidResourceNames.add(resourceName);
                continue;
            }
            WebSubSubscriberServiceValidator.validateOnNotificationResource(resource.getBalResource());
            resourceNames.remove(resourceName);
        }
        return invalidResourceNames;
    }
}

