/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.hub;

import io.ballerina.messaging.broker.core.Consumer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.broker.BrokerUtils;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.websub.hub.HubSubscriber;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ProgramFileReader;
import org.ballerinalang.util.program.BLangFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hub {
    private static final Logger logger = LoggerFactory.getLogger(Hub.class);
    private static Hub instance = new Hub();
    private String hubUrl;
    private boolean hubTopicRegistrationRequired;
    private boolean hubPersistenceEnabled;
    private volatile boolean started = false;
    private ProgramFile hubProgramFile;
    private Map<String, String> topics = new HashMap<String, String>();
    private List<HubSubscriber> subscribers = new ArrayList<HubSubscriber>();

    public static Hub getInstance() {
        return instance;
    }

    private Hub() {
    }

    public String retrieveHubUrl() {
        return this.hubUrl;
    }

    public String registerTopic(String topic, String secret, boolean loadingOnStartUp) {
        if (!this.hubTopicRegistrationRequired) {
            return "";
        }
        String errorMessage = "";
        if (this.isTopicRegistered(topic)) {
            errorMessage = "Topic registration not allowed at the Hub: topic already exists";
        } else if (topic == null || topic.equals("")) {
            errorMessage = "Topic unavailable/invalid for registration at Hub";
        } else {
            this.topics.put(topic, secret);
            if (this.hubPersistenceEnabled && !loadingOnStartUp) {
                BValue[] args = new BValue[]{new BString("register"), new BString(topic), new BString(secret)};
                BLangFunctions.invokeCallable((CallableUnitInfo)this.hubProgramFile.getPackageInfo("websub.hub").getFunctionInfo("changeTopicRegistrationInDatabase"), (BValue[])args);
            }
        }
        return errorMessage;
    }

    public String unregisterTopic(String topic, String secret) {
        if (!this.hubTopicRegistrationRequired) {
            return "";
        }
        String errorMessage = "";
        if (topic == null || !this.isTopicRegistered(topic)) {
            errorMessage = "Topic unavailable/invalid for unregistration at Hub";
        } else if (!this.topics.get(topic).equals(secret)) {
            errorMessage = "Topic unregistration denied at Hub for incorrect secret";
        } else {
            this.topics.remove(topic);
            if (this.hubPersistenceEnabled) {
                BValue[] args = new BValue[]{new BString("unregister"), new BString(topic), new BString(secret)};
                BLangFunctions.invokeCallable((CallableUnitInfo)this.hubProgramFile.getPackageInfo("websub.hub").getFunctionInfo("changeTopicRegistrationInDatabase"), (BValue[])args);
            }
        }
        return errorMessage;
    }

    public String retrievePublisherSecret(String topic) {
        return this.topics.get(topic);
    }

    public boolean isTopicRegistered(String topic) {
        return this.topics.containsKey(topic);
    }

    public void registerSubscription(String topic, String callback, BStruct subscriptionDetails) {
        if (!this.started) {
            logger.error("Hub Service not started: subscription failed");
        } else if (!this.topics.containsKey(topic) && this.hubTopicRegistrationRequired) {
            logger.warn("Subscription request ignored for unregistered topic[" + topic + "]");
        } else {
            if (this.subscribers.contains((Object)new HubSubscriber("", topic, callback, null))) {
                this.unregisterSubscription(topic, callback);
            }
            String queue = UUID.randomUUID().toString();
            if (BLangConnectorSPIUtil.toStruct((BStruct)subscriptionDetails).getStringField("secret") == null) {
                subscriptionDetails.setStringField(2, "");
            }
            HubSubscriber subscriberToAdd = new HubSubscriber(queue, topic, callback, subscriptionDetails);
            BrokerUtils.addSubscription((String)topic, (Consumer)subscriberToAdd);
            this.subscribers.add(subscriberToAdd);
        }
    }

    public void unregisterSubscription(String topic, String callback) {
        if (!this.started) {
            logger.error("Hub Service not started: unsubscription failed.");
            return;
        }
        HubSubscriber subscriberToUnregister = new HubSubscriber("", topic, callback, null);
        if (!this.subscribers.contains((Object)subscriberToUnregister)) {
            if (callback.endsWith("/")) {
                this.unregisterSubscription(topic, callback.substring(0, callback.length() - 1));
            }
            return;
        }
        for (HubSubscriber subscriber : this.subscribers) {
            if (!subscriber.equals((Object)subscriberToUnregister)) continue;
            subscriberToUnregister = subscriber;
            break;
        }
        BrokerUtils.removeSubscription((Consumer)subscriberToUnregister);
        this.subscribers.remove((Object)subscriberToUnregister);
    }

    public String publish(String topic, String stringPayload) {
        String errorMessage = "";
        if (!this.started) {
            errorMessage = "Hub Service not started: publish failed";
            logger.error(errorMessage);
        } else if (!this.topics.containsKey(topic) && this.hubTopicRegistrationRequired) {
            errorMessage = "Publish call ignored for unregistered topic[" + topic + "]";
            logger.warn(errorMessage);
        } else {
            byte[] payload = stringPayload.getBytes(StandardCharsets.UTF_8);
            BrokerUtils.publish((String)topic, (byte[])payload);
        }
        return errorMessage;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startUpHubService() {
        Hub hub = this;
        synchronized (hub) {
            URI balxPath;
            ProgramFile hubProgramFile;
            PackageInfo hubPackageInfo;
            if (!this.isStarted() && (hubPackageInfo = (hubProgramFile = Hub.readExecutableProgram(Paths.get(balxPath = URI.create(String.valueOf(Hub.class.getClassLoader().getResource("websub.hub.balx")))))).getPackageInfo("websub.hub")) != null) {
                hubPackageInfo.setProgramFile(hubProgramFile);
                BLangProgramRunner.runService((ProgramFile)hubProgramFile);
                BValue[] args = new BValue[]{};
                String webSubHubUrl = BLangFunctions.invokeCallable((CallableUnitInfo)hubPackageInfo.getFunctionInfo("getHubUrl"), (BValue[])args)[0].stringValue();
                this.hubPersistenceEnabled = Boolean.parseBoolean(BLangFunctions.invokeCallable((CallableUnitInfo)hubPackageInfo.getFunctionInfo("isHubPersistenceEnabled"), (BValue[])args)[0].stringValue());
                this.hubTopicRegistrationRequired = Boolean.parseBoolean(BLangFunctions.invokeCallable((CallableUnitInfo)hubPackageInfo.getFunctionInfo("isHubTopicRegistrationRequired"), (BValue[])args)[0].stringValue());
                logger.info("Default Ballerina WebSub Hub started up at " + webSubHubUrl);
                PrintStream console = System.out;
                console.println("ballerina: Default Ballerina WebSub Hub started up at " + webSubHubUrl);
                this.hubUrl = webSubHubUrl;
                this.setHubProgramFile(hubProgramFile);
                this.started = true;
                BLangFunctions.invokeCallable((CallableUnitInfo)hubPackageInfo.getFunctionInfo("setupOnStartup"), (BValue[])args);
            }
        }
        return this.hubUrl;
    }

    private void setHubProgramFile(ProgramFile programFile) {
        this.hubProgramFile = programFile;
    }

    ProgramFile getHubProgramFile() {
        return this.hubProgramFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProgramFile readExecutableProgram(Path baloFilePath) {
        ByteArrayInputStream byteIS = null;
        try {
            byte[] byteArray = Files.readAllBytes(baloFilePath);
            ProgramFileReader reader = new ProgramFileReader();
            byteIS = new ByteArrayInputStream(byteArray);
            ProgramFile programFile = reader.readProgram((InputStream)byteIS);
            return programFile;
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteIS != null) {
                try {
                    byteIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

