/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.hub;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.Message;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.ballerinalang.broker.BrokerUtils;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.websub.hub.Hub;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.program.BLangFunctions;

class HubSubscriber
extends Consumer {
    private final String queue;
    private final String topic;
    private final String callback;
    private final BStruct subscriptionDetails;

    HubSubscriber(String queue, String topic, String callback, BStruct subscriptionDetails) {
        this.queue = queue;
        this.topic = topic;
        this.callback = callback;
        this.subscriptionDetails = subscriptionDetails;
    }

    protected void send(Message message) throws BrokerException {
        ProgramFile programFile = Hub.getInstance().getHubProgramFile();
        byte[] bytes = BrokerUtils.retrieveBytes((Message)message);
        BValue[] args = new BValue[]{new BString(this.callback), this.subscriptionDetails, new BJSON(new String(bytes, StandardCharsets.UTF_8))};
        BLangFunctions.invokeCallable((CallableUnitInfo)programFile.getPackageInfo("websub.hub").getFunctionInfo("distributeContent"), (BValue[])args);
    }

    public String getQueueName() {
        return this.queue;
    }

    protected void close() throws BrokerException {
    }

    public boolean isExclusive() {
        return false;
    }

    public boolean isReady() {
        return true;
    }

    public boolean equals(Object subscriberObject) {
        if (subscriberObject instanceof HubSubscriber) {
            HubSubscriber subscriber = (HubSubscriber)((Object)subscriberObject);
            return subscriber.topic.equals(this.topic) && subscriber.callback.equals(this.callback);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.callback);
    }
}

