/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.impl.ConnectorSPIModelHelper;
import org.ballerinalang.connector.impl.StructImpl;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.serviceendpoint.AbstractHttpNativeFunction;
import org.ballerinalang.net.websub.WebSubServicesRegistry;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="initWebSubSubscriberServiceEndpoint", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.websub"))
public class InitWebSubSubscriberServiceEndpoint
extends AbstractHttpNativeFunction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Context context) {
        Struct subscriberServiceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        StructImpl serviceEndpoint = ConnectorSPIModelHelper.createStruct((BStruct)((BStruct)((BStruct)subscriberServiceEndpoint.getVMValue()).getRefField(1)));
        BStruct config = (BStruct)((BStruct)context.getRefArgument(0)).getRefField(0);
        WebSubServicesRegistry webSubServicesRegistry = new WebSubServicesRegistry(new WebSocketServicesRegistry());
        BString topicIdentifier = (BString)config.getRefField(1);
        if (topicIdentifier != null) {
            String stringTopicIdentifier = topicIdentifier.stringValue();
            webSubServicesRegistry.setTopicIdentifier(stringTopicIdentifier);
            if ("TOPIC_ID_HEADER".equals(stringTopicIdentifier)) {
                BString topicHeader = (BString)config.getRefField(2);
                if (topicHeader == null) throw new BallerinaConnectorException("Topic Header not specified to dispatch by Header");
                webSubServicesRegistry.setTopicHeader(topicHeader.stringValue());
            } else if ("TOPIC_ID_PAYLOAD_KEY".equals(stringTopicIdentifier)) {
                BStringArray topicPayloadKeys = (BStringArray)config.getRefField(3);
                if (topicPayloadKeys == null) throw new BallerinaConnectorException("Payload Keys not specified to dispatch by Payload Key");
                webSubServicesRegistry.setTopicPayloadKeys(topicPayloadKeys);
            } else {
                BString topicHeader = (BString)config.getRefField(2);
                BStringArray topicPayloadKeys = (BStringArray)config.getRefField(3);
                if (topicHeader == null || topicPayloadKeys == null) throw new BallerinaConnectorException("Topic Header and/or Payload Keys not specified to dispatch by Topic Header and Payload Key");
                webSubServicesRegistry.setTopicHeader(topicHeader.stringValue());
                webSubServicesRegistry.setTopicPayloadKeys(topicPayloadKeys);
            }
            if (((BMap)config.getRefField(4)).isEmpty()) throw new BallerinaConnectorException("Topic-Resource Map not specified to dispatch by " + stringTopicIdentifier);
            webSubServicesRegistry.setTopicResourceMap((BMap<String, BMap<String, BString>>)((BMap)config.getRefField(4)));
        }
        serviceEndpoint.addNativeData("WEBSUB_SERVICE_REGISTRY", (Object)webSubServicesRegistry);
        context.setReturnValues(new BValue[0]);
    }
}

