/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.serviceendpoint.AbstractHttpNativeFunction;
import org.ballerinalang.net.websub.WebSubServicesRegistry;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="retrieveSubscriptionParameters", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.websub"), returnType={@ReturnType(type=TypeKind.MAP)})
public class RetrieveSubscriptionParameters
extends AbstractHttpNativeFunction {
    public void execute(Context context) {
        Struct subscriberServiceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        Struct serviceEndpoint = subscriberServiceEndpoint.getStructField("serviceEndpoint");
        HttpService httpService = (HttpService)((WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"))).getServicesInfoByInterface().values().toArray()[0];
        BMap subscriptionDetails = new BMap();
        Struct annotationStruct = ((Annotation)httpService.getBalService().getAnnotationList("ballerina.websub", "SubscriberServiceConfig").get(0)).getValue();
        subscriptionDetails.put((Object)"subscribeOnStartUp", (BValue)new BString(Boolean.toString(annotationStruct.getBooleanField("subscribeOnStartUp"))));
        subscriptionDetails.put((Object)"resourceUrl", (BValue)new BString(annotationStruct.getStringField("resourceUrl")));
        subscriptionDetails.put((Object)"hub", (BValue)new BString(annotationStruct.getStringField("hub")));
        subscriptionDetails.put((Object)"topic", (BValue)new BString(annotationStruct.getStringField("topic")));
        subscriptionDetails.put((Object)"leaseSeconds", (BValue)new BString(Long.toString(annotationStruct.getIntField("leaseSeconds"))));
        subscriptionDetails.put((Object)"secret", (BValue)new BString(annotationStruct.getStringField("secret")));
        if (annotationStruct.getRefField("auth") != null) {
            BStruct authConfig = (BStruct)annotationStruct.getRefField("auth").getVMValue();
            subscriptionDetails.put((Object)"auth", (BValue)authConfig);
        } else {
            subscriptionDetails.put((Object)"auth", null);
        }
        if (annotationStruct.getRefField("secureSocket") != null) {
            BStruct secureSocket = (BStruct)annotationStruct.getRefField("secureSocket").getVMValue();
            subscriptionDetails.put((Object)"secureSocket", (BValue)secureSocket);
        } else {
            subscriptionDetails.put((Object)"secureSocket", null);
        }
        String callback = annotationStruct.getStringField("callback");
        if (callback.isEmpty()) {
            callback = httpService.getBasePath();
            BStruct serviceEndpointConfig = (BStruct)((BStruct)serviceEndpoint.getVMValue()).getRefField(3);
            callback = !serviceEndpointConfig.getStringField(0).equals("") && serviceEndpointConfig.getIntField(0) != 0L ? serviceEndpointConfig.getStringField(0) + ":" + serviceEndpointConfig.getIntField(0) + callback : this.getServerConnector(serviceEndpoint).getConnectorID() + callback;
            if (!callback.contains("://")) {
                callback = serviceEndpointConfig.getRefField(2) != null ? "https://".concat(callback) : "http://".concat(callback);
            }
        }
        subscriptionDetails.put((Object)"callback", (BValue)new BString(callback));
        context.setReturnValues(new BValue[]{subscriptionDetails});
    }
}

