/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.websub.hub.Hub;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="validateAndPublishToInternalHub", args={@Argument(name="hubUrl", type=TypeKind.STRING), @Argument(name="topic", type=TypeKind.STRING), @Argument(name="payload", type=TypeKind.JSON)}, returnType={@ReturnType(type=TypeKind.STRING)})
public class ValidateAndPublishToInternalHub
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String errorMessage;
        String hubUrl = context.getStringArgument(0);
        String topic = context.getStringArgument(1);
        BJSON jsonPayload = (BJSON)context.getRefArgument(0);
        Hub hubInstance = Hub.getInstance();
        if (hubInstance.isStarted() && hubInstance.retrieveHubUrl().equals(hubUrl)) {
            String payload = jsonPayload.stringValue();
            errorMessage = Hub.getInstance().publish(topic, payload);
        } else {
            errorMessage = "Internal Ballerina Hub not initialized or incorrectly referenced";
        }
        context.setReturnValues(new BValue[]{new BString(errorMessage)});
    }
}

