/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.xmlutils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;

public class JSONToXMLConverter {
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String NIL = "nil";

    public static XMLValue convertToXML(Object json, String attributePrefix, String arrayEntryTag) {
        if (json == null) {
            return new XMLSequence();
        }
        List<XMLValue> xmlElemList = JSONToXMLConverter.traverseTree(json, attributePrefix, arrayEntryTag);
        if (xmlElemList.size() == 1) {
            return xmlElemList.get(0);
        }
        ArrayList<XMLValue> seq = new ArrayList<XMLValue>(xmlElemList);
        return new XMLSequence(seq);
    }

    private static List<XMLValue> traverseTree(Object json, String attributePrefix, String arrayEntryTag) {
        ArrayList<XMLValue> xmlArray = new ArrayList<XMLValue>();
        if (!(json instanceof RefValue)) {
            XMLValue xml = XMLFactory.parse((String)json.toString());
            xmlArray.add(xml);
        } else {
            JSONToXMLConverter.traverseJsonNode(json, null, null, xmlArray, attributePrefix, arrayEntryTag);
        }
        return xmlArray;
    }

    private static XMLItem traverseJsonNode(Object json, String nodeName, XMLItem parentElement, List<XMLValue> xmlElemList, String attributePrefix, String arrayEntryTag) {
        XMLItem currentRoot = null;
        if (nodeName != null) {
            if (nodeName.startsWith(attributePrefix)) {
                if (json instanceof RefValue) {
                    throw BallerinaErrors.createError((String)"attribute cannot be an object or array");
                }
                if (parentElement != null) {
                    String attributeKey = nodeName.substring(1);
                    parentElement.setAttribute(attributeKey, null, null, json.toString());
                }
                return parentElement;
            }
            XMLValidator.validateXMLName((String)nodeName);
            XMLQName tagName = new XMLQName(nodeName);
            currentRoot = (XMLItem)XMLFactory.createXMLElement((XMLQName)tagName, (BString)null);
        }
        if (json == null) {
            currentRoot.setAttribute(NIL, XSI_NAMESPACE, XSI_PREFIX, "true");
        } else {
            BType type = TypeChecker.getType((Object)json);
            switch (type.getTag()) {
                case 15: {
                    if (((BMapType)type).getConstrainedType().getTag() != 7) {
                        throw BallerinaErrors.createError((String)"error in converting map<non-json> to xml");
                    }
                    MapValueImpl map = (MapValueImpl)json;
                    for (Map.Entry entry : map.entrySet()) {
                        currentRoot = JSONToXMLConverter.traverseJsonNode(entry.getValue(), (String)entry.getKey(), currentRoot, xmlElemList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        xmlElemList.add((XMLValue)currentRoot);
                        currentRoot = null;
                    }
                    break;
                }
                case 7: {
                    MapValueImpl map = (MapValueImpl)json;
                    for (Map.Entry entry : map.entrySet()) {
                        currentRoot = JSONToXMLConverter.traverseJsonNode(entry.getValue(), (String)entry.getKey(), currentRoot, xmlElemList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        xmlElemList.add((XMLValue)currentRoot);
                        currentRoot = null;
                    }
                    break;
                }
                case 20: {
                    ArrayValue array = (ArrayValue)json;
                    for (int i = 0; i < array.size(); ++i) {
                        currentRoot = JSONToXMLConverter.traverseJsonNode(array.getRefValue((long)i), arrayEntryTag, currentRoot, xmlElemList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        xmlElemList.add((XMLValue)currentRoot);
                        currentRoot = null;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (currentRoot == null) {
                        throw BallerinaErrors.createError((String)"error in converting json to xml");
                    }
                    XMLValue text = XMLFactory.createXMLText((String)json.toString());
                    JSONToXMLConverter.addChildElem(currentRoot, text);
                    break;
                }
                default: {
                    throw BallerinaErrors.createError((String)"error in converting json to xml");
                }
            }
        }
        if (parentElement != null) {
            JSONToXMLConverter.addChildElem(parentElement, currentRoot);
            currentRoot = parentElement;
        }
        return currentRoot;
    }

    private static void addChildElem(XMLItem currentRoot, XMLValue child) {
        currentRoot.getChildrenSeq().getChildrenList().add(child);
    }
}

