/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.docgen.generator.model.PageContext;
import org.ballerinalang.docgen.generator.model.Type;

public class Writer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHtmlDocument(Object object, String packageTemplateName, String filePath) throws IOException {
        String templatesFolderPath = System.getProperty("ballerina.home") + File.separator + "lib" + File.separator + "templates";
        String templatesClassPath = System.getProperty("templates.folder.path", "/template/html");
        try (PrintWriter writer = null;){
            Handlebars handlebars = new Handlebars().with(new FileTemplateLoader(templatesFolderPath), new ClassPathTemplateLoader(templatesClassPath));
            handlebars.registerHelpers((Class)StringHelpers.class);
            handlebars.registerHelper("paramSummary", (varList, options) -> varList.stream().map(variable -> Writer.getTypeLabel(variable.type, options.context) + " " + variable.name).collect(Collectors.joining(", ")));
            handlebars.registerHelper("returnParamSummary", (varList, options) -> varList.stream().map(variable -> Writer.getTypeLabel(variable.type, options.context) + " " + variable.name).collect(Collectors.joining(", ")));
            handlebars.registerHelper("unionTypeSummary", (typeList, options) -> typeList.stream().map(type -> Writer.getTypeLabel(type, options.context)).collect(Collectors.joining(" | ")));
            handlebars.registerHelper("pipeJoin", (typeList, options) -> String.join((CharSequence)" | ", typeList));
            handlebars.registerHelper("typeName", (type, options) -> Writer.getTypeLabel(type, options.context));
            handlebars.registerHelper("defVal", (type, options) -> {
                String name = (String)options.param(0);
                Context context = options.context;
                String root = Writer.getRootPath(context);
                String link = root + type.moduleName + "/" + type.category + "/" + name + ".html";
                String defaultValue = type.category.equals("objects") && !name.equals("()") ? "<span class=\"default\">(default</span> <span class=\"type\"><a href=\"" + link + "\">" + name + "</a></span><span class=\"default\">)</span>" : "<span class=\"default\">(default " + name + ")</span>";
                return defaultValue;
            });
            handlebars.registerHelper("editDescription", (description, options) -> {
                String newDescription = description.replaceAll("<pre>(.|\\n)*?<\\/pre>", "");
                newDescription = newDescription.replaceAll("\\.(.|\\n)*", ".");
                return newDescription;
            });
            handlebars.registerHelper("setStyles", (description, options) -> {
                String newDescription = description.replaceAll("<table>", "<table class=\"ui table row-border pad-left\">");
                return newDescription;
            });
            handlebars.registerHelper("removeTags", (string, options) -> {
                if (string != null) {
                    return string.replaceAll("<\\/?[^>]*>", "");
                }
                return "";
            });
            handlebars.registerHelper("equals", (arg1, options) -> {
                Object param0 = options.param(0);
                if (param0 == null) {
                    throw new IllegalArgumentException("found 'null', expected 'string'");
                }
                CharSequence result = arg1 != null ? (arg1.toString().equals(param0.toString()) ? options.fn(options.context) : options.inverse()) : null;
                return result;
            });
            Template template = handlebars.compile(packageTemplateName);
            writer = new PrintWriter(filePath, "UTF-8");
            Context context = Context.newBuilder(object).resolver(new CustomFieldValueResolver()).build();
            writer.println(template.apply(context));
        }
    }

    public static String getTypeLabel(Type type, Context context) {
        String label;
        String root = Writer.getRootPath(context);
        if (type.isAnonymousUnionType) {
            label = type.memberTypes.stream().map(type1 -> Writer.getTypeLabel(type1, context)).collect(Collectors.joining(" | "));
        } else if (type.isTuple) {
            label = "<span>[</span>" + type.memberTypes.stream().map(type1 -> Writer.getTypeLabel(type1, context)).collect(Collectors.joining(", ")) + "<span>]</span>";
        } else if (type.isLambda) {
            label = "<code> <span>function(</span>" + type.paramTypes.stream().map(type1 -> Writer.getTypeLabel(type1, context)).collect(Collectors.joining(", ")) + "<span>) </span>";
            label = type.returnType != null ? label + "<span>returns (</span>" + Writer.getTypeLabel(type.returnType, context) + "<span>)</span>" : label + "<span>() </span>";
            label = label + " </code>";
        } else if (type.isArrayType) {
            label = "<span class=\"array-type\">" + Writer.getTypeLabel(type.elementType, context) + Writer.getSuffixes(type) + "</span>";
        } else if (type.isRestParam) {
            label = "<span class=\"array-type\">" + Writer.getTypeLabel(type.elementType, context) + Writer.getSuffixes(type) + "</span>";
        } else if ("map".equals(type.category) && type.constraint != null) {
            label = "<span class=\"builtin-type\">" + type.name + "</span><" + Writer.getTypeLabel(type.constraint, context) + ">";
        } else if ("stream".equals(type.category)) {
            label = "<span class=\"builtin-type\">" + type.name + "<";
            label = label + type.memberTypes.stream().map(type1 -> Writer.getTypeLabel(type1, context)).collect(Collectors.joining(" ,"));
            label = label + "></span>";
        } else {
            label = "builtin".equals(type.category) || "lang.annotations".equals(type.moduleName) || !type.generateUserDefinedTypeLink || "UNKNOWN".equals(type.category) ? "<span class=\"builtin-type\">" + type.name + Writer.getSuffixes(type) + "</span>" : Writer.getHtmlLink(type, root);
        }
        return label;
    }

    private static String getRootPath(Context context) {
        return Writer.getNearestPageContext((Context)context).rootPath;
    }

    private static PageContext getNearestPageContext(Context context) {
        return context.model() instanceof PageContext ? (PageContext)context.model() : Writer.getNearestPageContext(context.parent());
    }

    private static String getHtmlLink(Type type, String root) {
        String link = root + type.moduleName + "/" + type.category + "/" + type.name + ".html";
        if ("types".equals(type.category) || "constants".equals(type.category) || "annotations".equals(type.category) || "errors".equals(type.category)) {
            link = root + type.moduleName + "/" + type.category + ".html#" + type.name;
        }
        return "<a href=\"" + link + "\">" + type.name + "</a>" + Writer.getSuffixes(type);
    }

    private static String getSuffixes(Type type) {
        String suffix = "";
        if (type.isArrayType) {
            suffix = StringUtils.repeat((String)"[]", (int)type.arrayDimensions);
        } else if (type.isRestParam) {
            suffix = "...";
        }
        suffix = suffix + (type.isNullable ? "?" : "");
        return suffix;
    }

    static class CustomFieldValueResolver
    extends FieldValueResolver {
        CustomFieldValueResolver() {
        }

        @Override
        protected Set<FieldValueResolver.FieldWrapper> members(Class<?> clazz) {
            Set<FieldValueResolver.FieldWrapper> members = super.members(clazz);
            return members.stream().filter(fw -> this.isValidField((FieldValueResolver.FieldWrapper)fw)).collect(Collectors.toSet());
        }

        boolean isValidField(FieldValueResolver.FieldWrapper fw) {
            if (fw instanceof AccessibleObject) {
                return this.isUseSetAccessible(fw);
            }
            return true;
        }
    }
}

