/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.Writer;
import org.ballerinalang.docgen.docs.BallerinaDocDataHolder;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.docs.utils.PathToJson;
import org.ballerinalang.docgen.generator.model.AnnotationsPageContext;
import org.ballerinalang.docgen.generator.model.Client;
import org.ballerinalang.docgen.generator.model.ClientPageContext;
import org.ballerinalang.docgen.generator.model.ConstantsPageContext;
import org.ballerinalang.docgen.generator.model.ErrorsPageContext;
import org.ballerinalang.docgen.generator.model.FunctionsPageContext;
import org.ballerinalang.docgen.generator.model.Listener;
import org.ballerinalang.docgen.generator.model.ListenerPageContext;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.ModulePageContext;
import org.ballerinalang.docgen.generator.model.Object;
import org.ballerinalang.docgen.generator.model.ObjectPageContext;
import org.ballerinalang.docgen.generator.model.Project;
import org.ballerinalang.docgen.generator.model.ProjectPageContext;
import org.ballerinalang.docgen.generator.model.Record;
import org.ballerinalang.docgen.generator.model.RecordPageContext;
import org.ballerinalang.docgen.generator.model.TypesPageContext;
import org.ballerinalang.docgen.model.ModuleDoc;
import org.ballerinalang.model.elements.PackageID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class BallerinaDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(BallerinaDocGenerator.class);
    private static PrintStream out = System.out;
    private static final String MODULE_CONTENT_FILE = "Module.md";
    private static final Path BAL_BUILTIN = Paths.get("ballerina", "builtin");
    private static final String HTML = ".html";
    private static final String DOC_JSON = "api-doc-data.json";
    private static Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (java.lang.Object)new PathToJson()).excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();

    public static void generateApiDocs(String sourceRoot, String output, String moduleFilter, boolean isNative, boolean offline, String ... sources) {
        out.println("docerina: API documentation generation for sources - " + Arrays.toString(sources));
        Map<String, ModuleDoc> docsMap = BallerinaDocGenerator.generateModuleDocsMap(sourceRoot, moduleFilter, isNative, sources, offline);
        if (docsMap.size() == 0) {
            out.println("docerina: no module definitions found!");
            return;
        }
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: generating HTML API documentation...");
        }
        String userDir = System.getProperty("user.dir");
        if (output == null) {
            output = System.getProperty("html.output.path", userDir + File.separator + "target" + File.separator + "api-docs" + File.separator + BallerinaDocDataHolder.getInstance().getVersion());
        }
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: creating output directory: " + output);
        }
        try {
            Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            out.println(String.format("docerina: API documentation generation failed. Couldn't create the [output directory] %s. Cause: %s", output, e.getMessage()));
            log.error(String.format("API documentation generation failed. Couldn't create the [output directory] %s. Cause: %s", output, e.getMessage()), (Throwable)e);
            return;
        }
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: successfully created the output directory: " + output);
        }
        BallerinaDocGenerator.writeAPIDocsForModules(docsMap, output, false);
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: documentation generation is done.");
        }
    }

    public static void writeAPIDocsToJSON(Map<String, ModuleDoc> docsMap, String output) {
        ArrayList<ModuleDoc> moduleDocList = new ArrayList<ModuleDoc>(docsMap.values());
        moduleDocList.sort(Comparator.comparing(pkg -> pkg.bLangPackage.packageID.toString()));
        Project project = BallerinaDocGenerator.getDocsGenModel(moduleDocList);
        File jsonFile = new File(output + File.separator + DOC_JSON);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            String json = gson.toJson((java.lang.Object)project);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to create the api-doc-data.json. Cause: %s", e.getMessage()));
            log.error("Failed to create api-doc-data.json file.", (Throwable)e);
        }
    }

    public static void writeAPIDocsForModulesFromJson(Path jsonpath, String output, boolean excludeIndex) {
        if (jsonpath.toFile().exists()) {
            try (BufferedReader br = Files.newBufferedReader(jsonpath, StandardCharsets.UTF_8);){
                Project project = (Project)gson.fromJson((Reader)br, Project.class);
                if (Files.notExists(Paths.get(output, new String[0]), new LinkOption[0])) {
                    Files.createDirectory(Paths.get(output, new String[0]), new FileAttribute[0]);
                }
                BallerinaDocGenerator.writeAPIDocs(project, output, excludeIndex);
            }
            catch (IOException e) {
                String errorMsg = String.format("API documentation generation failed. Cause: %s", e.getMessage());
                out.println(errorMsg);
                log.error(errorMsg, (Throwable)e);
                return;
            }
        }
    }

    public static void writeAPIDocsForModules(Map<String, ModuleDoc> docsMap, String output, boolean excludeIndex) {
        ArrayList<ModuleDoc> moduleDocList = new ArrayList<ModuleDoc>(docsMap.values());
        moduleDocList.sort(Comparator.comparing(pkg -> pkg.bLangPackage.packageID.toString()));
        Project project = BallerinaDocGenerator.getDocsGenModel(moduleDocList);
        BallerinaDocGenerator.writeAPIDocs(project, output, excludeIndex);
    }

    public static void writeAPIDocs(Project project, String output, boolean excludeIndex) {
        String rootPathConstructLevel;
        if (!excludeIndex) {
            String projectTemplateName = System.getProperty("project.template.name", "index");
            String indexFilePath = output + File.separator + "index" + HTML;
            ProjectPageContext projectPageContext = new ProjectPageContext(project, "API Documentation", "", false);
            try {
                Writer.writeHtmlDocument(projectPageContext, projectTemplateName, indexFilePath);
            }
            catch (IOException e) {
                out.println(String.format("docerina: failed to create the index.html. Cause: %s", e.getMessage()));
                log.error("Failed to create the index.html file.", (Throwable)e);
            }
        }
        String moduleTemplateName = System.getProperty("module.template.name", "module");
        String recordTemplateName = System.getProperty("record.template.name", "record");
        String objectTemplateName = System.getProperty("object.template.name", "object");
        String clientTemplateName = System.getProperty("client.template.name", "client");
        String listenerTemplateName = System.getProperty("listener.template.name", "listener");
        String functionsTemplateName = System.getProperty("functions.template.name", "functions");
        String constantsTemplateName = System.getProperty("constants.template.name", "constants");
        String typesTemplateName = System.getProperty("types.template.name", "types");
        String annotationsTemplateName = System.getProperty("annotations.template.name", "annotations");
        String errorsTemplateName = System.getProperty("errors.template.name", "errors");
        String rootPathModuleLevel = project.isSingleFile ? "./" : "../";
        String string = rootPathConstructLevel = project.isSingleFile ? "../" : "../../";
        if (project.modules == null) {
            String errMessage = "docerina: API documentation generation failed. Couldn't create the [output directory] " + output;
            out.println(errMessage);
            log.error(errMessage);
            return;
        }
        for (Module module : project.modules) {
            String modDir = output + File.separator + module.id;
            try {
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: starting to generate docs for module: " + module.id);
                }
                Files.createDirectories(Paths.get(modDir, new String[0]), new FileAttribute[0]);
                ModulePageContext modulePageContext = new ModulePageContext(module, project, rootPathModuleLevel, "API Docs - " + (project.isSingleFile ? project.sourceFileName : module.orgName + "/" + module.id), excludeIndex);
                String modIndexPath = modDir + File.separator + "index" + HTML;
                Writer.writeHtmlDocument(modulePageContext, moduleTemplateName, modIndexPath);
                if (!module.records.isEmpty()) {
                    String recordsDir = modDir + File.separator + "records";
                    Files.createDirectories(Paths.get(recordsDir, new String[0]), new FileAttribute[0]);
                    for (Record record : module.records) {
                        RecordPageContext recordPageContext = new RecordPageContext(record, module, project, rootPathConstructLevel, "API Docs - Record : " + record.name, excludeIndex);
                        String recordFilePath = recordsDir + File.separator + record.name + HTML;
                        Writer.writeHtmlDocument(recordPageContext, recordTemplateName, recordFilePath);
                    }
                }
                if (!module.objects.isEmpty()) {
                    String objectsDir = modDir + File.separator + "objects";
                    Files.createDirectories(Paths.get(objectsDir, new String[0]), new FileAttribute[0]);
                    for (Object object : module.objects) {
                        ObjectPageContext objectPageContext = new ObjectPageContext(object, module, project, rootPathConstructLevel, "API Docs - Object : " + object.name, excludeIndex);
                        String objectFilePath = objectsDir + File.separator + object.name + HTML;
                        Writer.writeHtmlDocument(objectPageContext, objectTemplateName, objectFilePath);
                    }
                }
                if (!module.clients.isEmpty()) {
                    String clientsDir = modDir + File.separator + "clients";
                    Files.createDirectories(Paths.get(clientsDir, new String[0]), new FileAttribute[0]);
                    for (Client client : module.clients) {
                        ClientPageContext clientPageContext = new ClientPageContext(client, module, project, rootPathConstructLevel, "API Docs - Client : " + client.name, excludeIndex);
                        String clientFilePath = clientsDir + File.separator + client.name + HTML;
                        Writer.writeHtmlDocument(clientPageContext, clientTemplateName, clientFilePath);
                    }
                }
                if (!module.listeners.isEmpty()) {
                    String listenersDir = modDir + File.separator + "listeners";
                    Files.createDirectories(Paths.get(listenersDir, new String[0]), new FileAttribute[0]);
                    for (Listener listener : module.listeners) {
                        ListenerPageContext listenerPageContext = new ListenerPageContext(listener, module, project, rootPathConstructLevel, "API Docs - Listener : " + listener.name, excludeIndex);
                        String listenerFilePath = listenersDir + File.separator + listener.name + HTML;
                        Writer.writeHtmlDocument(listenerPageContext, listenerTemplateName, listenerFilePath);
                    }
                }
                if (!module.functions.isEmpty()) {
                    String functionsFile = modDir + File.separator + "functions" + HTML;
                    FunctionsPageContext functionsPageContext = new FunctionsPageContext(module.functions, module, project, rootPathModuleLevel, "API Docs - Functions : " + module.id, excludeIndex);
                    Writer.writeHtmlDocument(functionsPageContext, functionsTemplateName, functionsFile);
                }
                if (!module.constants.isEmpty()) {
                    String constantsFile = modDir + File.separator + "constants" + HTML;
                    ConstantsPageContext constantsPageContext = new ConstantsPageContext(module.constants, module, project, rootPathModuleLevel, "API Docs - Constants : " + module.id, excludeIndex);
                    Writer.writeHtmlDocument(constantsPageContext, constantsTemplateName, constantsFile);
                }
                if (!module.unionTypes.isEmpty() || !module.finiteTypes.isEmpty()) {
                    String typesFile = modDir + File.separator + "types" + HTML;
                    TypesPageContext typesPageContext = new TypesPageContext(module.unionTypes, module, project, rootPathModuleLevel, "API Docs - Types : " + module.id, excludeIndex);
                    Writer.writeHtmlDocument(typesPageContext, typesTemplateName, typesFile);
                }
                if (!module.annotations.isEmpty()) {
                    String annotationsFile = modDir + File.separator + "annotations" + HTML;
                    AnnotationsPageContext annotationsPageContext = new AnnotationsPageContext(module.annotations, module, project, rootPathModuleLevel, "API Docs - Annotations : " + module.id, excludeIndex);
                    Writer.writeHtmlDocument(annotationsPageContext, annotationsTemplateName, annotationsFile);
                }
                if (!module.errors.isEmpty()) {
                    String errorsFile = modDir + File.separator + "errors" + HTML;
                    ErrorsPageContext errorsPageContext = new ErrorsPageContext(module.errors, module, project, rootPathModuleLevel, "API Docs - Errors : " + module.id, excludeIndex);
                    Writer.writeHtmlDocument(errorsPageContext, errorsTemplateName, errorsFile);
                }
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: generated docs for module: " + module.id);
                }
            }
            catch (IOException e) {
                out.println(String.format("docerina: API documentation generation failed for module %s: %s", module.id, e.getMessage()));
                log.error(String.format("API documentation generation failed for %s", module.id), (Throwable)e);
            }
            if (module.resources.isEmpty()) continue;
            String resourcesDir = modDir + File.separator + "resources";
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("docerina: copying project resources ");
            }
            for (Path resourcePath : module.resources) {
                File resourcesDirFile = new File(resourcesDir);
                try {
                    FileUtils.copyFileToDirectory((File)resourcePath.toFile(), (File)resourcesDirFile);
                }
                catch (IOException e) {
                    out.println(String.format("docerina: failed to copy [resource] %s into [resources directory] %s. Cause: %s", resourcePath.toString(), resourcesDirFile.toString(), e.getMessage()));
                    log.error(String.format("docerina: failed to copy [resource] %s into [resources directory] %s. Cause: %s", resourcePath.toString(), resourcesDirFile.toString(), e.getMessage()), (Throwable)e);
                }
            }
            if (!BallerinaDocUtils.isDebugEnabled()) continue;
            out.println("docerina: successfully copied project resources into " + resourcesDir);
        }
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: copying HTML theme into " + output);
        }
        try {
            BallerinaDocUtils.copyResources("html-template-resources", output);
            BallerinaDocUtils.copyResources("syntax-highlighter", output);
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to copy the docerina-theme resource. Cause: %s", e.getMessage()));
            log.error("Failed to copy the docerina-theme resource.", (Throwable)e);
        }
        if (BallerinaDocUtils.isDebugEnabled()) {
            out.println("docerina: successfully copied HTML theme into " + output);
        }
        try {
            String zipPath = System.getProperty("output.zip.path");
            if (zipPath != null) {
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: generating the documentation zip file.");
                }
                BallerinaDocUtils.packageToZipFile(output, zipPath);
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: successfully generated the documentation zip file.");
                }
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: API documentation zip packaging failed for %s: %s", output, e.getMessage()));
            log.error(String.format("API documentation zip packaging failed for %s", output), (Throwable)e);
        }
    }

    public static Map<String, ModuleDoc> generateModuleDocsFromBLangPackages(String sourceRoot, List<BLangPackage> modules) throws IOException {
        HashMap<String, ModuleDoc> moduleDocMap = new HashMap<String, ModuleDoc>();
        for (BLangPackage bLangPackage : modules) {
            String moduleName = bLangPackage.packageID.name.toString();
            Path absolutePkgPath = BallerinaDocGenerator.getAbsoluteModulePath(sourceRoot, Paths.get(moduleName, new String[0]));
            Path packageMd = BallerinaDocGenerator.getModuleDocPath(absolutePkgPath);
            List<Path> resources = BallerinaDocGenerator.getResourcePaths(absolutePkgPath);
            moduleDocMap.put(moduleName, new ModuleDoc(packageMd == null ? null : packageMd.toAbsolutePath(), resources, bLangPackage));
        }
        return moduleDocMap;
    }

    public static void setPrintStream(PrintStream out) {
        BallerinaDocGenerator.out = out;
    }

    public static Project getDocsGenModel(List<ModuleDoc> moduleDocList) {
        Project project = new Project();
        boolean bl = project.isSingleFile = moduleDocList.size() == 1 && moduleDocList.get((int)0).bLangPackage.packageID.name.value.equals(".");
        if (project.isSingleFile) {
            project.sourceFileName = moduleDocList.get((int)0).bLangPackage.packageID.sourceFileName.value;
        }
        project.name = "";
        project.description = "";
        ArrayList<Module> moduleDocs = new ArrayList<Module>();
        for (ModuleDoc moduleDoc : moduleDocList) {
            Module module = new Module();
            module.id = moduleDoc.bLangPackage.packageID.name.toString();
            module.orgName = moduleDoc.bLangPackage.packageID.orgName.toString();
            String moduleVersion = moduleDoc.bLangPackage.packageID.version.toString();
            module.version = moduleVersion.equals("") ? System.getProperty("version") : moduleVersion;
            module.summary = moduleDoc.summary;
            module.description = moduleDoc.description;
            BallerinaDocGenerator.sortModuleConstructs(moduleDoc.bLangPackage);
            Generator.generateModuleConstructs(module, moduleDoc.bLangPackage);
            module.resources.addAll(moduleDoc.resources);
            moduleDocs.add(module);
        }
        project.modules = moduleDocs;
        return project;
    }

    private static void sortModuleConstructs(BLangPackage bLangPackage) {
        bLangPackage.getFunctions().sort(Comparator.comparing(f -> (f.getReceiver() == null ? "" : f.getReceiver().getName()) + f.getName().getValue()));
        bLangPackage.getAnnotations().sort(Comparator.comparing(a -> a.getName().getValue()));
        bLangPackage.getTypeDefinitions().sort(Comparator.comparing(a -> a.getName().getValue()));
        bLangPackage.getGlobalVariables().sort(Comparator.comparing(a -> a.getName().getValue()));
    }

    private static Map<String, ModuleDoc> generateModuleDocsMap(String sourceRoot, String packageFilter, boolean isNative, String[] sources, boolean offline) {
        for (String source : sources) {
            source = source.trim();
            try {
                BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, source, packageFilter, isNative, offline);
            }
            catch (Exception e) {
                out.println(String.format("docerina: API documentation generation failed for %s: %s", source, e.getMessage()));
                log.error(String.format("API documentation generation failed for %s", source), (Throwable)e);
            }
        }
        return BallerinaDocDataHolder.getInstance().getPackageMap();
    }

    protected static Map<String, ModuleDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, null, true);
    }

    protected static Map<String, ModuleDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter, boolean offline) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, packageFilter, false, offline);
    }

    protected static Map<String, ModuleDoc> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter, boolean isNative, boolean offline) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, Paths.get(packagePath, new String[0]), packageFilter, isNative, offline);
    }

    protected static Map<String, ModuleDoc> generatePackageDocsFromBallerina(String sourceRoot, Path packagePath, String packageFilter, boolean isNative, boolean offline) throws IOException {
        Path absolutePkgPath = BallerinaDocGenerator.getAbsoluteModulePath(sourceRoot, packagePath);
        Path packageMd = BallerinaDocGenerator.getModuleDocPath(absolutePkgPath);
        List<Path> resources = BallerinaDocGenerator.getResourcePaths(absolutePkgPath);
        BallerinaDocDataHolder dataHolder = BallerinaDocDataHolder.getInstance();
        if (!isNative) {
            System.setProperty("skipNatives", "true");
        }
        BLangPackage bLangPackage = null;
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.TYPE_CHECK.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.OFFLINE, Boolean.valueOf(offline).toString());
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.TRUE.toString());
        context.put(SourceDirectory.class, (java.lang.Object)new FileSystemProjectDirectory(Paths.get(sourceRoot, new String[0])));
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        if (!absolutePkgPath.endsWith(BAL_BUILTIN.toString())) {
            Path fileOrPackageName = packagePath.getFileName();
            bLangPackage = compiler.compile(fileOrPackageName == null ? packagePath.toString() : fileOrPackageName.toString());
        }
        if (bLangPackage == null) {
            out.println(String.format("docerina: invalid Ballerina module: %s", packagePath));
        } else {
            String packageName = BallerinaDocGenerator.packageNameToString(bLangPackage.packageID);
            if (BallerinaDocGenerator.isFilteredPackage(packageName, packageFilter)) {
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: module " + packageName + " excluded");
                }
            } else {
                dataHolder.getPackageMap().put(packageName, new ModuleDoc(packageMd == null ? null : packageMd.toAbsolutePath(), resources, bLangPackage));
            }
        }
        return dataHolder.getPackageMap();
    }

    private static List<Path> getResourcePaths(Path absolutePkgPath) throws IOException {
        Path resourcesDirPath = absolutePkgPath.resolve("resources");
        List<Path> resources = new ArrayList<Path>();
        if (resourcesDirPath.toFile().exists()) {
            resources = Files.walk(resourcesDirPath, new FileVisitOption[0]).filter(path -> !path.equals(resourcesDirPath)).collect(Collectors.toList());
        }
        return resources;
    }

    private static Path getModuleDocPath(Path absolutePkgPath) throws IOException {
        Optional<Path> o = Files.find(absolutePkgPath, 1, (path, attr) -> {
            Path fileName = path.getFileName();
            if (fileName != null) {
                return fileName.toString().equals(MODULE_CONTENT_FILE);
            }
            return false;
        }, new FileVisitOption[0]).findFirst();
        Path packageMd = o.isPresent() ? o.get() : null;
        return packageMd;
    }

    private static Path getAbsoluteModulePath(String sourceRoot, Path modulePath) {
        return Paths.get(sourceRoot, new String[0]).resolve("src").resolve(modulePath);
    }

    private static String packageNameToString(PackageID pkgId) {
        String pkgName = pkgId.getName().getValue();
        return ".".equals(pkgName) ? pkgId.sourceFileName.getValue() : pkgName;
    }

    private static boolean isFilteredPackage(String packageName, String packageFilter) {
        if (packageFilter != null && packageFilter.trim().length() > 0) {
            return Arrays.stream(packageFilter.split(",")).anyMatch(e -> packageName.startsWith(e.replace(".*", "")));
        }
        return false;
    }
}

