/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSGlobalContext;
import org.ballerinalang.langserver.LSGlobalContextKeys;
import org.ballerinalang.langserver.WorkspaceServiceOperationContext;
import org.ballerinalang.langserver.command.LSCommandExecutorProvidersHolder;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.config.LSClientConfig;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.symbols.SymbolFindingVisitor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;

public class BallerinaWorkspaceService
implements WorkspaceService {
    private BallerinaLanguageServer languageServer;
    private WorkspaceDocumentManager workspaceDocumentManager;
    private static final Gson GSON = new Gson();
    private LSClientConfigHolder configHolder = LSClientConfigHolder.getInstance();
    private LSClientCapabilities clientCapabilities;

    BallerinaWorkspaceService(LSGlobalContext globalContext) {
        this.languageServer = globalContext.get(LSGlobalContextKeys.LANGUAGE_SERVER_KEY);
        this.workspaceDocumentManager = globalContext.get(LSGlobalContextKeys.DOCUMENT_MANAGER_KEY);
    }

    public void setClientCapabilities(LSClientCapabilities clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList symbols = new ArrayList();
            LSContext symbolsContext = new WorkspaceServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.WS_SYMBOL).build();
            HashMap compUnits = new HashMap();
            try {
                for (Path path : this.workspaceDocumentManager.getAllFilePaths()) {
                    symbolsContext.put(DocumentServiceKeys.SYMBOL_LIST_KEY, symbols);
                    symbolsContext.put(DocumentServiceKeys.FILE_URI_KEY, (Object)path.toUri().toString());
                    List bLangPackage = LSModuleCompiler.getBLangPackages((LSContext)symbolsContext, (WorkspaceDocumentManager)this.workspaceDocumentManager, LSCustomErrorStrategy.class, (boolean)true, (boolean)false, (boolean)false);
                    bLangPackage.forEach(aPackage -> aPackage.compUnits.forEach(compUnit -> {
                        String unitName = compUnit.getName();
                        String sourceRoot = LSCompilerUtil.getProjectRoot((Path)path);
                        String basePath = sourceRoot + File.separator + compUnit.getPosition().src.getPackageName();
                        String hash = this.generateHash((BLangCompilationUnit)compUnit, basePath);
                        compUnits.put(hash, new Object[]{new File(basePath + File.separator + unitName).toURI(), compUnit});
                    }));
                }
                compUnits.values().forEach(compilationUnit -> {
                    symbolsContext.put(DocumentServiceKeys.SYMBOL_LIST_KEY, (Object)symbols);
                    symbolsContext.put(DocumentServiceKeys.FILE_URI_KEY, (Object)compilationUnit[0].toString());
                    symbolsContext.put(DocumentServiceKeys.SYMBOL_QUERY, (Object)params.getQuery());
                    SymbolFindingVisitor visitor = new SymbolFindingVisitor(symbolsContext);
                    ((BLangCompilationUnit)compilationUnit[1]).accept((BLangNodeVisitor)visitor);
                });
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Workspace Symbols", (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Operation 'workspace/symbol' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, null, (Position[])new Position[]{null});
            }
            return symbols.stream().filter(Either::isLeft).map(Either::getLeft).collect(Collectors.toList());
        });
    }

    private String generateHash(BLangCompilationUnit compUnit, String basePath) {
        return compUnit.getPosition().getSource().pkgID.toString() + "$" + basePath + "$" + compUnit.getName();
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        if (!(params.getSettings() instanceof JsonObject)) {
            return;
        }
        JsonObject settings = (JsonObject)params.getSettings();
        if (settings.get("ballerina") != null) {
            this.configHolder.updateConfig((LSClientConfig)GSON.fromJson(settings.get("ballerina"), LSClientConfig.class));
        } else {
            this.configHolder.updateConfig((LSClientConfig)GSON.fromJson((JsonElement)settings, LSClientConfig.class));
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return CompletableFuture.supplyAsync(() -> {
            LSContext executeCmdContext = new WorkspaceServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.WS_EXEC_CMD).withExecuteCommandParams(params.getArguments(), this.workspaceDocumentManager, this.languageServer, this.clientCapabilities).build();
            try {
                Optional<LSCommandExecutor> executor = LSCommandExecutorProvidersHolder.getInstance().getCommandExecutor(params.getCommand());
                if (executor.isPresent()) {
                    return executor.get().execute(executeCmdContext);
                }
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Execute Command", (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Operation 'workspace/executeCommand' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, null, (Position[])new Position[]{null});
            }
            LSClientLogger.logError((String)"Operation 'workspace/executeCommand' failed!", (Throwable)new LSCommandExecutorException("No command executor found for '" + params.getCommand() + "'"), null, (Position[])new Position[]{null});
            return false;
        });
    }
}

