/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.ArrayList;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.codeaction.CodeActionKeys;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSContextImpl;
import org.ballerinalang.langserver.signature.SignatureKeys;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SignatureHelpCapabilities;

public class DocumentServiceOperationContext
extends LSContextImpl {
    private DocumentServiceOperationContext(LSOperation operation) {
        super(operation);
    }

    public static class ServiceOperationContextBuilder
    extends LSContextImpl.ContextBuilder<ServiceOperationContextBuilder> {
        public ServiceOperationContextBuilder(LSOperation operation) {
            super(operation);
        }

        ServiceOperationContextBuilder withCompletionParams(CompletionCapabilities capabilities) {
            this.lsContext.put(CompletionKeys.CLIENT_CAPABILITIES_KEY, (Object)capabilities);
            return this;
        }

        ServiceOperationContextBuilder withHoverParams() {
            this.lsContext.put(DocumentServiceKeys.IS_CACHE_SUPPORTED, (Object)true);
            this.lsContext.put(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED, (Object)true);
            this.lsContext.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)false);
            return this;
        }

        ServiceOperationContextBuilder withSignatureParams(SignatureHelpCapabilities capabilities) {
            this.lsContext.put(SignatureKeys.SIGNATURE_HELP_CAPABILITIES_KEY, (Object)capabilities);
            return this;
        }

        ServiceOperationContextBuilder withDefinitionParams(String fileUri) {
            this.lsContext.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)(!CommonUtil.isCachedExternalSource(fileUri) ? 1 : 0));
            return this;
        }

        ServiceOperationContextBuilder withReferencesParams() {
            this.lsContext.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)true);
            return this;
        }

        ServiceOperationContextBuilder withDocumentSymbolParams(String fileUri) {
            this.lsContext.put(DocumentServiceKeys.FILE_URI_KEY, (Object)fileUri);
            this.lsContext.put(DocumentServiceKeys.SYMBOL_LIST_KEY, new ArrayList());
            return this;
        }

        ServiceOperationContextBuilder withCodeActionParams(Position position) {
            this.lsContext.put(DocumentServiceKeys.IS_CACHE_SUPPORTED, (Object)true);
            this.lsContext.put(CodeActionKeys.POSITION_START_KEY, (Object)position);
            return this;
        }

        ServiceOperationContextBuilder withFormattingParams(String fileUri) {
            this.lsContext.put(DocumentServiceKeys.FILE_URI_KEY, (Object)fileUri);
            return this;
        }

        ServiceOperationContextBuilder withRenameParams() {
            this.lsContext.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)true);
            return this;
        }

        ServiceOperationContextBuilder withStdLibDefinitionParam(boolean enableStdlibDefinition) {
            this.lsContext.put(DocumentServiceKeys.ENABLE_STDLIB_DEFINITION_KEY, (Object)enableStdlibDefinition);
            return this;
        }

        public LSContext build() {
            return this.lsContext;
        }

        protected ServiceOperationContextBuilder self() {
            return this;
        }
    }
}

