/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.AnnotationNodeKind;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSContextManager;
import org.ballerinalang.langserver.compiler.LSPackageCache;
import org.ballerinalang.langserver.compiler.LSPackageLoader;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaPackage;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LSAnnotationCache {
    private static final Logger logger = LoggerFactory.getLogger(LSPackageCache.class);
    private static HashMap<PackageID, List<BAnnotationSymbol>> typeAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> objectAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> functionAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> objectMethodAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> resourceAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> parameterAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> returnAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> serviceAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> listenerAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> annotationAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> externalAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> varAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> constAnnotations = new HashMap();
    private static HashMap<PackageID, List<BAnnotationSymbol>> workerAnnotations = new HashMap();
    private static LSAnnotationCache lsAnnotationCache = null;
    private static List<PackageID> processedPackages = new ArrayList<PackageID>();

    private LSAnnotationCache() {
    }

    public static LSAnnotationCache getInstance() {
        return lsAnnotationCache;
    }

    public static synchronized void initiate() {
        if (lsAnnotationCache == null) {
            lsAnnotationCache = new LSAnnotationCache();
            CompilerContext context = LSContextManager.getInstance().getBuiltInPackagesCompilerContext();
            new Thread(() -> {
                Map<String, BPackageSymbol> packages = LSAnnotationCache.loadPackagesMap(context);
                LSAnnotationCache.loadAnnotations(new ArrayList<BPackageSymbol>(packages.values()));
            }).start();
        }
    }

    private static Map<String, BPackageSymbol> loadPackagesMap(CompilerContext compilerCtx) {
        HashMap<String, BPackageSymbol> staticPackages = new HashMap<String, BPackageSymbol>();
        for (BallerinaPackage sdkPackage : LSPackageLoader.getSdkPackages()) {
            PackageID packageID = new PackageID(new Name(sdkPackage.getOrgName()), new Name(sdkPackage.getPackageName()), Names.DEFAULT_VERSION);
            try {
                Optional bPackageSymbol = LSPackageLoader.getPackageSymbolById((CompilerContext)compilerCtx, (PackageID)packageID);
                if (!bPackageSymbol.isPresent()) continue;
                staticPackages.put(((BPackageSymbol)bPackageSymbol.get()).pkgID.toString(), (BPackageSymbol)bPackageSymbol.get());
            }
            catch (Exception e) {
                logger.warn("Error while loading package :" + sdkPackage.getPackageName());
            }
        }
        return staticPackages;
    }

    private static void loadAnnotations(List<BPackageSymbol> packageList) {
        packageList.forEach(LSAnnotationCache::loadAnnotationsFromPackage);
    }

    private static void addAttachment(BAnnotationSymbol bAnnotationSymbol, HashMap<PackageID, List<BAnnotationSymbol>> map, PackageID packageID) {
        if (map.containsKey(packageID)) {
            map.get(packageID).add(bAnnotationSymbol);
            return;
        }
        map.put(packageID, new ArrayList<BAnnotationSymbol>(Collections.singletonList(bAnnotationSymbol)));
    }

    public HashMap<PackageID, List<BAnnotationSymbol>> getAnnotationMapForType(AnnotationNodeKind attachmentPoint, LSContext ctx) {
        HashMap<Object, List<Object>> annotationMap;
        CompilerContext compilerCtx = (CompilerContext)ctx.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        ((BLangPackage)ctx.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY)).getImports().forEach(importPackage -> {
            if (importPackage.symbol != null && !this.isPackageProcessed(importPackage.symbol.pkgID) && !importPackage.symbol.pkgID.getName().getValue().equals("runtime")) {
                Optional pkgSymbol = LSPackageLoader.getPackageSymbolById((CompilerContext)compilerCtx, (PackageID)importPackage.symbol.pkgID);
                pkgSymbol.ifPresent(LSAnnotationCache::loadAnnotationsFromPackage);
            }
        });
        switch (attachmentPoint) {
            case SERVICE: {
                annotationMap = serviceAnnotations;
                break;
            }
            case RESOURCE: {
                annotationMap = resourceAnnotations;
                break;
            }
            case FUNCTION: {
                annotationMap = functionAnnotations;
                break;
            }
            case LISTENER: {
                annotationMap = listenerAnnotations;
                break;
            }
            case EXTERNAL: {
                annotationMap = externalAnnotations;
                break;
            }
            case WORKER: {
                annotationMap = workerAnnotations;
                break;
            }
            case CONSTANT: {
                annotationMap = constAnnotations;
                break;
            }
            default: {
                annotationMap = new HashMap();
            }
        }
        return annotationMap;
    }

    public List<BAnnotationSymbol> getAnnotations() {
        ArrayList<BAnnotationSymbol> annotations = new ArrayList<BAnnotationSymbol>();
        typeAnnotations.values().forEach(annotations::addAll);
        objectAnnotations.values().forEach(annotations::addAll);
        functionAnnotations.values().forEach(annotations::addAll);
        objectMethodAnnotations.values().forEach(annotations::addAll);
        resourceAnnotations.values().forEach(annotations::addAll);
        parameterAnnotations.values().forEach(annotations::addAll);
        returnAnnotations.values().forEach(annotations::addAll);
        serviceAnnotations.values().forEach(annotations::addAll);
        listenerAnnotations.values().forEach(annotations::addAll);
        annotationAnnotations.values().forEach(annotations::addAll);
        externalAnnotations.values().forEach(annotations::addAll);
        varAnnotations.values().forEach(annotations::addAll);
        constAnnotations.values().forEach(annotations::addAll);
        return annotations;
    }

    private static void loadAnnotationsFromPackage(BPackageSymbol bPackageSymbol) {
        List<Scope.ScopeEntry> scopeEntries = LSAnnotationCache.extractAnnotationDefinitions(bPackageSymbol.scope.entries);
        scopeEntries.forEach(annotationEntry -> {
            if (annotationEntry.symbol instanceof BAnnotationSymbol && (annotationEntry.symbol.flags & 1) == 1) {
                BAnnotationSymbol annotationSymbol = (BAnnotationSymbol)annotationEntry.symbol;
                int attachPoints = ((BAnnotationSymbol)annotationEntry.symbol).maskedPoints;
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)1)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, typeAnnotations, bPackageSymbol.pkgID);
                    LSAnnotationCache.addAttachment(annotationSymbol, objectAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)2)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, objectAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)4)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, functionAnnotations, bPackageSymbol.pkgID);
                    LSAnnotationCache.addAttachment(annotationSymbol, objectMethodAnnotations, bPackageSymbol.pkgID);
                    LSAnnotationCache.addAttachment(annotationSymbol, resourceAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)8)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, objectMethodAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)16)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, resourceAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)32)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, parameterAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)64)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, returnAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)128)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, serviceAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)2048)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, listenerAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)4096)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, annotationAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)8192)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, externalAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)16384)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, varAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)32768)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, constAnnotations, bPackageSymbol.pkgID);
                }
                if (Symbols.isAttachPointPresent((int)attachPoints, (int)65536)) {
                    LSAnnotationCache.addAttachment(annotationSymbol, workerAnnotations, bPackageSymbol.pkgID);
                }
            }
        });
        processedPackages.add(bPackageSymbol.pkgID);
    }

    private static List<Scope.ScopeEntry> extractAnnotationDefinitions(Map<Name, Scope.ScopeEntry> scopeEntries) {
        return scopeEntries.entrySet().stream().filter(entry -> ((Scope.ScopeEntry)entry.getValue()).symbol.kind == SymbolKind.ANNOTATION).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private boolean isPackageProcessed(PackageID packageID) {
        return processedPackages.stream().anyMatch(processedPkgId -> processedPkgId.toString().equals(packageID.toString()));
    }
}

