/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextEdit;

public class SnippetBlock {
    private String label = "";
    private String detail = "";
    private String snippet;
    private SnippetType snippetType;
    private final Pair<String, String>[] imports;

    public SnippetBlock(String snippet, SnippetType snippetType) {
        this.snippet = snippet;
        this.snippetType = snippetType;
        this.imports = null;
    }

    public SnippetBlock(String label, String snippet, String detail, SnippetType snippetType) {
        this.label = label;
        this.snippet = snippet;
        this.detail = detail;
        this.snippetType = snippetType;
        this.imports = null;
    }

    public SnippetBlock(String label, String snippet, String detail, SnippetType snippetType, Pair<String, String> ... importsByOrgAndAlias) {
        this.label = label;
        this.snippet = snippet;
        this.detail = detail;
        this.snippetType = snippetType;
        this.imports = importsByOrgAndAlias;
    }

    public CompletionItem build(LSContext ctx) {
        CompletionItem completionItem = new CompletionItem();
        completionItem.setInsertText(this.snippet);
        List currentDocImports = (List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY);
        if (this.imports != null) {
            ArrayList<TextEdit> importTextEdits = new ArrayList<TextEdit>();
            for (Pair<String, String> pair : this.imports) {
                boolean pkgAlreadyImported = currentDocImports.stream().anyMatch(importPkg -> importPkg.orgName.value.equals(pair.getLeft()) && importPkg.alias.value.equals(pair.getRight()));
                if (pkgAlreadyImported) continue;
                importTextEdits.addAll(CommonUtil.getAutoImportTextEdits((String)pair.getLeft(), (String)pair.getRight(), ctx));
            }
            completionItem.setAdditionalTextEdits(importTextEdits);
        }
        if (!this.label.isEmpty()) {
            completionItem.setLabel(this.label);
        }
        if (!this.detail.isEmpty()) {
            completionItem.setDetail(this.detail);
        }
        completionItem.setKind(this.getKind());
        return completionItem;
    }

    public String getString() {
        return this.snippet;
    }

    private CompletionItemKind getKind() {
        switch (this.snippetType) {
            case KEYWORD: {
                return CompletionItemKind.Keyword;
            }
        }
        return CompletionItemKind.Snippet;
    }

    public String getLabel() {
        return this.label;
    }

    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    public static enum SnippetType {
        KEYWORD,
        SNIPPET,
        STATEMENT;

    }
}

