/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.SnippetBlock;
import org.ballerinalang.langserver.common.utils.CommonUtil;

public class SnippetGenerator {
    private SnippetGenerator() {
    }

    public static SnippetBlock getAbortSnippet() {
        return new SnippetBlock("abort", "abort;", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getAnnotationDefSnippet() {
        String snippet = "annotation ${1:typeName} ${2:name} on ${3:attachmentPoint};";
        return new SnippetBlock("annotation", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getOnSnippet() {
        return new SnippetBlock("on", "on ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getNewKeywordSnippet() {
        return new SnippetBlock("new", "new ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getAbstractKeywordSnippet() {
        return new SnippetBlock("abstract", "abstract ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getClientKeywordSnippet() {
        return new SnippetBlock("client", "client ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getExternalKeywordSnippet() {
        return new SnippetBlock("external", "external;", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getTypeofKeywordSnippet() {
        return new SnippetBlock("typeof", "typeof ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getBreakSnippet() {
        return new SnippetBlock("break", "break;", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getMatchExpressionSnippet() {
        String snippet = "but {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("but", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getCheckKeywordSnippet() {
        return new SnippetBlock("check", "check ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getCheckPanicKeywordSnippet() {
        return new SnippetBlock("checkpanic", "checkpanic ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getWaitKeywordSnippet() {
        return new SnippetBlock("wait", "wait ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getStartKeywordSnippet() {
        return new SnippetBlock("start", "start ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getFlushKeywordSnippet() {
        return new SnippetBlock("flush", "flush ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getImportKeywordSnippet() {
        return new SnippetBlock("import", "import ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getFunctionKeywordSnippet() {
        return new SnippetBlock("function", "function ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getResourceKeywordSnippet() {
        return new SnippetBlock("resource", "resource ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getContinueStatmentSnippet() {
        return new SnippetBlock("continue", "continue;", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getListenerKeywordSnippet() {
        return new SnippetBlock("listener", "listener ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getReturnsKeywordSnippet() {
        return new SnippetBlock("returns", "returns ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getUntaintKeywordSnippet() {
        return new SnippetBlock("untainted", "untainted ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getForeachSnippet() {
        String snippet = "foreach ${1:var} ${2:item} in ${3:itemList} {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("foreach", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getForkStatementSnippet() {
        String snippet = "fork {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("fork", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getFunctionDefSnippet() {
        String snippet = "function ${1:name}(${2}) {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getFunctionSignatureSnippet() {
        String snippet = "function ${1:name}(${2});";
        return new SnippetBlock("function signature", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIfStatementSnippet() {
        String snippet = "if (${1:true}) {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("if", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getElseIfStatementSnippet() {
        String snippet = "else if (${1:true}) {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("else if", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getElseStatementSnippet() {
        String snippet = "else {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("else", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getLengthofKeywordSnippet() {
        return new SnippetBlock("lengthof", "lengthof ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getLockStatementSnippet() {
        String snippet = "lock {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("lock", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getMainFunctionSnippet() {
        String snippet = "public function main() {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("public main function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getMatchStatementSnippet() {
        return new SnippetBlock("match", "match ", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getNamespaceDeclarationSnippet() {
        String snippet = "xmlns \"${1}\" as ${2:ns};";
        return new SnippetBlock("xmlns", snippet, "Snippet", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getObjectDefinitionSnippet() {
        String snippet = "type ${1:ObjectName} object {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("type <ObjectName> object", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getPublicKeywordSnippet() {
        return new SnippetBlock("public", "public ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getPrivateKeywordSnippet() {
        return new SnippetBlock("private", "private ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getTypeKeywordSnippet() {
        return new SnippetBlock("type", "type ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getRecordKeywordSnippet() {
        return new SnippetBlock("record", "record ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getObjectKeywordSnippet() {
        return new SnippetBlock("object", "object ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getAnnotationKeywordSnippet() {
        return new SnippetBlock("Annotation", "annotation ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getRecordDefinitionSnippet() {
        String snippet = "type ${1:RecordName} record {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("type <RecordName> record", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getClosedRecordDefinitionSnippet() {
        String snippet = "type ${1:RecordName} record {|" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "|};";
        return new SnippetBlock("type <RecordName> closed record", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getResourceDefinitionSnippet() {
        ImmutablePair httpImport = new ImmutablePair((Object)"ballerina", (Object)"http");
        String snippet = "resource function ${1:newResource}(http:Caller ${2:caller}, ${3:http:Request request}) {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("http resource", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{httpImport});
    }

    public static SnippetBlock getCommonResourceDefinitionSnippet() {
        String snippet = "resource function ${1:newResource}(${2}) {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("resource", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getGRPCResourceDefinitionSnippet() {
        ImmutablePair httpImport = new ImmutablePair((Object)"ballerina", (Object)"http");
        String snippet = "resource function ${1:newResource}(grpc:Caller ${2:caller}, ${3:string request}) {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("resource", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{httpImport});
    }

    public static SnippetBlock getWebSocketResourceOnOpenSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onOpen", "websocket onOpen", Collections.singletonList("http:WebSocketCaller ${#:caller}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnTextSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onText", "websocket onText", Arrays.asList("http:WebSocketCaller ${#:caller}", "string ${#:data}", "boolean ${#:finalFrame}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnBinarySnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onBinary", "websocket onBinary", Arrays.asList("http:WebSocketCaller ${#:caller}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnPingSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onPing", "websocket onPing", Arrays.asList("http:WebSocketCaller ${#:caller}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnPongSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onPong", "websocket onPong", Arrays.asList("http:WebSocketCaller ${#:caller}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnIdleTimeoutSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onIdleTimeout", "websocket onIdleTimeout", Collections.singletonList("http:WebSocketCaller ${#:caller}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnErrorSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onError", "websocket onError", Arrays.asList("http:WebSocketCaller ${#:caller}", "error ${#:err}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketResourceOnCloseSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onClose", "websocket onClose", Arrays.asList("http:WebSocketCaller ${#:caller}", "int ${#:statusCode}", "string ${#:reason}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnTextSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onText", "websocketClient onText", Arrays.asList("http:WebSocketClient ${#:wsEp}", "string ${#:data}", "boolean ${#:finalFrame}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnBinarySnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onBinary", "websocketClient onBinary", Arrays.asList("http:WebSocketClient ${#:wsEp}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnPingSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onPing", "websocketClient onPing", Arrays.asList("http:WebSocketClient ${#:wsEp}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnPongSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onPong", "websocketClient onPong", Arrays.asList("http:WebSocketClient ${#:wsEp}", "byte[] ${#:data}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnIdleTimeoutSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onIdleTimeout", "websocketClient onIdleTimeout", Collections.singletonList("http:WebSocketClient ${#:wsEp}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnErrorSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onError", "websocketClient onError", Arrays.asList("http:WebSocketClient ${#:wsEp}", "error ${#:err}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSocketClientServiceResourceOnCloseSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onClose", "websocketClient onClose", Arrays.asList("http:WebSocketClient ${#:wsEp}", "int ${#:statusCode}", "string ${#:reason}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"http"));
    }

    public static SnippetBlock getWebSubResourceOnIntentVerificationSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onIntentVerification", "onIntentVerification", Arrays.asList("websub:Caller ${#:caller}", "websub:IntentVerificationRequest ${#:request}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"websub"));
    }

    public static SnippetBlock getWebSubResourceOnNotificationSnippet() {
        return SnippetGenerator.getResourceDefinitionSnippet("onNotification", "onNotification", Collections.singletonList("websub:Notification ${#:notification}"), (Pair<String, String>)new ImmutablePair((Object)"ballerina", (Object)"websub"));
    }

    private static SnippetBlock getResourceDefinitionSnippet(String name, String label, List<String> params, Pair<String, String> orgToAliasImport) {
        StringJoiner paramsJoiner = new StringJoiner(",");
        IntStream.range(0, params.size()).forEach(i -> paramsJoiner.add(((String)params.get(i)).replace("#", String.valueOf(i + 1))));
        String snippet = "resource function " + name + "(" + paramsJoiner.toString() + ") {" + CommonUtil.LINE_SEPARATOR + "\t${" + (1 + params.size()) + "}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock(label + " " + "resource", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, orgToAliasImport);
    }

    public static SnippetBlock getRetryStatementSnippet() {
        return new SnippetBlock("retry", "retry;", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getReturnStatementSnippet() {
        return new SnippetBlock("return", "return ", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getServiceDefSnippet() {
        ImmutablePair httpImport = new ImmutablePair((Object)"ballerina", (Object)"http");
        String snippet = "service ${1:serviceName} on new http:Listener(8080) {" + CommonUtil.LINE_SEPARATOR + "\tresource function ${2:newResource}(http:Caller ${3:caller}, http:Request ${5:request}) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("service/http", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{httpImport});
    }

    public static SnippetBlock getServiceVarSnippet() {
        String snippet = "service {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("service", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getWebSocketServiceDefSnippet() {
        ImmutablePair httpImport = new ImmutablePair((Object)"ballerina", (Object)"http");
        String snippet = "service ${1:serviceName} on new http:Listener(9090) {" + CommonUtil.LINE_SEPARATOR + "\tresource function onOpen(http:WebSocketCaller caller) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "\tresource function onText(http:WebSocketCaller caller, string data, boolean finalFrame) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "\tresource function onClose(http:WebSocketCaller caller, int statusCode, string reason) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("service/webSocket", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{httpImport});
    }

    public static SnippetBlock getWebSocketClientServiceDefSnippet() {
        ImmutablePair httpImport = new ImmutablePair((Object)"ballerina", (Object)"http");
        String snippet = "service ${1:clientCallbackService} = @http:WebSocketServiceConfig {} service {" + CommonUtil.LINE_SEPARATOR + "\tresource function onText(http:WebSocketClient wsEp, string text) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "\tresource function onClose(http:WebSocketClient wsEp, int statusCode, string reason) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("service/webSocketClient", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{httpImport});
    }

    public static SnippetBlock getWebSubServiceDefSnippet() {
        ImmutablePair websubImport = new ImmutablePair((Object)"ballerina", (Object)"websub");
        String snippet = "service ${1:websubSubscriber} on new websub:Listener(9092) {" + CommonUtil.LINE_SEPARATOR + "\tresource function onIntentVerification(websub:Caller caller, websub:IntentVerificationRequest request) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "\tresource function onNotification(websub:Notification notification) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("service/webSub", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{websubImport});
    }

    public static SnippetBlock getGRPCServiceDefSnippet() {
        ImmutablePair grpcImport = new ImmutablePair((Object)"ballerina", (Object)"grpc");
        String snippet = "service ${1:serviceName} on new grpc:Listener(9092) {" + CommonUtil.LINE_SEPARATOR + "\tresource function ${2:newResource}(grpc:Caller caller, ${3:string} request) {" + CommonUtil.LINE_SEPARATOR + "\t\t" + CommonUtil.LINE_SEPARATOR + "\t}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("service/gRPC", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET, new Pair[]{grpcImport});
    }

    public static SnippetBlock getPanicStatementSnippet() {
        return new SnippetBlock("panic", "panic ", "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getConstKeywordSnippet() {
        return new SnippetBlock("const", "const ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getFinalKeywordSnippet() {
        return new SnippetBlock("final", "final ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getTransactionStatementSnippet() {
        String snippet = "transaction with retries = ${1:0} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "} onretry {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "} committed {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "} aborted {" + CommonUtil.LINE_SEPARATOR + "\t${5}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("transaction", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getTrapSnippet() {
        String snippet = "trap ";
        return new SnippetBlock("trap", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getVarKeywordSnippet() {
        return new SnippetBlock("var", "var ", "Keyword", SnippetBlock.SnippetType.KEYWORD);
    }

    public static SnippetBlock getWhileStatementSnippet() {
        String snippet = "while (${1:true}) {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("while", snippet, "Statement", SnippetBlock.SnippetType.STATEMENT);
    }

    public static SnippetBlock getWorkerDeclarationSnippet() {
        String snippet = "worker ${1:name} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("worker", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getErrorDefinitionSnippet() {
        String snippet = "error ${1:name} = error(\"${2:errorCode}\", message = \"${3}\");";
        return new SnippetBlock("error", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getErrorConstructorSnippet() {
        String snippet = "error(\"${1:errorCode}\", message = \"${2}\");";
        return new SnippetBlock("error", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableForeachSnippet() {
        String snippet = "foreach(function(%params%) {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "});";
        return new SnippetBlock("foreach(<@lambda:function>)", snippet, "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableMapSnippet() {
        String snippet = "map(function (%params%) returns any {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "})";
        return new SnippetBlock("map(<@lambda:function>)", snippet, "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableFilterSnippet() {
        String snippet = "filter(function(%params%) returns (boolean) {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "})";
        return new SnippetBlock("filter(<@lambda:function>)", snippet, "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableCountSnippet() {
        return new SnippetBlock("count()", "count()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinLengthSnippet() {
        return new SnippetBlock("length()", "length()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinIsCloneSnippet() {
        return new SnippetBlock("clone()", "clone()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinFreezeSnippet() {
        return new SnippetBlock("freeze()", "freeze()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinIsFrozenSnippet() {
        return new SnippetBlock("isFrozen()", "isFrozen()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinStampSnippet() {
        return new SnippetBlock("stamp(anydata a)", "stamp(${1})", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinHasKeySnippet() {
        return new SnippetBlock("hasKey(string s)", "hasKey(${1})", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinRemoveSnippet() {
        return new SnippetBlock("remove(string s)", "remove(${1})", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinValuesSnippet() {
        return new SnippetBlock("values()", "values()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinKeysSnippet() {
        return new SnippetBlock("keys()", "keys()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinClearSnippet() {
        return new SnippetBlock("clear()", "clear()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinConvertSnippet() {
        return new SnippetBlock("convert(anydata a)", "convert(${1})", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinIsNaNSnippet() {
        return new SnippetBlock("isNaN()", "isNaN()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinIsFiniteSnippet() {
        return new SnippetBlock("isFinite()", "isFinite()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinIsInFiniteSnippet() {
        return new SnippetBlock("isInfinite()", "isInfinite()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinDetailSnippet() {
        return new SnippetBlock("detail()", "detail()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getBuiltinReasonSnippet() {
        return new SnippetBlock("reason()", "reason()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableSelectSnippet() {
        return new SnippetBlock("select(functionReference)", "select(${1:functionReference})", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableMinSnippet() {
        return new SnippetBlock("min()", "min()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableMaxSnippet() {
        return new SnippetBlock("max()", "max()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableAverageSnippet() {
        return new SnippetBlock("average()", "average()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableSumSnippet() {
        return new SnippetBlock("sum()", "sum()", "", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableOnMapParamSnippet() {
        return new SnippetBlock("(%key%, %value%) entry", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableOnJsonParamSnippet() {
        return new SnippetBlock("json v", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getIterableOnXmlParamSnippet() {
        return new SnippetBlock("xml v", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getRemoteFunctionSnippet() {
        String snippet = "public remote function ${1:name}(${2}) {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("remote function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getInitFunctionSnippet() {
        String snippet = "public function __init(${1:any arg}) {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("init function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getAttachFunctionSnippet() {
        String snippet = "public function __attach(service ${1:s}, string? ${2:name} = ()) returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("attach function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getStartFunctionSnippet() {
        String snippet = "public function __start() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("start function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getGracefulStopFunctionSnippet() {
        String snippet = "public function __gracefulStop() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("graceful stop function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getImmediateStopFunctionSnippet() {
        String snippet = "public function __immediateStop() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("immediate stop function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }

    public static SnippetBlock getDetachFunctionSnippet() {
        String snippet = "public function __detach(service ${1:s}) returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("detach function", snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
    }
}

