/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.codeaction.CodeActionProvidersHolder;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class CodeActionRouter {
    public static List<CodeAction> getBallerinaCodeActions(CodeActionNodeType nodeType, LSContext context, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        Map<CodeActionNodeType, List<LSCodeActionProvider>> nodeBasedProviders;
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        CodeActionProvidersHolder codeActionProvidersHolder = CodeActionProvidersHolder.getInstance();
        if (nodeType != null && (nodeBasedProviders = codeActionProvidersHolder.getNodeBasedProviders()).containsKey(nodeType)) {
            nodeBasedProviders.get(nodeType).forEach(provider -> {
                try {
                    List codeActionList = provider.getNodeBasedCodeActions(nodeType, context, allDiagnostics);
                    if (codeActionList != null) {
                        codeActions.addAll(codeActionList);
                    }
                }
                catch (Exception e) {
                    String msg = "CodeAction '" + provider.getClass().getSimpleName() + "' failed!";
                    LSClientLogger.logError((String)msg, (Throwable)e, null, (Position[])new Position[]{null});
                }
            });
        }
        if (diagnosticsOfRange != null && diagnosticsOfRange.size() > 0) {
            codeActionProvidersHolder.getDiagnosticsBasedProviders().forEach(provider -> {
                try {
                    List codeActionList = provider.getDiagBasedCodeActions(nodeType, context, diagnosticsOfRange, allDiagnostics);
                    if (codeActionList != null) {
                        codeActions.addAll(codeActionList);
                    }
                }
                catch (Exception e) {
                    String msg = "CodeAction '" + provider.getClass().getSimpleName() + "' failed!";
                    LSClientLogger.logError((String)msg, (Throwable)e, null, (Position[])new Position[]{null});
                }
            });
        }
        return codeActions;
    }
}

