/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CursorSymbolFindingVisitor;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionKeys;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CodeActionUtil {
    private static final Logger logger = LoggerFactory.getLogger(CodeActionUtil.class);

    private CodeActionUtil() {
    }

    public static CodeActionNodeType topLevelNodeInLine(LSContext context, TextDocumentIdentifier identifier, int cursorLine, WorkspaceDocumentManager docManager) {
        Optional<Path> filePath = CommonUtil.getPathFromURI(identifier.getUri());
        if (!filePath.isPresent()) {
            return null;
        }
        try {
            BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
            String relativeSourcePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
            BLangPackage evalPkg = CommonUtil.getSourceOwnerBLangPackage(relativeSourcePath, bLangPackage);
            List<Object> diagnostics = new ArrayList<org.ballerinalang.util.diagnostic.Diagnostic>();
            CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
            if (compilerContext.get(DiagnosticListener.class) instanceof CollectDiagnosticListener) {
                diagnostics = ((CollectDiagnosticListener)compilerContext.get(DiagnosticListener.class)).getDiagnostics();
            }
            context.put(CodeActionKeys.DIAGNOSTICS_KEY, CodeActionUtil.toDiagnostics(diagnostics));
            Optional<BLangCompilationUnit> filteredCUnit = evalPkg.compUnits.stream().filter(cUnit -> cUnit.getPosition().getSource().cUnitName.replace("/", CommonUtil.FILE_SEPARATOR).equals(relativeSourcePath)).findAny();
            if (!filteredCUnit.isPresent()) {
                return null;
            }
            for (TopLevelNode topLevelNode : filteredCUnit.get().getTopLevelNodes()) {
                DiagnosticPos diagnosticPos = CommonUtil.toZeroBasedPosition(((BLangNode)topLevelNode).pos);
                if (topLevelNode instanceof BLangService) {
                    if (diagnosticPos.sLine == cursorLine) {
                        return CodeActionNodeType.SERVICE;
                    }
                    if (cursorLine > diagnosticPos.sLine && cursorLine < diagnosticPos.eLine) {
                        for (BLangFunction resourceFunction : ((BLangService)topLevelNode).resourceFunctions) {
                            diagnosticPos = CommonUtil.toZeroBasedPosition(resourceFunction.getName().pos);
                            if (diagnosticPos.sLine != cursorLine) continue;
                            return CodeActionNodeType.RESOURCE;
                        }
                    }
                }
                if (topLevelNode instanceof BLangImportPackage && cursorLine == diagnosticPos.sLine) {
                    return CodeActionNodeType.IMPORTS;
                }
                if (topLevelNode instanceof BLangFunction && !((BLangFunction)topLevelNode).flagSet.contains(Flag.ANONYMOUS) && cursorLine == diagnosticPos.sLine) {
                    return CodeActionNodeType.FUNCTION;
                }
                if (topLevelNode instanceof BLangTypeDefinition && ((BLangTypeDefinition)topLevelNode).typeNode instanceof BLangRecordTypeNode && cursorLine == diagnosticPos.sLine) {
                    return CodeActionNodeType.RECORD;
                }
                if (!(topLevelNode instanceof BLangTypeDefinition) || !(((BLangTypeDefinition)topLevelNode).typeNode instanceof BLangObjectTypeNode)) continue;
                if (diagnosticPos.sLine == cursorLine) {
                    return CodeActionNodeType.OBJECT;
                }
                if (cursorLine <= diagnosticPos.sLine || cursorLine >= diagnosticPos.eLine) continue;
                for (BLangFunction resourceFunction : ((BLangObjectTypeNode)((BLangTypeDefinition)topLevelNode).typeNode).functions) {
                    diagnosticPos = CommonUtil.toZeroBasedPosition(resourceFunction.getName().pos);
                    if (diagnosticPos.sLine != cursorLine) continue;
                    return CodeActionNodeType.OBJECT_FUNCTION;
                }
            }
            return null;
        }
        catch (CompilationFailedException e) {
            logger.error("Error while compiling the source");
            return null;
        }
    }

    public static List<Diagnostic> toDiagnostics(List<org.ballerinalang.util.diagnostic.Diagnostic> ballerinaDiags) {
        ArrayList<Diagnostic> lsDiagnostics = new ArrayList<Diagnostic>();
        ballerinaDiags.forEach(diagnostic -> {
            Diagnostic lsDiagnostic = new Diagnostic();
            lsDiagnostic.setSeverity(DiagnosticSeverity.Error);
            lsDiagnostic.setMessage(diagnostic.getMessage());
            Range range = new Range();
            int startLine = diagnostic.getPosition().getStartLine() - 1;
            int startChar = diagnostic.getPosition().getStartColumn() - 1;
            int endLine = diagnostic.getPosition().getEndLine() - 1;
            int endChar = diagnostic.getPosition().getEndColumn() - 1;
            if (endLine <= 0) {
                endLine = startLine;
            }
            if (endChar <= 0) {
                endChar = startChar + 1;
            }
            range.setStart(new Position(startLine, startChar));
            range.setEnd(new Position(endLine, endChar));
            lsDiagnostic.setRange(range);
            lsDiagnostics.add(lsDiagnostic);
        });
        return lsDiagnostics;
    }

    public static SymbolReferencesModel.Reference getSymbolAtCursor(LSContext context, LSDocumentIdentifier document, Position position) throws WorkspaceDocumentException, CompilationFailedException {
        TextDocumentIdentifier textDocIdentifier = new TextDocumentIdentifier(document.getURIString());
        TextDocumentPositionParams pos = new TextDocumentPositionParams(textDocIdentifier, position);
        context.put(DocumentServiceKeys.POSITION_KEY, (Object)pos);
        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)document.getURIString());
        context.put(DocumentServiceKeys.COMPILE_FULL_PROJECT, (Object)true);
        List<BLangPackage> modules = ReferencesUtil.findCursorTokenAndCompileModules(context, false);
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = CodeActionUtil.findSymbol(modules, context);
        context.put(DocumentServiceKeys.BLANG_PACKAGES_CONTEXT_KEY, modules);
        return symbolAtCursor.orElse(null);
    }

    private static Optional<SymbolReferencesModel.Reference> findSymbol(List<BLangPackage> modules, LSContext context) {
        String currentPkgName = (String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        String relativePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        String currentCUnitName = relativePath.replace("\\", "/");
        Optional<BLangPackage> currentPkg = modules.stream().filter(pkg -> pkg.symbol.getName().getValue().equals(currentPkgName)).findAny();
        if (!currentPkg.isPresent()) {
            throw new UserErrorException("Not supported due to compilation failures!");
        }
        BLangPackage sourceOwnerPkg = CommonUtil.getSourceOwnerBLangPackage(relativePath, currentPkg.get());
        Optional<BLangCompilationUnit> currentCUnit = sourceOwnerPkg.getCompilationUnits().stream().filter(cUnit -> cUnit.name.equals(currentCUnitName)).findAny();
        CursorSymbolFindingVisitor refVisitor = new CursorSymbolFindingVisitor(context, currentPkgName, true);
        refVisitor.visit(currentCUnit.get());
        SymbolReferencesModel symbolReferencesModel = (SymbolReferencesModel)context.get(ReferencesKeys.REFERENCES_KEY);
        if (!symbolReferencesModel.getReferenceAtCursor().isPresent()) {
            String nodeName = (String)context.get(NodeContextKeys.NODE_NAME_KEY);
            throw new IllegalStateException("Symbol at cursor '" + nodeName + "' not supported or could not find!");
        }
        return symbolReferencesModel.getReferenceAtCursor();
    }
}

