/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.constants.NodeContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.SymbolReferenceFindingVisitor;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CursorSymbolFindingVisitor
extends SymbolReferenceFindingVisitor {
    private Predicate<DiagnosticPos> isWithinNode;

    public CursorSymbolFindingVisitor(LSContext lsContext, String pkgName, boolean currentCUnitMode) {
        super(lsContext, pkgName, currentCUnitMode);
        this.lsContext = lsContext;
        Boolean bDoNotSkipNullSymbols = (Boolean)lsContext.get(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS);
        this.doNotSkipNullSymbols = bDoNotSkipNullSymbols == null ? false : bDoNotSkipNullSymbols;
        this.symbolReferences = (SymbolReferencesModel)lsContext.get(ReferencesKeys.REFERENCES_KEY);
        this.tokenName = (String)lsContext.get(NodeContextKeys.NODE_NAME_KEY);
        TextDocumentPositionParams position = (TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY);
        if (position == null) {
            throw new IllegalStateException("Position information not available in the Operation Context");
        }
        this.cursorLine = position.getPosition().getLine();
        this.cursorCol = position.getPosition().getCharacter();
        this.currentCUnitMode = currentCUnitMode;
        this.pkgName = pkgName;
        this.isWithinNode = zeroBasedPos -> this.cursorLine == zeroBasedPos.sLine && this.cursorCol >= zeroBasedPos.sCol && this.cursorCol <= zeroBasedPos.eCol || zeroBasedPos.sLine == zeroBasedPos.eLine && this.cursorLine == zeroBasedPos.eLine && this.cursorCol <= zeroBasedPos.eCol || this.cursorLine > zeroBasedPos.sLine && this.cursorLine < zeroBasedPos.eLine;
    }

    @Override
    protected void addSymbol(BLangNode bLangNode, BSymbol bSymbol, boolean isDefinition, DiagnosticPos position) {
        Optional<SymbolReferencesModel.Reference> symbolAtCursor = this.symbolReferences.getReferenceAtCursor();
        if (bSymbol == null && !this.doNotSkipNullSymbols) {
            return;
        }
        if (symbolAtCursor.isPresent()) {
            return;
        }
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(position);
        bSymbol = bSymbol instanceof BVarSymbol && ((BVarSymbol)bSymbol).originalSymbol != null ? ((BVarSymbol)bSymbol).originalSymbol : bSymbol;
        SymbolReferencesModel.Reference ref = this.getSymbolReference(zeroBasedPos, bSymbol, bLangNode);
        if (this.cursorLine == zeroBasedPos.sLine && this.cursorCol >= zeroBasedPos.sCol && this.cursorCol <= zeroBasedPos.eCol) {
            this.symbolReferences.setReferenceAtCursor(ref);
        }
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
        String currentPkgName = (String)this.lsContext.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        String currentCUnitName = (String)this.lsContext.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        if (currentPkgName.equals(this.pkgName) && currentCUnitName.equals(compUnit.name) && !this.currentCUnitMode) {
            return;
        }
        this.topLevelNodes = compUnit.getTopLevelNodes();
        List<TopLevelNode> filteredNodes = this.topLevelNodes.stream().filter(topLevelNode -> {
            Diagnostic.DiagnosticPosition position = topLevelNode.getPosition();
            DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(new DiagnosticPos(null, position.getStartLine(), position.getEndLine(), position.getStartColumn(), position.getEndColumn()));
            boolean isLambda = false;
            if (topLevelNode instanceof BLangFunction) {
                BLangFunction func = (BLangFunction)topLevelNode;
                isLambda = func.flagSet.contains(Flag.LAMBDA);
            }
            return this.currentCUnitMode && !isLambda && this.isWithinNode.test(zeroBasedPos);
        }).collect(Collectors.toList());
        filteredNodes.forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode));
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(literalExpr.pos))) {
            this.addSymbol((BLangNode)literalExpr, (BSymbol)literalExpr.type.tsymbol, false, literalExpr.pos);
        }
        super.visit(literalExpr);
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(tableLiteral.pos))) {
            this.addSymbol((BLangNode)tableLiteral, (BSymbol)tableLiteral.type.tsymbol, false, tableLiteral.pos);
        }
        super.visit(tableLiteral);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(recordLiteral.pos))) {
            this.addSymbol((BLangNode)recordLiteral, (BSymbol)recordLiteral.type.tsymbol, false, recordLiteral.pos);
        }
        super.visit(recordLiteral);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(xmlElementLiteral.parent.pos))) {
            this.addSymbol((BLangNode)xmlElementLiteral, (BSymbol)xmlElementLiteral.type.tsymbol, false, xmlElementLiteral.parent.pos);
        }
        super.visit(xmlElementLiteral);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(stringTemplateLiteral.pos))) {
            this.addSymbol((BLangNode)stringTemplateLiteral, (BSymbol)stringTemplateLiteral.type.tsymbol, false, stringTemplateLiteral.pos);
        }
        super.visit(stringTemplateLiteral);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(listConstructorExpr.pos))) {
            this.addSymbol((BLangNode)listConstructorExpr, (BSymbol)listConstructorExpr.type.tsymbol, false, listConstructorExpr.pos);
        }
        super.visit(listConstructorExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(waitLiteral.pos))) {
            this.addSymbol((BLangNode)waitLiteral, (BSymbol)waitLiteral.type.tsymbol, false, waitLiteral.pos);
        }
        super.visit(waitLiteral);
    }

    @Override
    public void visit(BLangLambdaFunction lambdaFunction) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(lambdaFunction.pos))) {
            this.addSymbol((BLangNode)lambdaFunction, (BSymbol)lambdaFunction.type.tsymbol, false, lambdaFunction.pos);
        }
        super.visit(lambdaFunction);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(conversionExpr.pos))) {
            this.addSymbol((BLangNode)conversionExpr, (BSymbol)conversionExpr.type.tsymbol, false, conversionExpr.pos);
        }
        super.visit(conversionExpr);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(queryExpr.pos))) {
            this.addSymbol((BLangNode)queryExpr, (BSymbol)queryExpr.type.tsymbol, false, queryExpr.pos);
        }
        super.visit(queryExpr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.isWithinNode.test(CommonUtil.toZeroBasedPosition(binaryExpr.pos))) {
            this.addSymbol((BLangNode)binaryExpr, (BSymbol)binaryExpr.type.tsymbol, false, binaryExpr.pos);
        }
        super.visit(binaryExpr);
    }
}

