/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.PackageID;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;

public class CreateFunctionCodeAction
extends AbstractCodeActionProvider {
    private static final String UNDEFINED_FUNCTION = "undefined function";

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Optional<Path> filePath = CommonUtil.getPathFromURI((String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY));
        LSDocumentIdentifier document = null;
        try {
            document = documentManager.getLSDocument(filePath.get());
        }
        catch (WorkspaceDocumentException workspaceDocumentException) {
            // empty catch block
        }
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        if (document == null) {
            return actions;
        }
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            if (!diagnostic.getMessage().startsWith(UNDEFINED_FUNCTION) || (codeAction = CreateFunctionCodeAction.getFunctionCreateCommand(document, diagnostic, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getFunctionCreateCommand(LSDocumentIdentifier document, Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument lineArg = new CommandArgument("node.line", "" + line);
        CommandArgument colArg = new CommandArgument("node.column", "" + column);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        List<Object> args = Arrays.asList(lineArg, colArg, uriArg);
        Matcher matcher = CommandConstants.UNDEFINED_FUNCTION_PATTERN.matcher(diagnosticMessage);
        String functionName = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) + "(...)" : "";
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        String diagnosedContent = CreateFunctionCodeAction.getDiagnosedContent(diagnostic, context, document);
        try {
            LSDocumentIdentifier lsDocument = docManager.getLSDocument(CommonUtil.getPathFromURI(uri).get());
            context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
            context.put(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS, (Object)true);
            Position afterAliasPos = CreateFunctionCodeAction.offsetPositionToInvocation(diagnosedContent, position);
            SymbolReferencesModel.Reference refAtCursor = ReferencesUtil.getReferenceAtCursor(context, lsDocument, afterAliasPos);
            BLangNode bLangNode = refAtCursor.getbLangNode();
            BLangInvocation node = null;
            if (bLangNode instanceof BLangInvocation) {
                node = (BLangInvocation)bLangNode;
            }
            if (node != null && node.pkgAlias.value.isEmpty()) {
                boolean isWithinProject;
                boolean bl = isWithinProject = node.expr == null;
                if (node.expr != null) {
                    BLangPackage bLangPackage = (BLangPackage)context.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
                    List currentModules = document.getProjectModules();
                    PackageID nodePkgId = node.expr.type.tsymbol.pkgID;
                    boolean bl2 = isWithinProject = bLangPackage.packageID.orgName.equals((Object)nodePkgId.orgName) && currentModules.contains(nodePkgId.name.value);
                }
                if (isWithinProject) {
                    String commandTitle = "Create Function " + functionName;
                    CodeAction action = new CodeAction(commandTitle);
                    action.setKind("quickfix");
                    action.setCommand(new Command(commandTitle, "CREATE_FUNC", args));
                    action.setDiagnostics(diagnostics);
                    return action;
                }
            }
        }
        catch (WorkspaceDocumentException | CompilationFailedException throwable) {
            // empty catch block
        }
        return null;
    }
}

