/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.Flag;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class CreateTestCodeAction
extends AbstractCodeActionProvider {
    public CreateTestCodeAction() {
        super(Arrays.asList(CodeActionNodeType.FUNCTION, CodeActionNodeType.OBJECT));
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext context, List<Diagnostic> allDiagnostics) {
        try {
            String docUri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
            ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>();
            args.add(new CommandArgument("doc.uri", docUri));
            Position position = ((TextDocumentPositionParams)context.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
            args.add(new CommandArgument("node.line", "" + position.getLine()));
            args.add(new CommandArgument("node.column", "" + position.getCharacter()));
            boolean isService = "service".equals(nodeType.name());
            boolean isFunction = "function".equals(nodeType.name());
            WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            if ((isService || isFunction) && !CreateTestCodeAction.isTopLevelNode(docUri, documentManager, context, position)) {
                return actions;
            }
            if (isService) {
                CodeAction action = new CodeAction("Create Test For Service");
                action.setCommand(new Command("Create Test For Service", "CREATE_TEST", args));
                actions.add(action);
            } else if (isFunction) {
                CodeAction action = new CodeAction("Create Test For Function");
                action.setCommand(new Command("Create Test For Function", "CREATE_TEST", args));
                actions.add(action);
            }
            return actions;
        }
        catch (WorkspaceDocumentException | CompilationFailedException throwable) {
            return null;
        }
    }

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext context, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static boolean isTopLevelNode(String uri, WorkspaceDocumentManager docManager, LSContext context, Position pos) throws CompilationFailedException, WorkspaceDocumentException {
        LSDocumentIdentifier lsDocument = docManager.getLSDocument(CommonUtil.getPathFromURI(uri).get());
        context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
        SymbolReferencesModel.Reference refAtCursor = ReferencesUtil.getReferenceAtCursor(context, lsDocument, pos);
        BLangNode bLangNode = refAtCursor.getbLangNode();
        if (bLangNode instanceof BLangFunction && !((BLangFunction)bLangNode).getFlags().contains(Flag.PUBLIC)) {
            return false;
        }
        return bLangNode != null && bLangNode.parent instanceof BLangPackage;
    }
}

