/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.IndexBasedAccessNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CreateVariableCodeAction
extends AbstractCodeActionProvider {
    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Optional<Path> filePath = CommonUtil.getPathFromURI((String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY));
        LSDocumentIdentifier document = null;
        try {
            document = documentManager.getLSDocument(filePath.get());
        }
        catch (WorkspaceDocumentException workspaceDocumentException) {
            // empty catch block
        }
        if (document != null) {
            for (Diagnostic diagnostic : diagnosticsOfRange) {
                String diagnosticMsg = diagnostic.getMessage().toLowerCase(Locale.ROOT);
                if (!diagnosticMsg.contains("variable assignment is required")) continue;
                actions.addAll(CreateVariableCodeAction.getVariableAssignmentCommand(document, diagnostic, lsContext));
            }
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static List<CodeAction> getVariableAssignmentCommand(LSDocumentIdentifier document, Diagnostic diagnostic, LSContext context) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        String diagnosedContent = CreateVariableCodeAction.getDiagnosedContent(diagnostic, context, document);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Position position = diagnostic.getRange().getStart();
        try {
            context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
            context.put(ReferencesKeys.ENABLE_FIND_LITERALS, (Object)true);
            context.put(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS, (Object)true);
            Position afterAliasPos = CreateVariableCodeAction.offsetPositionToInvocation(diagnosedContent, position);
            SymbolReferencesModel.Reference refAtCursor = CodeActionUtil.getSymbolAtCursor(context, document, afterAliasPos);
            BSymbol symbolAtCursor = refAtCursor.getSymbol();
            boolean isInvocation = symbolAtCursor instanceof BInvokableSymbol;
            boolean isRemoteInvocation = symbolAtCursor != null && (symbolAtCursor.flags & 0x10000) == 65536;
            boolean hasDefaultInitFunction = false;
            boolean hasCustomInitFunction = false;
            if (refAtCursor.getbLangNode() instanceof BLangInvocation) {
                hasDefaultInitFunction = symbolAtCursor instanceof BObjectTypeSymbol;
                hasCustomInitFunction = symbolAtCursor instanceof BInvokableSymbol && symbolAtCursor.name.value.endsWith("__init");
            }
            boolean isInitInvocation = hasDefaultInitFunction || hasCustomInitFunction;
            actions.addAll(CreateVariableCodeAction.getCreateVariableCodeActions(context, uri, diagnostics, position, refAtCursor, hasDefaultInitFunction, hasCustomInitFunction));
            if (isInvocation || isInitInvocation) {
                String commandTitle;
                BType returnType = hasDefaultInitFunction ? symbolAtCursor.type : (hasCustomInitFunction ? symbolAtCursor.owner.type : ((BInvokableSymbol)symbolAtCursor).retType);
                boolean hasError = false;
                if (returnType instanceof BErrorType) {
                    hasError = true;
                } else if (returnType instanceof BUnionType) {
                    BUnionType unionType = (BUnionType)returnType;
                    hasError = unionType.getMemberTypes().stream().anyMatch(s -> s instanceof BErrorType);
                    if (!isRemoteInvocation) {
                        commandTitle = String.format("Type Guard '%s'", symbolAtCursor.name);
                        List<TextEdit> tEdits = CreateVariableCodeAction.getTypeGuardCodeActionEdits(context, uri, refAtCursor, unionType);
                        CodeAction action = new CodeAction(commandTitle);
                        action.setKind("quickfix");
                        action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), tEdits)))));
                        action.setDiagnostics(diagnostics);
                        actions.add(action);
                    }
                }
                if (!hasError) {
                    List<TextEdit> iEdits = CreateVariableCodeAction.getIgnoreCodeActionEdits(position);
                    commandTitle = "Ignore Return Value";
                    CodeAction action = new CodeAction(commandTitle);
                    action.setKind("quickfix");
                    action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), iEdits)))));
                    action.setDiagnostics(diagnostics);
                    actions.add(action);
                }
            }
        }
        catch (IOException | WorkspaceDocumentException | CompilationFailedException throwable) {
            // empty catch block
        }
        return actions;
    }

    private static List<CodeAction> getCreateVariableCodeActions(LSContext context, String uri, List<Diagnostic> diagnostics, Position position, SymbolReferencesModel.Reference referenceAtCursor, boolean hasDefaultInitFunction, boolean hasCustomInitFunction) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        BLangNode bLangNode = referenceAtCursor.getbLangNode();
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        List<TextEdit> edits = new ArrayList<TextEdit>();
        Pair<List<String>, List<String>> typesAndNames = CreateVariableCodeAction.getPossibleTypesAndNames(context, referenceAtCursor, hasDefaultInitFunction, hasCustomInitFunction, bLangNode, edits, compilerContext);
        List types = (List)typesAndNames.getLeft();
        List names = (List)typesAndNames.getRight();
        for (int i = 0; i < types.size(); ++i) {
            String type = (String)types.get(i);
            String name = (String)names.get(i);
            String title = "Create Local Variable";
            if (types.size() > 1) {
                String typeLabel = type.startsWith("[") && type.endsWith("]") && !type.endsWith("[]") && type.length() > 10 ? "Tuple" : type;
                title = String.format("Create Local Variable with '%s'", typeLabel);
            }
            CodeAction action = new CodeAction(title);
            Position insertPos = new Position(position.getLine(), position.getCharacter());
            edits = Collections.singletonList(new TextEdit(new Range(insertPos, insertPos), type + " " + name + " = "));
            action.setKind("quickfix");
            action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
            action.setDiagnostics(diagnostics);
            actions.add(action);
        }
        return actions;
    }

    private static Pair<List<String>, List<String>> getPossibleTypesAndNames(LSContext context, SymbolReferencesModel.Reference referenceAtCursor, boolean hasDefaultInitFunction, boolean hasCustomInitFunction, BLangNode bLangNode, List<TextEdit> edits, CompilerContext compilerContext) {
        Set<String> nameEntries = CommonUtil.getAllNameEntries(compilerContext);
        PackageID currentPkgId = bLangNode.pos.src.pkgID;
        BiConsumer<String, String> importsAcceptor = (orgName, alias) -> {
            boolean notFound = CommonUtil.getCurrentModuleImports(context).stream().noneMatch(pkg -> pkg.orgName.value.equals(orgName) && pkg.alias.value.equals(alias));
            if (notFound) {
                String pkgName = orgName + "/" + alias;
                edits.add(CreateVariableCodeAction.createImportTextEdit(pkgName, context));
            }
        };
        List<Object> types = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (hasDefaultInitFunction) {
            BType bType = referenceAtCursor.getSymbol().type;
            String variableType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, bType);
            String variableName = CommonUtil.generateVariableName(bType, nameEntries);
            types.add(variableType);
            names.add(variableName);
        } else if (hasCustomInitFunction) {
            BType bType = referenceAtCursor.getSymbol().owner.type;
            String variableType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, bType);
            String variableName = CommonUtil.generateVariableName(bType, nameEntries);
            types.add(variableType);
            names.add(variableName);
        } else {
            while (bLangNode.parent instanceof IndexBasedAccessNode) {
                bLangNode = bLangNode.parent;
            }
            String variableType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, bLangNode);
            if (bLangNode instanceof BLangInvocation) {
                BSymbol symbol = ((BLangInvocation)bLangNode).symbol;
                if (symbol instanceof BInvokableSymbol) {
                    variableType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, ((BInvokableSymbol)symbol).retType);
                }
                String variableName = CommonUtil.generateVariableName(bLangNode, nameEntries);
                types.add(variableType);
                names.add(variableName);
            } else if (bLangNode instanceof BLangFieldBasedAccess) {
                String variableName = CommonUtil.generateVariableName(((BLangFieldBasedAccess)bLangNode).expr.type, nameEntries);
                types.add(variableType);
                names.add(variableName);
            } else if (bLangNode instanceof BLangRecordLiteral) {
                Object type;
                String variableName = CommonUtil.generateName(1, nameEntries);
                List bLangPackages = (List)context.get(DocumentServiceKeys.BLANG_PACKAGES_CONTEXT_KEY);
                Object matchingRecordType = null;
                Types typesChk = Types.getInstance((CompilerContext)compilerContext);
                for (BLangPackage pkg : bLangPackages) {
                    for (TopLevelNode topLevelNode : pkg.topLevelNodes) {
                        if (!(topLevelNode instanceof BLangTypeDefinition) || !(((BLangTypeDefinition)topLevelNode).typeNode instanceof BLangRecordTypeNode) || !(((BLangTypeDefinition)topLevelNode).typeNode.type instanceof BRecordType) || !typesChk.checkStructEquivalency(bLangNode.type, (BType)(type = (BRecordType)((BLangTypeDefinition)topLevelNode).typeNode.type)) || ((BRecordType)type).tsymbol.name.value.startsWith("$")) continue;
                        matchingRecordType = type;
                    }
                }
                if (matchingRecordType != null) {
                    String recType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, matchingRecordType);
                    types.add(recType);
                    names.add(variableName);
                }
                String rType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, bLangNode.type);
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)bLangNode;
                types.add(recordLiteral.fields.size() > 0 ? rType : "record {}");
                names.add(variableName);
                types.add("json");
                names.add(variableName);
                BType prevType = null;
                boolean isConstrainedMap = true;
                for (RecordLiteralNode.RecordField recordField : recordLiteral.fields) {
                    if (!(recordField instanceof BLangRecordLiteral.BLangRecordKeyValueField)) continue;
                    BLangRecordLiteral.BLangRecordKeyValueField kvField = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
                    BType type2 = kvField.valueExpr.type;
                    if (prevType != null && !prevType.tsymbol.name.getValue().equals(type2.tsymbol.name.getValue())) {
                        isConstrainedMap = false;
                    }
                    prevType = type2;
                }
                if (isConstrainedMap && prevType != null) {
                    type = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, prevType);
                    types.add("map<" + (String)type + ">");
                    names.add(variableName);
                } else {
                    types.add("map<any>");
                    names.add(variableName);
                }
            } else if (bLangNode instanceof BLangListConstructorExpr) {
                String variableName = CommonUtil.generateName(1, nameEntries);
                BLangListConstructorExpr listExpr = (BLangListConstructorExpr)bLangNode;
                if (listExpr.expectedType instanceof BTupleType) {
                    BTupleType tupleType = (BTupleType)listExpr.expectedType;
                    String arrayType = null;
                    String prevType = null;
                    String prevInnerType = null;
                    boolean isArrayCandidate = !tupleType.tupleTypes.isEmpty();
                    StringJoiner tupleJoiner = new StringJoiner(", ");
                    for (BType type : tupleType.tupleTypes) {
                        String newType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, type);
                        if (prevType != null && !prevType.equals(newType)) {
                            isArrayCandidate = false;
                        }
                        if (type instanceof BTupleType && prevInnerType == null) {
                            BTupleType nType = (BTupleType)type;
                            boolean isSameInnerType = true;
                            for (BType innerType : nType.tupleTypes) {
                                String newInnerType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, innerType);
                                if (prevInnerType != null && !prevInnerType.equals(newInnerType)) {
                                    isSameInnerType = false;
                                }
                                prevInnerType = newInnerType;
                            }
                            if (isSameInnerType) {
                                arrayType = prevInnerType + "[]";
                            }
                        }
                        tupleJoiner.add(newType);
                        prevType = newType;
                        if (arrayType != null) continue;
                        arrayType = newType;
                    }
                    if (isArrayCandidate) {
                        types.add(arrayType + "[]");
                        names.add(variableName);
                    }
                    types.add("[" + tupleJoiner.toString() + "]");
                    names.add(variableName);
                }
            } else if (bLangNode instanceof BLangQueryExpr) {
                BLangQueryExpr queryExpr = (BLangQueryExpr)bLangNode;
                ExpressionNode expression = queryExpr.selectClause.getExpression();
                if (expression instanceof BLangRecordLiteral) {
                    BLangRecordLiteral recordLiteral = (BLangRecordLiteral)expression;
                    return CreateVariableCodeAction.getPossibleTypesAndNames(context, referenceAtCursor, hasDefaultInitFunction, hasCustomInitFunction, (BLangNode)recordLiteral, edits, compilerContext);
                }
                String variableName = CommonUtil.generateName(1, nameEntries);
                types.add("var");
                names.add(variableName);
            } else if (bLangNode instanceof BLangBinaryExpr) {
                BLangBinaryExpr binaryExpr = (BLangBinaryExpr)bLangNode;
                variableType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, binaryExpr.type);
                String variableName = CommonUtil.generateName(1, nameEntries);
                types.add(variableType);
                names.add(variableName);
            } else {
                String variableName = CommonUtil.generateVariableName(bLangNode.type, nameEntries);
                types.add(variableType);
                names.add(variableName);
            }
        }
        types = types.stream().map(v -> v.replaceAll("^\\((.*)\\)$", "$1")).collect(Collectors.toList());
        return new ImmutablePair(types, names);
    }

    private static List<TextEdit> getTypeGuardCodeActionEdits(LSContext context, String uri, SymbolReferencesModel.Reference referenceAtCursor, BUnionType unionType) throws WorkspaceDocumentException, IOException {
        boolean transitiveBinaryUnion;
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        BLangNode bLangNode = referenceAtCursor.getbLangNode();
        Position startPos = new Position(bLangNode.pos.sLine - 1, bLangNode.pos.sCol - 1);
        Position endPosWithSemiColon = new Position(bLangNode.pos.eLine - 1, bLangNode.pos.eCol);
        Position endPos = new Position(bLangNode.pos.eLine - 1, bLangNode.pos.eCol - 1);
        Range newTextRange = new Range(startPos, endPosWithSemiColon);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        String spaces = StringUtils.repeat((char)' ', (int)(bLangNode.pos.sCol - 1));
        String padding = CommonUtil.LINE_SEPARATOR + CommonUtil.LINE_SEPARATOR + spaces;
        String content = CommandUtil.getContentOfRange(docManager, uri, new Range(startPos, endPos));
        boolean hasError = unionType.getMemberTypes().stream().anyMatch(s -> s instanceof BErrorType);
        ArrayList<BType> members = new ArrayList<BType>(unionType.getMemberTypes());
        long errorTypesCount = unionType.getMemberTypes().stream().filter(t -> t instanceof BErrorType).count();
        boolean bl = transitiveBinaryUnion = (long)unionType.getMemberTypes().size() - errorTypesCount == 1L;
        if (transitiveBinaryUnion) {
            members.removeIf(s -> s instanceof BErrorType);
        }
        if ((unionType.getMemberTypes().size() == 2 || transitiveBinaryUnion) && hasError) {
            members.forEach(bType -> {
                if (bType instanceof BNilType) {
                    String newText = String.format("if (%s is error) {%s}", content, padding);
                    edits.add(new TextEdit(newTextRange, newText));
                } else {
                    String type = CommonUtil.getBTypeName(bType, context, true);
                    String newText = String.format("if (%s is %s) {%s} else {%s}", content, type, padding, padding);
                    edits.add(new TextEdit(newTextRange, newText));
                }
            });
        } else {
            boolean addErrorTypeAtEnd;
            CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
            Set<String> nameEntries = CommonUtil.getAllNameEntries(compilerContext);
            String varName = CommonUtil.generateVariableName(bLangNode, nameEntries);
            String typeDef = CommonUtil.getBTypeName((BType)unionType, context, true);
            ArrayList<BType> tMembers = new ArrayList<BType>(unionType.getMemberTypes());
            if (errorTypesCount > 1L) {
                tMembers.removeIf(s -> s instanceof BErrorType);
                addErrorTypeAtEnd = true;
            } else {
                addErrorTypeAtEnd = false;
            }
            ArrayList<String> memberTypes = new ArrayList<String>();
            IntStream.range(0, tMembers.size()).forEachOrdered(value -> {
                BType bType = (BType)tMembers.get(value);
                String bTypeName = CommonUtil.getBTypeName(bType, context, true);
                boolean isErrorType = bType instanceof BErrorType;
                if (isErrorType && !addErrorTypeAtEnd) {
                    memberTypes.add(bTypeName);
                } else if (!isErrorType) {
                    memberTypes.add(bTypeName);
                }
            });
            if (addErrorTypeAtEnd) {
                memberTypes.add("error");
            }
            String newText = String.format("%s %s = %s;%s", typeDef, varName, content, CommonUtil.LINE_SEPARATOR);
            newText = newText + spaces + IntStream.range(0, memberTypes.size() - 1).mapToObj(value -> String.format("if (%s is %s) {%s}", varName, memberTypes.get(value), padding)).collect(Collectors.joining(" else "));
            newText = newText + String.format(" else {%s}", padding);
            edits.add(new TextEdit(newTextRange, newText));
        }
        return edits;
    }

    private static List<TextEdit> getIgnoreCodeActionEdits(Position position) {
        String editText = "_ = ";
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(new TextEdit(new Range(position, position), editText));
        return edits;
    }

    private static TextEdit createImportTextEdit(String pkgName, LSContext context) {
        DiagnosticPos pos = null;
        List<BLangImportPackage> imports = CommonUtil.getCurrentModuleImports(context);
        if (!imports.isEmpty()) {
            BLangImportPackage lastImport = CommonUtil.getLastItem(imports);
            pos = lastImport.getPosition();
        }
        int endCol = 0;
        int endLine = pos == null ? 0 : pos.getEndLine();
        String editText = "import " + pkgName + ";\n";
        Range range = new Range(new Position(endLine, endCol), new Position(endLine, endCol));
        return new TextEdit(range, editText);
    }
}

