/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;

public class IncompatibleTypesCodeAction
extends AbstractCodeActionProvider {
    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Optional<Path> filePath = CommonUtil.getPathFromURI((String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY));
        LSDocumentIdentifier document = null;
        try {
            document = documentManager.getLSDocument(filePath.get());
        }
        catch (WorkspaceDocumentException workspaceDocumentException) {
            // empty catch block
        }
        if (document == null) {
            return actions;
        }
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            if (!diagnostic.getMessage().toLowerCase(Locale.ROOT).contains("incompatible types") || (codeAction = IncompatibleTypesCodeAction.getIncompatibleTypesCommand(document, diagnostic, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getIncompatibleTypesCommand(LSDocumentIdentifier document, Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.INCOMPATIBLE_TYPE_PATTERN.matcher(diagnosticMessage);
        if (matcher.find() && matcher.groupCount() > 1) {
            String foundType = matcher.group(2);
            WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            try {
                BLangStatement statement;
                BLangFunction func = IncompatibleTypesCodeAction.getFunctionNode(line, column, document, documentManager, context);
                if (func != null && !"main".equals(func.name.value) && (statement = IncompatibleTypesCodeAction.getStatementByLocation(((BLangBlockFunctionBody)func.body).stmts, line + 1, column + 1)) instanceof BLangReturn) {
                    Position end;
                    Position start;
                    matcher = CommandConstants.FQ_TYPE_PATTERN.matcher(foundType);
                    ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                    String editText = IncompatibleTypesCodeAction.extractTypeName(context, matcher, foundType, edits);
                    if (func.returnTypeNode instanceof BLangValueType && TypeKind.NIL.equals((Object)((BLangValueType)func.returnTypeNode).getTypeKind()) && func.returnTypeNode.getWS() == null) {
                        start = new Position(func.returnTypeNode.pos.sLine - 1, func.returnTypeNode.pos.eCol - 1);
                        end = new Position(func.returnTypeNode.pos.eLine - 1, func.returnTypeNode.pos.eCol - 1);
                        editText = " returns (" + editText + ")";
                    } else {
                        start = new Position(func.returnTypeNode.pos.sLine - 1, func.returnTypeNode.pos.sCol - 1);
                        end = new Position(func.returnTypeNode.pos.eLine - 1, func.returnTypeNode.pos.eCol - 1);
                    }
                    edits.add(new TextEdit(new Range(start, end), editText));
                    String commandTitle = "Change Return Type to '" + foundType + "'";
                    CodeAction action = new CodeAction(commandTitle);
                    action.setKind("quickfix");
                    action.setDiagnostics(diagnostics);
                    action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
                    return action;
                }
            }
            catch (CompilationFailedException compilationFailedException) {
                // empty catch block
            }
        }
        return null;
    }

    private static BLangFunction getFunctionNode(int line, int column, LSDocumentIdentifier document, WorkspaceDocumentManager docManager, LSContext context) throws CompilationFailedException {
        String uri = document.getURIString();
        Position position = new Position();
        position.setLine(line);
        position.setCharacter(column + 1);
        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)uri);
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        context.put(DocumentServiceKeys.POSITION_KEY, (Object)new TextDocumentPositionParams(identifier, position));
        BLangPackage currentPackage = (BLangPackage)context.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        String relativeFilePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangCompilationUnit compilationUnit = relativeFilePath.startsWith("tests" + File.separator) ? (BLangCompilationUnit)currentPackage.getTestablePkg().getCompilationUnits().stream().filter(compUnit -> relativeFilePath.equals(compUnit.getName())).findFirst().orElse(null) : (BLangCompilationUnit)currentPackage.getCompilationUnits().stream().filter(compUnit -> relativeFilePath.equals(compUnit.getName())).findFirst().orElse(null);
        if (compilationUnit == null) {
            return null;
        }
        Iterator nodeIterator = compilationUnit.getTopLevelNodes().iterator();
        BLangFunction result = null;
        TopLevelNode next = nodeIterator.hasNext() ? (TopLevelNode)nodeIterator.next() : null;
        Function<Diagnostic.DiagnosticPosition, Boolean> isWithinPosition = diagnosticPosition -> {
            int sLine = diagnosticPosition.getStartLine();
            int eLine = diagnosticPosition.getEndLine();
            int sCol = diagnosticPosition.getStartColumn();
            int eCol = diagnosticPosition.getEndColumn();
            return (line > sLine || line == sLine && column >= sCol) && (line < eLine || line == eLine && column <= eCol);
        };
        block0: while (next != null) {
            if (isWithinPosition.apply(next.getPosition()).booleanValue()) {
                if (next instanceof BLangFunction) {
                    result = (BLangFunction)next;
                    break;
                }
                if (next instanceof BLangTypeDefinition) {
                    BLangTypeDefinition typeDefinition = (BLangTypeDefinition)next;
                    if (!(typeDefinition.typeNode instanceof BLangObjectTypeNode)) break;
                    BLangObjectTypeNode typeNode = (BLangObjectTypeNode)typeDefinition.typeNode;
                    for (BLangFunction function : typeNode.functions) {
                        if (!isWithinPosition.apply((Diagnostic.DiagnosticPosition)function.getPosition()).booleanValue()) continue;
                        result = function;
                        break block0;
                    }
                } else {
                    if (!(next instanceof BLangService)) break;
                    BLangService bLangService = (BLangService)next;
                    for (BLangFunction function : bLangService.resourceFunctions) {
                        if (!isWithinPosition.apply((Diagnostic.DiagnosticPosition)function.getPosition()).booleanValue()) continue;
                        result = function;
                        break block0;
                    }
                }
                break;
            }
            next = nodeIterator.hasNext() ? (TopLevelNode)nodeIterator.next() : null;
        }
        return result;
    }

    private static BLangStatement getStatementByLocation(List<BLangStatement> statements, int line, int column) {
        BLangStatement node = null;
        for (BLangStatement statement : statements) {
            BLangStatement rv = IncompatibleTypesCodeAction.getStatementByLocation((BLangNode)statement, line, column);
            if (rv == null) continue;
            return rv;
        }
        return node;
    }

    private static BLangStatement getStatementByLocation(BLangNode node, int line, int column) {
        try {
            if (IncompatibleTypesCodeAction.checkNodeWithin(node, line, column) && node instanceof BLangStatement) {
                return (BLangStatement)node;
            }
            for (Field field : node.getClass().getDeclaredFields()) {
                BLangStatement rv;
                Object obj = field.get(node);
                if (obj instanceof BLangBlockStmt) {
                    rv = IncompatibleTypesCodeAction.getStatementByLocation(((BLangBlockStmt)obj).getStatements(), line, column);
                    if (rv == null) continue;
                    return rv;
                }
                if (!(obj instanceof BLangStatement)) continue;
                if (IncompatibleTypesCodeAction.checkNodeWithin((BLangNode)((BLangStatement)obj), line, column)) {
                    return (BLangStatement)obj;
                }
                rv = IncompatibleTypesCodeAction.getStatementByLocation((BLangNode)((BLangStatement)obj), line, column);
                if (rv == null) continue;
                return rv;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
        return null;
    }

    private static boolean checkNodeWithin(BLangNode node, int line, int column) {
        int sLine = node.getPosition().getStartLine();
        int eLine = node.getPosition().getEndLine();
        int sCol = node.getPosition().getStartColumn();
        int eCol = node.getPosition().getEndColumn();
        return (line > sLine || line == sLine && column >= sCol) && (line < eLine || line == eLine && column <= eCol);
    }

    private static String extractTypeName(LSContext context, Matcher matcher, String foundType, List<TextEdit> edits) {
        if (matcher.find() && matcher.groupCount() > 2) {
            PackageID currentPkgId;
            String orgName = matcher.group(1);
            String alias = matcher.group(2);
            String typeName = matcher.group(3);
            String pkgId = orgName + "/" + alias;
            if (pkgId.equals((currentPkgId = ((BLangPackage)context.get((LSContext.Key)DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY)).packageID).toString())) {
                foundType = typeName;
            } else {
                List<BLangImportPackage> currentDocImports = CommonUtil.getCurrentFileImports(context);
                boolean pkgAlreadyImported = currentDocImports.stream().anyMatch(importPkg -> importPkg.orgName.value.equals(orgName) && importPkg.alias.value.equals(alias));
                if (!pkgAlreadyImported) {
                    edits.addAll(CommonUtil.getAutoImportTextEdits(orgName, alias, context));
                }
                foundType = alias + ":" + typeName;
            }
        }
        return foundType;
    }
}

