/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class PullModuleCodeAction
extends AbstractCodeActionProvider {
    private static final String UNRESOLVED_MODULE = "cannot resolve module";

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            if (!diagnostic.getMessage().startsWith(UNRESOLVED_MODULE)) continue;
            actions.add(PullModuleCodeAction.getUnresolvedPackageCommand(diagnostic, lsContext));
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getUnresolvedPackageCommand(Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.UNRESOLVED_MODULE_PATTERN.matcher(diagnosticMessage.toLowerCase(Locale.ROOT));
        if (matcher.find() && matcher.groupCount() > 0) {
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>();
            String pkgName = matcher.group(1).trim();
            String version = PullModuleCodeAction.getVersion(context, pkgName, matcher);
            args.add(new CommandArgument("module", pkgName + version));
            args.add(uriArg);
            String commandTitle = "Pull from Ballerina Central";
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command(commandTitle, "PULL_MODULE", args));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }

    private static String getVersion(LSContext context, String pkgName, Matcher matcher) {
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        String version = matcher.groupCount() > 1 && matcher.group(2) != null ? ":" + matcher.group(2) : "";
        int aliasIndex = version.indexOf(" as ");
        if (aliasIndex > 0) {
            version = version.substring(0, aliasIndex);
        }
        if (compilerContext != null && version.isEmpty()) {
            ManifestProcessor manifestProcessor = ManifestProcessor.getInstance((CompilerContext)compilerContext);
            Manifest manifest = manifestProcessor.getManifest();
            List dependencies = manifest.getDependencies();
            version = dependencies.stream().filter(d -> d.getModuleID().equals(pkgName)).findAny().map(d -> ":" + d.getMetadata().getVersion()).orElse(version);
        }
        return version;
    }
}

