/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.openapi.ballerinatoopenapi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class CreateBallerinaServiceResourceMethodCodeAction
extends AbstractCodeActionProvider {
    private static final String CONTAINS_RESOURCE_NOT_DOCUMENTED = "Ballerina service contains a Resource that is not documented in the OpenAPI contract.";

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        return null;
    }

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        Optional<Path> filePath = CommonUtil.getPathFromURI((String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY));
        LSDocumentIdentifier document = null;
        try {
            document = documentManager.getLSDocument(filePath.get());
        }
        catch (WorkspaceDocumentException workspaceDocumentException) {
            // empty catch block
        }
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        if (document == null) {
            return actions;
        }
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            Matcher matcher = CommandConstants.METHOD_FOR_THE_PATH_NOT_FOUND_IN_OPENAPI.matcher(diagnostic.getMessage());
            if (!matcher.find() || (codeAction = CreateBallerinaServiceResourceMethodCodeAction.getCommand(diagnostic, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    private static CodeAction getCommand(Diagnostic diagnostic, LSContext lsContext) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument lineArg = new CommandArgument("node.line", "" + line);
        CommandArgument colArg = new CommandArgument("node.column", "" + column);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.METHOD_FOR_THE_PATH_NOT_FOUND_IN_OPENAPI.matcher(diagnosticMessage);
        if (matcher.find() && matcher.groupCount() > 0) {
            String method = matcher.group(1);
            String path = matcher.group(2);
            CommandArgument methodArg = new CommandArgument("method", method);
            CommandArgument pathArg = new CommandArgument("path", path);
            List<Object> args = Arrays.asList(lineArg, colArg, uriArg, methodArg, pathArg);
            String commandTitle = String.format("Create missing http method '%s' for the path '%s'", method, path);
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command("Create missing http method '%s' for the path '%s'", "CREATE_HTTP_METHOD_FOR_THE_PATH_IN_OPENAPI", args));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }
}

