/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.openapi.openapitoballerina;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class AddMissingParameterCodeAction
extends AbstractCodeActionProvider {
    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        return null;
    }

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            Matcher matcher = CommandConstants.PARAMETER_FOR_THE_METHOD_NOT_FOUND_IN_BALLERINA.matcher(diagnostic.getMessage());
            if (!matcher.find() || (codeAction = AddMissingParameterCodeAction.getCommand(diagnostic, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    private static CodeAction getCommand(Diagnostic diagnostic, LSContext lsContext) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument lineArg = new CommandArgument("node.line", "" + line);
        CommandArgument colArg = new CommandArgument("node.column", "" + column);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.PARAMETER_FOR_THE_METHOD_NOT_FOUND_IN_BALLERINA.matcher(diagnosticMessage);
        if (matcher.find() && matcher.groupCount() > 1) {
            String parameter = matcher.group(1);
            String method = matcher.group(2);
            String path = matcher.group(3);
            String commandTitle = String.format("Add missing parameter '%s' for the method '%s' for the path '%s'", parameter, method, path);
            CommandArgument parameterArg = new CommandArgument("parameter", parameter);
            CommandArgument methodArg = new CommandArgument("method", method);
            CommandArgument pathArg = new CommandArgument("path", path);
            List<Object> args = Arrays.asList(lineArg, colArg, uriArg, parameterArg, methodArg, pathArg);
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command("Add missing parameter '%s' for the method '%s' for the path '%s'", "ADD_MISSING_PARAMETER", args));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }
}

