/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.DocumentServiceOperationContext;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codelenses.LSCodeLensesProviderHolder;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codelenses.CodeLensesProviderKeys;
import org.ballerinalang.langserver.commons.codelenses.LSCodeLensesProviderException;
import org.ballerinalang.langserver.commons.codelenses.spi.LSCodeLensesProvider;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.eclipse.lsp4j.CodeLens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CodeLensUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeLensUtil.class);

    public static List<CodeLens> compileAndGetCodeLenses(String fileUri, WorkspaceDocumentManager documentManager) throws CompilationFailedException {
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        LSContext codeLensContext = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_CODE_LENS).withCommonParams(null, fileUri, documentManager)).build();
        BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)codeLensContext, (WorkspaceDocumentManager)documentManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
        Optional<BLangCompilationUnit> documentCUnit = bLangPackage.getCompilationUnits().stream().filter(cUnit -> fileUri.endsWith(cUnit.getName())).findFirst();
        CompilerContext compilerContext = (CompilerContext)codeLensContext.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        ArrayList diagnostics = new ArrayList();
        if (compilerContext.get(DiagnosticListener.class) instanceof CollectDiagnosticListener) {
            CollectDiagnosticListener listener = (CollectDiagnosticListener)compilerContext.get(DiagnosticListener.class);
            diagnostics.addAll(listener.getDiagnostics());
            listener.clearAll();
        }
        codeLensContext.put(CodeLensesProviderKeys.BLANG_PACKAGE_KEY, (Object)bLangPackage);
        codeLensContext.put(CodeLensesProviderKeys.FILE_URI_KEY, (Object)fileUri);
        codeLensContext.put(CodeLensesProviderKeys.DIAGNOSTIC_KEY, diagnostics);
        documentCUnit.ifPresent(cUnit -> {
            codeLensContext.put(CodeLensesProviderKeys.COMPILATION_UNIT_KEY, cUnit);
            List<LSCodeLensesProvider> providers = LSCodeLensesProviderHolder.getInstance().getProviders();
            for (LSCodeLensesProvider provider : providers) {
                try {
                    lenses.addAll(provider.getLenses(codeLensContext));
                }
                catch (LSCodeLensesProviderException e) {
                    LOGGER.error("Error while retrieving lenses from: " + provider.getName());
                }
            }
        });
        return lenses;
    }

    public static int getTopMostLocOfAnnotations(List<BLangAnnotationAttachment> annotationAttachments, int initialValue) {
        int topMost = initialValue;
        if (annotationAttachments != null) {
            for (BLangAnnotationAttachment attachment : annotationAttachments) {
                topMost = Math.min(attachment.pos.sLine - 1, topMost);
            }
        }
        return topMost;
    }

    public static int getTopMostLocOfDocs(BLangMarkdownDocumentation docs, int initialValue) {
        int topMost = initialValue;
        if (docs != null) {
            for (BLangMarkdownDocumentationLine line : docs.documentationLines) {
                topMost = Math.min(line.pos.sLine - 1, topMost);
            }
        }
        return topMost;
    }
}

