/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.codelenses.CodeLensUtil;
import org.ballerinalang.langserver.codelenses.providers.AbstractCodeLensesProvider;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codelenses.CodeLensesProviderKeys;
import org.ballerinalang.langserver.commons.codelenses.LSCodeLensesProviderException;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;

public class DocsCodeLensesProvider
extends AbstractCodeLensesProvider {
    public DocsCodeLensesProvider() {
        super("docs.CodeLenses");
        LSClientConfigHolder.getInstance().register((oldConfig, newConfig) -> {
            this.isEnabled = newConfig.getCodeLens().getDocs().isEnabled();
        });
    }

    public List<CodeLens> getLenses(LSContext context) throws LSCodeLensesProviderException {
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        BLangCompilationUnit cUnit = (BLangCompilationUnit)context.get(CodeLensesProviderKeys.COMPILATION_UNIT_KEY);
        String fileUri = (String)context.get(CodeLensesProviderKeys.FILE_URI_KEY);
        BLangPackage bLangPackage = (BLangPackage)context.get(CodeLensesProviderKeys.BLANG_PACKAGE_KEY);
        for (TopLevelNode topLevelNode : cUnit.getTopLevelNodes()) {
            this.addDocLenses(lenses, fileUri, bLangPackage, topLevelNode, context);
        }
        return lenses;
    }

    private void addDocLenses(List<CodeLens> lenses, String fileUri, BLangPackage bLangPackage, TopLevelNode topLevelNode, LSContext context) {
        TopLevelNodeDetail nodeDetail = this.resolveTopLevelTypeDetails(topLevelNode);
        if (nodeDetail == null) {
            return;
        }
        String nodeType = nodeDetail.type;
        String nodeName = nodeDetail.name;
        Position nodePosition = nodeDetail.position;
        Position nodeTopMostPos = nodeDetail.topMostPosition;
        boolean hasDocumentation = nodeDetail.hasDocumentation;
        DocAttachmentInfo info = DocumentationGenerator.getDocumentationEditForNodeByPosition(nodeType, bLangPackage, topLevelNode.getPosition().getStartLine() - 1, context);
        if (info == null) {
            return;
        }
        if (topLevelNode instanceof AnnotatableNode && (((AnnotatableNode)topLevelNode).getFlags() == null || !((AnnotatableNode)topLevelNode).getFlags().contains(Flag.PUBLIC))) {
            return;
        }
        if (hasDocumentation) {
            CommandArgument nameArg = new CommandArgument("function.name", nodeName);
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Collections.singletonList(nameArg));
            Command command = new Command("Preview Docs", "ballerina.showDocs", args);
            lenses.add(new CodeLens(new Range(nodeTopMostPos, nodeTopMostPos), command, null));
        } else {
            CommandArgument nodeTypeArg = new CommandArgument("node.type", nodeType);
            CommandArgument docUriArg = new CommandArgument("doc.uri", fileUri);
            CommandArgument lineStart = new CommandArgument("node.line", String.valueOf(nodePosition.getLine()));
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Arrays.asList(nodeTypeArg, docUriArg, lineStart));
            Command command = new Command("Document This", "ADD_DOC", args);
            lenses.add(new CodeLens(new Range(nodeTopMostPos, nodeTopMostPos), command, null));
        }
    }

    private TopLevelNodeDetail resolveTopLevelTypeDetails(TopLevelNode topLevelNode) {
        if (topLevelNode.getWS() == null) {
            return null;
        }
        if (topLevelNode instanceof BLangTypeDefinition) {
            BLangTypeDefinition definition = (BLangTypeDefinition)topLevelNode;
            return TopLevelNodeDetail.fromTypeDefinition(definition);
        }
        if (topLevelNode instanceof BLangFunction) {
            BLangFunction func = (BLangFunction)topLevelNode;
            return TopLevelNodeDetail.fromFunction(func);
        }
        if (topLevelNode instanceof BLangService) {
            BLangService service = (BLangService)topLevelNode;
            return TopLevelNodeDetail.fromService(service);
        }
        return null;
    }

    private static class TopLevelNodeDetail {
        String type;
        String name;
        Position position;
        Position topMostPosition;
        boolean hasDocumentation;

        TopLevelNodeDetail(String type, String name, Position position, Position topmostPos, boolean hasDocumentation) {
            this.type = type;
            this.name = name;
            this.position = position;
            this.topMostPosition = topmostPos;
            this.hasDocumentation = hasDocumentation;
        }

        static TopLevelNodeDetail fromFunction(BLangFunction func) {
            if ("main".equals(func.name.value)) {
                return null;
            }
            int sLine = func.pos.sLine - 1;
            sLine = CodeLensUtil.getTopMostLocOfAnnotations(func.annAttachments, sLine);
            sLine = CodeLensUtil.getTopMostLocOfDocs(func.markdownDocumentationAttachment, sLine);
            boolean hasDocs = func.markdownDocumentationAttachment != null;
            Position pos = new Position(func.pos.sLine - 1, 0);
            Position topmostPos = new Position(sLine, 0);
            return new TopLevelNodeDetail("function", func.name.value, pos, topmostPos, hasDocs);
        }

        static TopLevelNodeDetail fromService(BLangService service) {
            int sLine = service.pos.sLine - 1;
            sLine = CodeLensUtil.getTopMostLocOfAnnotations(service.annAttachments, sLine);
            sLine = CodeLensUtil.getTopMostLocOfDocs(service.markdownDocumentationAttachment, sLine);
            boolean hasDocs = service.markdownDocumentationAttachment != null;
            Position pos = new Position(service.pos.sLine - 1, 0);
            Position topmostPos = new Position(sLine, 0);
            return new TopLevelNodeDetail("service", service.name.value, pos, topmostPos, hasDocs);
        }

        static TopLevelNodeDetail fromTypeDefinition(BLangTypeDefinition definition) {
            boolean hasDocs = definition.markdownDocumentationAttachment != null;
            int sLine = definition.pos.sLine - 1;
            sLine = CodeLensUtil.getTopMostLocOfAnnotations(definition.annAttachments, sLine);
            sLine = CodeLensUtil.getTopMostLocOfDocs(definition.markdownDocumentationAttachment, sLine);
            Position pos = new Position(definition.pos.sLine - 1, 0);
            Position topmostPos = new Position(sLine, 0);
            if (definition.typeNode instanceof BLangObjectTypeNode) {
                if (!((BLangObjectTypeNode)definition.typeNode).flagSet.contains(Flag.SERVICE)) {
                    return new TopLevelNodeDetail("object", definition.name.value, pos, topmostPos, hasDocs);
                }
            } else if (definition.typeNode instanceof BLangRecordTypeNode) {
                return new TopLevelNodeDetail("record", definition.name.value, pos, topmostPos, hasDocs);
            }
            return null;
        }
    }
}

