/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses.providers;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.codelenses.EndpointFindVisitor;
import org.ballerinalang.langserver.codelenses.providers.AbstractCodeLensesProvider;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codelenses.CodeLensesProviderKeys;
import org.ballerinalang.langserver.commons.codelenses.LSCodeLensesProviderException;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class EndpointsCodeLensesProvider
extends AbstractCodeLensesProvider {
    public EndpointsCodeLensesProvider() {
        super("endpoints.CodeLenses");
        LSClientConfigHolder.getInstance().register((oldConfig, newConfig) -> {
            this.isEnabled = newConfig.getCodeLens().getEndpoints().isEnabled();
        });
    }

    public List<CodeLens> getLenses(LSContext context) throws LSCodeLensesProviderException {
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        BLangCompilationUnit cUnit = (BLangCompilationUnit)context.get(CodeLensesProviderKeys.COMPILATION_UNIT_KEY);
        this.addEndpointLenses(lenses, cUnit, context);
        return lenses;
    }

    private void addEndpointLenses(List<CodeLens> lenses, BLangCompilationUnit cUnit, LSContext context) {
        EndpointFindVisitor symbolFindVisitor = new EndpointFindVisitor();
        BLangPackage bLangPackage = (BLangPackage)context.get(CodeLensesProviderKeys.BLANG_PACKAGE_KEY);
        if (bLangPackage != null) {
            symbolFindVisitor.visit(cUnit);
            List<BLangNode> endpoints = symbolFindVisitor.getEndpoints();
            for (BLangNode node : endpoints) {
                Command endpointCmd = new Command("Endpoint", null);
                Position pos = new Position(node.pos.sLine - 1, node.pos.sCol);
                CodeLens endpointLens = new CodeLens(new Range(pos, pos), endpointCmd, null);
                lenses.add(endpointLens);
            }
        }
    }
}

