/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.codelenses.CodeLensUtil;
import org.ballerinalang.langserver.codelenses.providers.AbstractCodeLensesProvider;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codelenses.CodeLensesProviderKeys;
import org.ballerinalang.langserver.commons.codelenses.LSCodeLensesProviderException;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangService;

public class ServicesBasedCodeLensesProvider
extends AbstractCodeLensesProvider {
    public ServicesBasedCodeLensesProvider() {
        super("services.CodeLenses");
        LSClientConfigHolder.getInstance().register((oldConfig, newConfig) -> {
            this.isEnabled = newConfig.getCodeLens().getServices().isEnabled();
        });
    }

    public List<CodeLens> getLenses(LSContext context) throws LSCodeLensesProviderException {
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        BLangCompilationUnit cUnit = (BLangCompilationUnit)context.get(CodeLensesProviderKeys.COMPILATION_UNIT_KEY);
        for (TopLevelNode topLevelNode : cUnit.getTopLevelNodes()) {
            this.addServiceLenses(lenses, topLevelNode);
        }
        return lenses;
    }

    private void addServiceLenses(List<CodeLens> lenses, TopLevelNode topLevelNode) {
        if (topLevelNode instanceof BLangService) {
            String serviceTypeName;
            BLangService service = (BLangService)topLevelNode;
            String owner = service.listenerType != null ? service.listenerType.tsymbol.owner.name.value : null;
            String string = serviceTypeName = service.listenerType != null ? service.listenerType.tsymbol.name.value : null;
            if (!"http".equals(owner) || !"Listener".equals(serviceTypeName)) {
                return;
            }
            int sLine = service.pos.sLine - 1;
            sLine = CodeLensUtil.getTopMostLocOfAnnotations(service.annAttachments, sLine);
            sLine = CodeLensUtil.getTopMostLocOfDocs(service.markdownDocumentationAttachment, sLine);
            Position pos = new Position(sLine, 0);
            CommandArgument serviceNameArg = new CommandArgument("service.name", service.name.value);
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Collections.singletonList(serviceNameArg));
            Command showApiEditor = new Command("Show API Design", "ballerina.showAPIEditor", args);
            CodeLens apiEditorLens = new CodeLens(new Range(pos, pos), showApiEditor, null);
            lenses.add(apiEditorLens);
        }
    }
}

