/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class CommandUtil {
    private CommandUtil() {
    }

    public static void notifyClient(LanguageClient client, MessageType messageType, String message) {
        client.showMessage(new MessageParams(messageType, message));
    }

    public static void clearDiagnostics(ExtendedLanguageClient client, DiagnosticsHelper diagHelper, String documentUri, LSContext context) {
        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        try {
            LSDocumentIdentifierImpl lsDocument = new LSDocumentIdentifierImpl(documentUri);
            diagHelper.compileAndSendDiagnostics(client, context, (LSDocumentIdentifier)lsDocument, docManager);
        }
        catch (CompilationFailedException e) {
            String msg = "Computing 'diagnostics' failed!";
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(documentUri);
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
        }
    }

    public static ApplyWorkspaceEditParams applySingleTextEdit(String editText, Range range, VersionedTextDocumentIdentifier identifier, LanguageClient client) {
        ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams();
        TextEdit textEdit = new TextEdit(range, editText);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(identifier, Collections.singletonList(textEdit));
        Either documentChange = Either.forLeft((Object)textDocumentEdit);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(documentChange));
        applyWorkspaceEditParams.setEdit(workspaceEdit);
        if (client != null) {
            client.applyEdit(applyWorkspaceEditParams);
        }
        return applyWorkspaceEditParams;
    }

    public static Object applyWorkspaceEdit(List<Either<TextDocumentEdit, ResourceOperation>> documentChanges, LanguageClient client) {
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(documentChanges);
        ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams(workspaceEdit);
        if (client != null) {
            client.applyEdit(applyWorkspaceEditParams);
        }
        return applyWorkspaceEditParams;
    }

    public static String getContentOfRange(WorkspaceDocumentManager documentManager, String uri, Range range) throws WorkspaceDocumentException, IOException {
        String line;
        Optional<Path> filePath = CommonUtil.getPathFromURI(uri);
        if (!filePath.isPresent()) {
            return "";
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.toString()).orElse(filePath.get());
        String fileContent = documentManager.getFileContent(compilationPath);
        BufferedReader reader = new BufferedReader(new StringReader(fileContent));
        StringBuilder capture = new StringBuilder();
        int sLine = range.getStart().getLine() + 1;
        int eLine = range.getEnd().getLine() + 1;
        int sChar = range.getStart().getCharacter();
        int eChar = range.getEnd().getCharacter();
        for (int lineNum = 1; (line = reader.readLine()) != null && lineNum <= eLine; ++lineNum) {
            if (lineNum < sLine) continue;
            if (sLine == eLine) {
                capture.append(line, sChar, eChar);
                if (line.length() != eChar) continue;
                capture.append(System.lineSeparator());
                continue;
            }
            if (lineNum == sLine) {
                capture.append(line.substring(sChar)).append(System.lineSeparator());
                continue;
            }
            if (lineNum == eLine) {
                capture.append(line, 0, eChar);
                if (line.length() != eChar) continue;
                capture.append(System.lineSeparator());
                continue;
            }
            capture.append(line).append(System.lineSeparator());
        }
        return capture.toString();
    }
}

