/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSCommandExecutorProvidersHolder {
    private static final Logger logger = LoggerFactory.getLogger(LSCommandExecutorProvidersHolder.class);
    private static final Map<String, LSCommandExecutor> executors = new HashMap<String, LSCommandExecutor>();
    private static final LSCommandExecutorProvidersHolder INSTANCE = new LSCommandExecutorProvidersHolder();

    public static LSCommandExecutorProvidersHolder getInstance() {
        return INSTANCE;
    }

    private LSCommandExecutorProvidersHolder() {
        ServiceLoader<LSCommandExecutor> loader = ServiceLoader.load(LSCommandExecutor.class);
        for (LSCommandExecutor executor : loader) {
            if (executor == null) continue;
            executors.put(executor.getCommand(), executor);
        }
    }

    public Optional<LSCommandExecutor> getCommandExecutor(String command) {
        return Optional.ofNullable(executors.get(command));
    }

    public List<String> getCommandsList() {
        return new ArrayList<String>(executors.keySet());
    }
}

