/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.TopLevelNode;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;

public class AddAllDocumentationExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "ADD_ALL_DOC";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        BLangPackage bLangPackage;
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            if (!((JsonObject)arg).get("argumentK").getAsString().equals("doc.uri")) continue;
            String documentUri = ((JsonObject)arg).get("argumentV").getAsString();
            textDocumentIdentifier.setUri(documentUri);
            context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
        }
        try {
            WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
        }
        catch (CompilationFailedException e) {
            throw new LSCommandExecutorException("Couldn't compile the source", (Throwable)e);
        }
        String relativeSourcePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangPackage srcOwnerPkg = CommonUtil.getSourceOwnerBLangPackage(relativeSourcePath, bLangPackage);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        for (TopLevelNode topLevelNode : CommonUtil.getCurrentFileTopLevelNodes(srcOwnerPkg, context)) {
            if (topLevelNode instanceof BLangTypeDefinition && ((BLangTypeDefinition)topLevelNode).flagSet.contains(Flag.SERVICE)) continue;
            DocAttachmentInfo docAttachmentInfo = DocumentationGenerator.getDocumentationEditForNode((Node)topLevelNode);
            if (docAttachmentInfo != null) {
                textEdits.add(AddAllDocumentationExecutor.getTextEdit(docAttachmentInfo));
            }
            if (topLevelNode instanceof BLangService) {
                BLangService service = (BLangService)topLevelNode;
                ((BLangObjectTypeNode)service.serviceTypeDefinition.getTypeNode()).getFunctions().forEach(bLangResource -> {
                    DocAttachmentInfo resourceInfo = DocumentationGenerator.getDocumentationEditForNode((Node)bLangResource);
                    if (resourceInfo != null) {
                        textEdits.add(AddAllDocumentationExecutor.getTextEdit(resourceInfo));
                    }
                });
            }
            if (!(topLevelNode instanceof BLangTypeDefinition) || !(((BLangTypeDefinition)topLevelNode).typeNode instanceof BLangObjectTypeNode)) continue;
            ((BLangObjectTypeNode)((BLangTypeDefinition)topLevelNode).typeNode).functions.forEach(function -> {
                DocAttachmentInfo resourceInfo = DocumentationGenerator.getDocumentationEditForNode((Node)function);
                if (resourceInfo != null) {
                    textEdits.add(AddAllDocumentationExecutor.getTextEdit(resourceInfo));
                }
            });
        }
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(textDocumentIdentifier, textEdits);
        LanguageClient languageClient = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
        return CommandUtil.applyWorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)), languageClient);
    }

    public String getCommand() {
        return COMMAND;
    }

    private static TextEdit getTextEdit(DocAttachmentInfo attachmentInfo) {
        Range range = new Range(attachmentInfo.getDocStartPos(), attachmentInfo.getDocStartPos());
        return new TextEdit(range, attachmentInfo.getDocAttachment());
    }
}

