/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.util.List;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class AddDocumentationExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "ADD_DOC";

    public Object execute(LSContext ctx) throws LSCommandExecutorException {
        BLangPackage bLangPackage;
        String nodeType = "";
        int line = 0;
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (Object arg : (List)ctx.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            switch (((JsonObject)arg).get("argumentK").getAsString()) {
                case "doc.uri": {
                    String documentUri = ((JsonObject)arg).get("argumentV").getAsString();
                    textDocumentIdentifier.setUri(documentUri);
                    ctx.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                    break;
                }
                case "node.type": {
                    nodeType = ((JsonObject)arg).get("argumentV").getAsString();
                    break;
                }
                case "node.line": {
                    line = Integer.parseInt(((JsonObject)arg).get("argumentV").getAsString());
                    break;
                }
            }
        }
        try {
            WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)ctx.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)ctx, (WorkspaceDocumentManager)documentManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
        }
        catch (CompilationFailedException e) {
            throw new LSCommandExecutorException("Couldn't compile the source", (Throwable)e);
        }
        String relativeSourcePath = (String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangPackage srcOwnerPkg = CommonUtil.getSourceOwnerBLangPackage(relativeSourcePath, bLangPackage);
        DocAttachmentInfo docAttachmentInfo = DocumentationGenerator.getDocumentationEditForNodeByPosition(nodeType, srcOwnerPkg, line, ctx);
        if (docAttachmentInfo == null) {
            return new Object();
        }
        Range range = new Range(docAttachmentInfo.getDocStartPos(), docAttachmentInfo.getDocStartPos());
        return CommandUtil.applySingleTextEdit(docAttachmentInfo.getDocAttachment(), range, textDocumentIdentifier, (LanguageClient)ctx.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY));
    }

    public String getCommand() {
        return COMMAND;
    }
}

