/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.util.List;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;

public class ImportModuleExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "IMPORT_MODULE";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        String documentUri = null;
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            switch (((JsonObject)arg).get("argumentK").getAsString()) {
                case "doc.uri": {
                    documentUri = ((JsonObject)arg).get("argumentV").getAsString();
                    textDocumentIdentifier.setUri(documentUri);
                    context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                    break;
                }
                case "module": {
                    context.put(ExecuteCommandKeys.PKG_NAME_KEY, (Object)((JsonObject)arg).get("argumentV").getAsString());
                    break;
                }
            }
        }
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        if (documentUri != null && context.get(ExecuteCommandKeys.PKG_NAME_KEY) != null) {
            try {
                LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)documentManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
            }
            catch (CompilationFailedException e) {
                throw new LSCommandExecutorException("Couldn't compile the source", (Throwable)e);
            }
            String pkgName = (String)context.get(ExecuteCommandKeys.PKG_NAME_KEY);
            context.put(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY, CommonUtil.getCurrentFileImports(context));
            List<BLangImportPackage> imports = CommonUtil.getCurrentFileImports(context);
            Position start = new Position(0, 0);
            if (!imports.isEmpty()) {
                BLangImportPackage last = CommonUtil.getLastItem(imports);
                start = new Position(last.getPosition().getEndLine(), 0);
            }
            Range range = new Range(start, start);
            String importStatement = "import " + pkgName + ";" + CommonUtil.LINE_SEPARATOR;
            return CommandUtil.applySingleTextEdit(importStatement, range, textDocumentIdentifier, (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY));
        }
        return new Object();
    }

    public String getCommand() {
        return COMMAND;
    }
}

