/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors.openapi.openapitoballerina;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.gson.JsonObject;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.util.references.ReferencesKeys;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.ballerinalang.langserver.util.references.SymbolReferencesModel;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiOperation;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiParameter;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiPath;
import org.ballerinalang.openapi.utils.TypeExtractorUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.SourceDirectoryManager;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class AddMissingParameterInBallerinaExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "ADD_MISSING_PARAMETER";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        block40: {
            String documentUri = null;
            VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
            String resourceParameter = null;
            String resourceMethod = null;
            String resourcePath = null;
            int line = -1;
            int column = -1;
            for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
                String argKey = ((JsonObject)arg).get("argumentK").getAsString();
                String argVal = ((JsonObject)arg).get("argumentV").getAsString();
                switch (argKey) {
                    case "doc.uri": {
                        documentUri = argVal;
                        textDocumentIdentifier.setUri(documentUri);
                        context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                        break;
                    }
                    case "node.line": {
                        line = Integer.parseInt(argVal);
                        break;
                    }
                    case "node.column": {
                        column = Integer.parseInt(argVal);
                        break;
                    }
                    case "parameter": {
                        resourceParameter = argVal;
                        break;
                    }
                    case "method": {
                        resourceMethod = argVal;
                        break;
                    }
                    case "path": {
                        resourcePath = argVal;
                        break;
                    }
                }
            }
            if (line == -1 || column == -1 || documentUri == null) {
                throw new LSCommandExecutorException("Invalid parameters received for the create function command!");
            }
            WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
            BLangService serviceNode = null;
            try {
                LSDocumentIdentifier lsDocument = documentManager.getLSDocument(CommonUtil.getPathFromURI(documentUri).get());
                Position pos = new Position(line, column + 1);
                context.put(ReferencesKeys.OFFSET_CURSOR_N_TRY_NEXT_BEST, (Object)true);
                context.put(ReferencesKeys.DO_NOT_SKIP_NULL_SYMBOLS, (Object)true);
                SymbolReferencesModel.Reference refAtCursor = ReferencesUtil.getReferenceAtCursor(context, lsDocument, pos);
                BLangNode bLangNode = refAtCursor.getbLangNode();
                if (bLangNode instanceof BLangService) {
                    serviceNode = (BLangService)bLangNode;
                }
                String contractURI = null;
                if (serviceNode != null) {
                    List annotations = serviceNode.annAttachments;
                    for (BLangAnnotationAttachment annotation : annotations) {
                        if (!(annotation.getExpression() instanceof BLangRecordLiteral)) continue;
                        BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                        for (RecordLiteralNode.RecordField field : recordLiteral.getFields()) {
                            BLangLiteral bLangLiteral;
                            BLangSimpleVarRef contract;
                            Object key;
                            BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                            BLangRecordLiteral.BLangRecordVarNameField keyExpr;
                            if (field.isKeyValueField()) {
                                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                                keyExpr = keyValue.getKey();
                                valueExpr = keyValue.getValue();
                            } else {
                                BLangRecordLiteral.BLangRecordVarNameField varNameField;
                                keyExpr = varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                                valueExpr = varNameField;
                            }
                            if (!(keyExpr instanceof BLangSimpleVarRef) || !((String)(key = (contract = (BLangSimpleVarRef)keyExpr).getVariableName().getValue())).equals("contract") || !(valueExpr instanceof BLangLiteral) || !((bLangLiteral = (BLangLiteral)valueExpr).getValue() instanceof String)) continue;
                            contractURI = (String)bLangLiteral.getValue();
                        }
                    }
                }
                if (contractURI == null) break block40;
                String separator = File.separator;
                SourceDirectoryManager sourceDirectoryManager = SourceDirectoryManager.getInstance((CompilerContext)((CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY)));
                String sourceDir = sourceDirectoryManager.getSourceDirectory().getPath().toString();
                String filePath = serviceNode.getPosition().getSource().getPackageName() + separator + serviceNode.getPosition().getSource().getCompilationUnitName().replaceAll("\\w*\\.bal", "");
                String projectDir = filePath.contains(sourceDir) ? sourceDir : sourceDir + separator + "src" + separator + filePath;
                File file = null;
                if (contractURI.contains(projectDir)) {
                    file = new File(contractURI);
                } else {
                    try {
                        file = new File(java.nio.file.Paths.get(projectDir, contractURI).toRealPath(new LinkOption[0]).toString());
                    }
                    catch (IOException e) {
                        contractURI = java.nio.file.Paths.get(contractURI, new String[0]).toString();
                    }
                }
                if (file != null && file.exists()) {
                    contractURI = file.getAbsolutePath();
                }
                OpenAPI openAPI = AddMissingParameterInBallerinaExecutor.parseOpenAPIFile(contractURI);
                String editText = "";
                List<BallerinaOpenApiPath> paths = AddMissingParameterInBallerinaExecutor.extractOpenApiPaths(openAPI.getPaths());
                for (BallerinaOpenApiPath ballerinaOpenApiPath : paths) {
                    if (!ballerinaOpenApiPath.getPath().equals(resourcePath)) continue;
                    for (BallerinaOpenApiOperation operation : ballerinaOpenApiPath.getOperationsList()) {
                        if (!operation.getOpMethod().equalsIgnoreCase(resourceMethod)) continue;
                        for (BallerinaOpenApiParameter openApiParameter : operation.getParameterList()) {
                            if (!openApiParameter.getParamName().equals(resourceParameter)) continue;
                            editText = this.getContent(openApiParameter);
                        }
                    }
                }
                BLangFunction function = null;
                for (BLangFunction resourceFunction : serviceNode.resourceFunctions) {
                    boolean isPathMatch = false;
                    boolean isMethodMatch = false;
                    for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)((BLangAnnotationAttachment)resourceFunction.annAttachments.get((int)0)).expr).fields) {
                        BLangRecordLiteral.BLangRecordKeyValueField fieldValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        if (((BLangSimpleVarRef)fieldValue.key.expr).variableName.value.equals("path") && ((BLangLiteral)fieldValue.valueExpr).value.equals(resourcePath)) {
                            isPathMatch = true;
                        }
                        if (((BLangSimpleVarRef)fieldValue.key.expr).variableName.value.equals("methods") && fieldValue.valueExpr instanceof BLangListConstructorExpr && ((BLangLiteral)((BLangListConstructorExpr)fieldValue.valueExpr).exprs.get((int)0)).value.toString().equalsIgnoreCase(resourceMethod)) {
                            isMethodMatch = true;
                        }
                        if (!isPathMatch || !isMethodMatch) continue;
                        function = resourceFunction;
                        break;
                    }
                    if (!isPathMatch || !isMethodMatch) continue;
                    break;
                }
                ArrayList<TextEdit> arrayList = new ArrayList<TextEdit>();
                if (function != null) {
                    LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
                    DiagnosticPos lastParaPos = ((BLangSimpleVariable)function.requiredParams.get((int)(function.requiredParams.size() - 1))).pos;
                    Range range = new Range(new Position(lastParaPos.eLine - 1, lastParaPos.eCol - 1), new Position(lastParaPos.eLine - 1, lastParaPos.eCol - 1));
                    arrayList.add(new TextEdit(range, editText));
                    TextDocumentEdit textDocumentEdit = new TextDocumentEdit(textDocumentIdentifier, arrayList);
                    return CommandUtil.applyWorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)), client);
                }
                return null;
            }
            catch (CompilationFailedException e) {
                throw new LSCommandExecutorException("Error while compiling the source!");
            }
            catch (IOException | WorkspaceDocumentException | BallerinaOpenApiException e) {
                throw new LSCommandExecutorException("Couldn't find the function node!");
            }
        }
        return null;
    }

    static OpenAPI parseOpenAPIFile(String definitionURI) {
        Path contractPath = java.nio.file.Paths.get(definitionURI, new String[0]);
        if (Files.exists(contractPath, new LinkOption[0]) && (definitionURI.endsWith(".yaml") || definitionURI.endsWith(".json"))) {
            return new OpenAPIV3Parser().read(definitionURI);
        }
        return null;
    }

    private static List<BallerinaOpenApiPath> extractOpenApiPaths(Paths defPaths) throws BallerinaOpenApiException {
        ArrayList<BallerinaOpenApiPath> paths = new ArrayList<BallerinaOpenApiPath>();
        for (Map.Entry nextPath : defPaths.entrySet()) {
            String pathName = (String)nextPath.getKey();
            PathItem pathObject = (PathItem)nextPath.getValue();
            BallerinaOpenApiPath typePath = new BallerinaOpenApiPath();
            typePath.setPath(pathName);
            typePath.setOperationsList(TypeExtractorUtil.extractOpenApiOperations((Map)pathObject.readOperationsMap(), (String)pathName));
            paths.add(typePath);
        }
        return paths;
    }

    private String getContent(BallerinaOpenApiParameter object) throws IOException {
        Template template = this.compileTemplate("/openAPITemplates");
        Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, new CustomFieldValueResolver()}).build();
        return template.apply(context);
    }

    private Template compileTemplate(String defaultTemplateDir) throws IOException {
        defaultTemplateDir = defaultTemplateDir.replaceAll("\\\\", "/");
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.setInfiniteLoops(true);
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            CharSequence result = object != null ? (object.toString().equals(param0.toString()) ? options.fn(options.context) : options.inverse()) : null;
            return result;
        });
        return handlebars.compile("balFunctionParameter");
    }

    public String getCommand() {
        return COMMAND;
    }

    static class CustomFieldValueResolver
    extends FieldValueResolver {
        CustomFieldValueResolver() {
        }

        protected Set<FieldValueResolver.FieldWrapper> members(Class<?> clazz) {
            Set members = super.members(clazz);
            return members.stream().filter(fw -> this.isValidField((FieldValueResolver.FieldWrapper)fw)).collect(Collectors.toSet());
        }

        boolean isValidField(FieldValueResolver.FieldWrapper fw) {
            if (fw instanceof AccessibleObject) {
                return this.isUseSetAccessible((Member)fw);
            }
            return true;
        }
    }
}

