/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.ValueSpaceGenerator;
import org.ballerinalang.langserver.command.testgen.renderer.BLangPkgBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.TemplateBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.template.RootTemplate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.TextEdit;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;

public class TestGenerator {
    private TestGenerator() {
    }

    public static List<TextEdit> generate(WorkspaceDocumentManager documentManager, BLangNode bLangNode, BiConsumer<Integer, Integer> focusLineAcceptor, BLangPackage builtSourceFile, String pkgRelativePath, File testFile) throws TestGeneratorException {
        RootTemplate template = TestGenerator.getRootTemplate(pkgRelativePath, bLangNode, builtSourceFile, focusLineAcceptor);
        RendererOutput rendererOutput = TestGenerator.getRendererOutput(documentManager, testFile, focusLineAcceptor);
        template.render(rendererOutput);
        return rendererOutput.getRenderedTextEdits();
    }

    private static RendererOutput getRendererOutput(WorkspaceDocumentManager documentManager, File testFile, BiConsumer<Integer, Integer> focusLineAcceptor) throws TestGeneratorException {
        RendererOutput fileTemplate;
        String testContent = "";
        if (testFile.exists()) {
            try {
                testContent = documentManager.getFileContent(testFile.toPath());
            }
            catch (WorkspaceDocumentException e) {
                throw new TestGeneratorException("Error occurred while compiling file path:" + testFile.toString(), e);
            }
        }
        if (testContent.isEmpty()) {
            fileTemplate = new TemplateBasedRendererOutput("rootTest.bal");
        } else {
            BallerinaFile ballerinaFile;
            try {
                ballerinaFile = ExtendedLSCompiler.compileContent((String)testContent, (CompilerPhase)CompilerPhase.COMPILER_PLUGIN);
            }
            catch (CompilationFailedException e) {
                throw new TestGeneratorException("Could not compile the test content", e);
            }
            Optional optBLangPackage = ballerinaFile.getBLangPackage();
            if (optBLangPackage.isPresent()) {
                fileTemplate = new BLangPkgBasedRendererOutput((BLangPackage)optBLangPackage.get(), focusLineAcceptor);
            } else {
                String msg = "Appending failed! unknown error occurred while appending to:" + testFile.toString();
                throw new TestGeneratorException(msg);
            }
        }
        return fileTemplate;
    }

    private static RootTemplate getRootTemplate(String fileName, BLangNode bLangNode, BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) throws TestGeneratorException {
        if (bLangNode == null) {
            throw new TestGeneratorException("Target test construct not found!");
        }
        if (bLangNode instanceof BLangFunction) {
            return RootTemplate.fromFunction((BLangFunction)bLangNode, builtTestFile, focusLineAcceptor);
        }
        if (bLangNode instanceof BLangService || TestGenerator.hasServiceConstructor(bLangNode)) {
            BLangService service = bLangNode instanceof BLangService ? (BLangService)bLangNode : ((BLangServiceConstructorExpr)((BLangSimpleVariable)bLangNode).expr).serviceNode;
            String owner = service.listenerType != null ? service.listenerType.tsymbol.owner.name.value : null;
            String serviceTypeName = service.listenerType != null ? service.listenerType.tsymbol.name.value : null;
            Optional<BLangTypeInit> optionalServiceInit = TestGenerator.getServiceInit(builtTestFile, service);
            RootTemplate[] t = new RootTemplate[]{null};
            optionalServiceInit.ifPresent(init -> {
                if ("http".equals(owner)) {
                    switch (serviceTypeName) {
                        case "Listener": {
                            t[0] = RootTemplate.fromHttpService(service, init, builtTestFile, focusLineAcceptor);
                            break;
                        }
                        case "WebSocketListener": {
                            t[0] = RootTemplate.fromHttpWSService(service, init, builtTestFile, focusLineAcceptor);
                            break;
                        }
                    }
                }
            });
            if (t[0] == null) {
                if (TestGenerator.hasServiceConstructor(bLangNode)) {
                    throw new TestGeneratorException("Services assigned to the variables are not supported!");
                }
                throw new TestGeneratorException(owner + ":" + serviceTypeName + " services are not supported!");
            }
            return t[0];
        }
        return new RootTemplate(fileName, builtTestFile, focusLineAcceptor);
    }

    private static boolean hasServiceConstructor(BLangNode bLangNode) {
        return bLangNode instanceof BLangSimpleVariable && ((BLangSimpleVariable)bLangNode).expr instanceof BLangServiceConstructorExpr;
    }

    public static Optional<BLangTypeInit> getServiceInit(BLangPackage builtTestFile, BLangService service) {
        if (service.attachedExprs.isEmpty()) {
            return Optional.empty();
        }
        BLangExpression expr = (BLangExpression)service.attachedExprs.get(0);
        if (expr instanceof BLangTypeInit) {
            return Optional.of((BLangTypeInit)expr);
        }
        String[] variableName = new String[]{""};
        if (expr instanceof BLangSimpleVarRef) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
            variableName[0] = varRef.variableName.value;
        }
        for (TopLevelNode topLevelNode : builtTestFile.topLevelNodes) {
            if (!(topLevelNode instanceof BLangSimpleVariable)) continue;
            BLangSimpleVariable var = (BLangSimpleVariable)topLevelNode;
            BLangExpression varExpr = var.expr;
            if (!(varExpr instanceof BLangTypeInit) || !variableName[0].equals(var.name.value)) continue;
            return Optional.of((BLangTypeInit)varExpr);
        }
        return Optional.empty();
    }

    public static class TestFunctionGenerator {
        public static final int VALUE_SPACE_LENGTH = 4;
        private String[][] valueSpace;
        private String[] typeSpace;
        private String[] namesSpace;
        private String functionName;
        private String returnType;
        private int paramsCount;

        public TestFunctionGenerator(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangFunction function) {
            List params = function.requiredParams;
            List<BLangType> paramTypes = params.stream().map(variable -> variable.typeNode).collect(Collectors.toList());
            ArrayList<String> paramNames = new ArrayList<String>();
            params.forEach(variable -> paramNames.add(variable.name.value));
            this.init(importsAcceptor, currentPkgId, function.name.value, paramNames, paramTypes, function.returnTypeNode);
        }

        public TestFunctionGenerator(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangFunctionTypeNode type) {
            List params = type.params;
            this.paramsCount = type.params.size();
            List<BLangType> paramTypes = params.stream().map(variable -> variable.typeNode).collect(Collectors.toList());
            ArrayList<String> paramNames = new ArrayList<String>();
            params.forEach(variable -> {
                if (variable instanceof BLangSimpleVariable) {
                    paramNames.add(((BLangSimpleVariable)variable).name.value);
                } else {
                    paramNames.add(null);
                }
            });
            this.init(importsAcceptor, currentPkgId, "", paramNames, paramTypes, type.returnTypeNode);
        }

        public TestFunctionGenerator(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BInvokableType invokableType) {
            boolean hasReturnType = true;
            if (invokableType.retType == null || invokableType.retType instanceof BNilType) {
                hasReturnType = false;
            }
            this.functionName = "";
            List params = invokableType.paramTypes;
            this.paramsCount = params.size();
            BType returnBType = invokableType.retType;
            this.valueSpace = new String[4][params.size() + 1];
            this.typeSpace = new String[params.size() + 1];
            this.namesSpace = new String[params.size() + 1];
            HashSet<String> lookupSet = new HashSet<String>();
            for (int i = 0; i < params.size(); ++i) {
                String paramType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, (BType)params.get(i));
                String paramName = CommonUtil.generateName(1, lookupSet);
                lookupSet.add(paramName);
                this.typeSpace[i] = paramType;
                this.namesSpace[i] = paramName;
                String[] pValueSpace = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, (BType)params.get(i), ValueSpaceGenerator.createTemplateArray(4));
                for (int j = 0; j < pValueSpace.length; ++j) {
                    this.valueSpace[j][i] = pValueSpace[j];
                }
            }
            if (hasReturnType) {
                this.returnType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, returnBType);
                String[] rtValSpace = ValueSpaceGenerator.getValueSpaceByType(importsAcceptor, currentPkgId, returnBType, ValueSpaceGenerator.createTemplateArray(4));
                this.typeSpace[params.size()] = this.returnType;
                this.namesSpace[params.size()] = "expected";
                IntStream.range(0, rtValSpace.length).forEach(index -> {
                    this.valueSpace[index][params.size()] = rtValSpace[index];
                });
            }
        }

        private void init(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, String functionName, List<String> paramNames, List<BLangType> paramTypes, BLangType returnTypeNode) {
            boolean hasReturnType = true;
            if (returnTypeNode instanceof BLangValueType && TypeKind.NIL.equals((Object)((BLangValueType)returnTypeNode).getTypeKind())) {
                hasReturnType = false;
            }
            this.functionName = functionName;
            this.paramsCount = paramNames.size();
            this.valueSpace = new String[4][paramNames.size() + (hasReturnType ? 1 : 0)];
            this.typeSpace = new String[paramNames.size() + (hasReturnType ? 1 : 0)];
            this.namesSpace = new String[paramNames.size() + (hasReturnType ? 1 : 0)];
            HashSet<String> lookupSet = new HashSet<String>();
            for (int i = 0; i < paramNames.size(); ++i) {
                String paramType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, (BLangNode)paramTypes.get(i));
                String paramName = paramNames.get(i);
                if (paramName == null) {
                    paramName = CommonUtil.generateName(1, lookupSet);
                }
                this.typeSpace[i] = paramType;
                this.namesSpace[i] = paramName;
                String[] pValueSpace = ValueSpaceGenerator.getValueSpaceByNode(importsAcceptor, currentPkgId, (BLangNode)paramTypes.get(i), ValueSpaceGenerator.createTemplateArray(4));
                for (int j = 0; j < pValueSpace.length; ++j) {
                    this.valueSpace[j][i] = pValueSpace[j];
                }
                lookupSet.add(paramName);
            }
            if (hasReturnType) {
                this.returnType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, (BLangNode)returnTypeNode);
                String[] rtValSpace = ValueSpaceGenerator.getValueSpaceByNode(importsAcceptor, currentPkgId, (BLangNode)returnTypeNode, ValueSpaceGenerator.createTemplateArray(4));
                this.typeSpace[paramNames.size()] = this.returnType;
                this.namesSpace[paramNames.size()] = "expected";
                IntStream.range(0, rtValSpace.length).forEach(index -> {
                    this.valueSpace[index][paramNames.size()] = rtValSpace[index];
                });
            }
        }

        public String getTestFuncParams() {
            StringJoiner paramsStr = new StringJoiner(", ");
            IntStream.range(0, this.namesSpace.length).forEach(index -> {
                String type = this.typeSpace[index];
                String name = this.namesSpace[index];
                paramsStr.add(type + " " + name);
            });
            return paramsStr.toString();
        }

        public List<String> getTargetFuncInvocations() {
            ArrayList<String> invocations = new ArrayList<String>();
            IntStream.range(0, this.valueSpace.length - 1).forEach(j -> {
                StringJoiner paramsInvokeStr = new StringJoiner(", ");
                IntStream.range(0, this.namesSpace.length - 1).forEach(i -> paramsInvokeStr.add(this.valueSpace[j][i]));
                invocations.add(this.functionName + "(" + paramsInvokeStr.toString() + ")");
            });
            return invocations;
        }

        public String getTargetFuncInvocation() {
            StringJoiner paramsInvokeStr = new StringJoiner(", ");
            IntStream.range(0, this.paramsCount).forEach(i -> paramsInvokeStr.add(this.namesSpace[i]));
            return this.functionName + "(" + paramsInvokeStr.toString() + ")";
        }

        public String getDataProviderReturnType() {
            StringJoiner paramsTypeStr = new StringJoiner(", ");
            IntStream.range(0, this.typeSpace.length).forEach(i -> paramsTypeStr.add(this.typeSpace[i]));
            return "(" + paramsTypeStr.toString() + ")[]";
        }

        public String getTargetFuncReturnType() {
            return this.returnType;
        }

        public String getDataProviderReturnValue() {
            StringJoiner vSpace = new StringJoiner("), (", "(", ")");
            IntStream.range(0, this.valueSpace.length).forEach(index -> vSpace.add(String.join((CharSequence)", ", this.valueSpace[index])));
            return "[" + vSpace.toString() + "]";
        }

        public String[][] getValueSpace() {
            return (String[][])this.valueSpace.clone();
        }

        public String[] getTypeSpace() {
            return (String[])this.typeSpace.clone();
        }

        public String[] getNamesSpace() {
            return (String[])this.namesSpace.clone();
        }

        public int getParamsCount() {
            return this.paramsCount;
        }
    }
}

