/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangPkgBasedRendererOutput
implements RendererOutput {
    private BLangPackage bLangPackageOfTestFile;
    private Map<DiagnosticPos, Map<String, String>> positions = new HashMap<DiagnosticPos, Map<String, String>>();
    private BiConsumer<Integer, Integer> focusLineAcceptor;
    private String focusFunctionName;

    public BLangPkgBasedRendererOutput(BLangPackage bLangPackage, BiConsumer<Integer, Integer> focusLineAcceptor) {
        this.bLangPackageOfTestFile = bLangPackage;
        this.focusLineAcceptor = focusLineAcceptor;
    }

    @Override
    public void append(PlaceHolder placeHolder, String content) {
        this.merge(placeHolder, oldContent -> (oldContent == null ? "" : oldContent) + content);
    }

    @Override
    public void prepend(PlaceHolder placeHolder, String content) {
        this.merge(placeHolder, oldContent -> content + (oldContent == null ? "" : oldContent));
    }

    private void merge(PlaceHolder placeHolder, Function<String, String> merger) {
        DiagnosticPos position = placeHolder.getPosition(this.bLangPackageOfTestFile);
        HashMap<String, String> placeHolders = this.positions.get(position);
        placeHolders = placeHolders == null ? new HashMap<String, String>() : placeHolders;
        String oldContent = (String)placeHolders.get(placeHolder.getName());
        String newContent = merger.apply(oldContent);
        placeHolders.put(placeHolder.getName(), newContent);
        this.positions.put(position, placeHolders);
        this.computeFocusPosition(placeHolder, newContent, position.eLine);
    }

    @Override
    public void put(PlaceHolder placeHolder, String content) {
        DiagnosticPos position = placeHolder.getPosition(this.bLangPackageOfTestFile);
        HashMap<String, String> placeHolders = this.positions.get(position);
        placeHolders = placeHolders == null ? new HashMap<String, String>() : placeHolders;
        placeHolders.put(placeHolder.getName(), content);
        this.positions.put(position, placeHolders);
    }

    @Override
    public List<TextEdit> getRenderedTextEdits() {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        this.positions.forEach((pos, value) -> value.forEach((placeHolder, content) -> {
            Position position = new Position(pos.eLine, pos.eCol);
            Range range = new Range(position, position);
            TextEdit textEdit = new TextEdit(range, content);
            edits.add(textEdit);
        }));
        return edits;
    }

    @Override
    public String getRenderedContent() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void setFocusLineAcceptor(String functionName, BiConsumer<Integer, Integer> acceptor) {
        this.focusFunctionName = functionName;
        this.focusLineAcceptor = acceptor;
    }

    private void computeFocusPosition(PlaceHolder placeHolder, String newContent, int index) {
        if (placeHolder == PlaceHolder.CONTENT && this.focusLineAcceptor != null) {
            String[] lines = newContent.split("\\r?\\n");
            IntStream.range(0, lines.length).filter(i -> lines[i].contains("function " + this.focusFunctionName)).findFirst().ifPresent(i -> this.focusLineAcceptor.accept(index + i, 0));
        }
    }
}

