/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.renderer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TemplateBasedRendererOutput
implements RendererOutput {
    private String content;
    private Map<String, String> placeHolders = new HashMap<String, String>();
    private BiConsumer<Integer, Integer> focusLineAcceptor;
    private String focusFunctionName;

    public TemplateBasedRendererOutput(String templateFileName) throws TestGeneratorException {
        InputStream resource = TemplateBasedRendererOutput.class.getClassLoader().getResourceAsStream("testgen" + File.separator + "template" + File.separator + templateFileName);
        try {
            this.content = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TestGeneratorException("Error occurred while reading template file:" + templateFileName, e);
        }
    }

    @Override
    public void append(PlaceHolder placeHolder, String content) {
        String placeHolderName = placeHolder.getName();
        String oldContent = this.placeHolders.get(placeHolderName);
        this.placeHolders.put(placeHolderName, (oldContent == null ? "" : oldContent) + content);
    }

    @Override
    public void prepend(PlaceHolder placeHolder, String content) {
        String placeHolderName = placeHolder.getName();
        String oldContent = this.placeHolders.get(placeHolderName);
        this.placeHolders.put(placeHolderName, content + (oldContent == null ? "" : oldContent));
    }

    @Override
    public void put(PlaceHolder placeHolder, String content) {
        String placeHolderName = placeHolder.getName();
        this.placeHolders.put(placeHolderName, content);
    }

    @Override
    public List<TextEdit> getRenderedTextEdits() {
        Position position = new Position(0, 0);
        Range range = new Range(position, position);
        TextEdit textEdit = new TextEdit(range, this.getRenderedContent());
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(textEdit);
        return edits;
    }

    @Override
    public String getRenderedContent() {
        String[] result = new String[]{this.content};
        this.placeHolders.forEach((key, value) -> {
            result[0] = result[0].replaceAll("\\$\\{" + key + "}", Matcher.quoteReplacement(value));
            this.computeFocusPosition((String)key, result[0]);
        });
        result[0] = result[0].replaceAll("\\$\\{.*}[\\r\\n|\\r|\\n]*", "");
        return result[0];
    }

    @Override
    public void setFocusLineAcceptor(String focusFunctionName, BiConsumer<Integer, Integer> acceptor) {
        this.focusFunctionName = focusFunctionName;
        this.focusLineAcceptor = acceptor;
    }

    private void computeFocusPosition(String placeHolderName, String newContent) {
        if (PlaceHolder.CONTENT.getName().equals(placeHolderName) && this.focusLineAcceptor != null) {
            String[] lines = newContent.split("\\r?\\n");
            IntStream.range(0, lines.length).filter(i -> lines[i].contains("function " + this.focusFunctionName)).findFirst().ifPresent(i -> this.focusLineAcceptor.accept(i - 2 < 0 ? 0 : i - 2, 0));
        }
    }
}

