/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.command.testgen.AnnotationConfigsProcessor;
import org.ballerinalang.langserver.command.testgen.template.TestTemplate;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public abstract class AbstractTestTemplate
implements TestTemplate {
    protected static final String DEFAULT_IP = "0.0.0.0";
    protected static final String DEFAULT_PORT = "9092";
    protected static final String HTTP = "http://";
    protected static final String HTTPS = "https://";
    protected static final String WS = "ws://";
    protected static final String WSS = "wss://";
    protected final BiConsumer<Integer, Integer> focusLineAcceptor;
    protected final BLangPackage builtTestFile;
    protected final List<Pair<String, String>> imports;

    public AbstractTestTemplate(BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) {
        this.focusLineAcceptor = focusLineAcceptor;
        this.builtTestFile = builtTestFile;
        this.imports = new ArrayList<Pair<String, String>>();
        if (builtTestFile != null) {
            builtTestFile.testablePkgs.forEach(testablePkg -> testablePkg.getCompilationUnits().forEach(unit -> unit.getTopLevelNodes().forEach(node -> {
                if (node instanceof BLangImportPackage) {
                    BLangImportPackage pkg = (BLangImportPackage)node;
                    String orgName = pkg.orgName.value;
                    String alias = pkg.alias.value;
                    this.imports.add((Pair<String, String>)new ImmutablePair((Object)orgName, (Object)alias));
                }
            })));
        }
    }

    protected static String upperCaseFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase(Locale.getDefault()) + name.substring(1);
    }

    protected static String lowerCaseFirstLetter(String name) {
        return name.substring(0, 1).toLowerCase(Locale.getDefault()) + name.substring(1);
    }

    protected boolean isNonExistImport(String orgName, String alias) {
        return this.imports.stream().noneMatch(pair -> ((String)pair.getLeft()).equals(orgName) && ((String)pair.getRight()).equals(alias));
    }

    protected String getSafeName(String name) {
        List<String> names = this.builtTestFile.getGlobalVariables().stream().map(variable -> variable.name.value).collect(Collectors.toList());
        Optional testablePkg = this.builtTestFile.testablePkgs.stream().findAny();
        testablePkg.ifPresent(pkg -> names.addAll(pkg.getGlobalVariables().stream().map(variable -> variable.name.value).collect(Collectors.toList())));
        names.addAll(this.builtTestFile.getFunctions().stream().map(function -> function.name.value).collect(Collectors.toList()));
        testablePkg.ifPresent(pkg -> names.addAll(pkg.getFunctions().stream().map(function -> function.name.value).collect(Collectors.toList())));
        names.addAll(this.builtTestFile.getServices().stream().map(service -> service.name.value).collect(Collectors.toList()));
        testablePkg.ifPresent(pkg -> names.addAll(pkg.getServices().stream().map(service -> service.name.value).collect(Collectors.toList())));
        return this.getSafeName(name, names);
    }

    protected boolean isSecureService(BLangTypeInit init) {
        for (BLangExpression expression : init.initInvocation.argExprs) {
            if (!(expression instanceof BLangNamedArgsExpression)) continue;
            BLangNamedArgsExpression namedArgsExpression = (BLangNamedArgsExpression)expression;
            if (!namedArgsExpression.name.value.equals("config") || !(namedArgsExpression.expr instanceof BLangRecordLiteral)) continue;
            return AnnotationConfigsProcessor.isRecordValueExists("secureSocket", (BLangRecordLiteral)namedArgsExpression.expr);
        }
        return false;
    }

    protected Optional<String> findServicePort(BLangTypeInit init) {
        BLangExpression bLangExpression = (BLangExpression)init.initInvocation.requiredArgs.get(0);
        if (bLangExpression instanceof BLangLiteral) {
            BLangLiteral literal = (BLangLiteral)bLangExpression;
            Object value = literal.value;
            if (value instanceof Long) {
                return Optional.of(String.valueOf(value));
            }
        }
        return Optional.empty();
    }

    private String getSafeName(String name, List<String> nodeNames) {
        boolean loop = true;
        int counter = 1;
        String prefix = "";
        block0: while (loop) {
            loop = false;
            for (String nodeName : nodeNames) {
                if (!nodeName.equals(name + prefix)) continue;
                prefix = "" + ++counter;
                loop = true;
                continue block0;
            }
        }
        return name + prefix;
    }
}

