/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template;

import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public enum PlaceHolder {
    DECLARATIONS("declarations"){

        @Override
        public DiagnosticPos getPosition(BLangPackage bLangPackage) {
            DiagnosticPos[] pos = new DiagnosticPos[]{new DiagnosticPos(null, 0, 0, 0, 0)};
            bLangPackage.getImports().forEach(imp -> {
                pos[0] = PlaceHolder.getMaximumPosition(imp.getPosition(), pos[0]);
            });
            bLangPackage.getGlobalVariables().forEach(var -> {
                pos[0] = PlaceHolder.getMaximumPosition(var.getPosition(), pos[0]);
            });
            return PlaceHolder.zeroColumnPosition(pos[0]);
        }
    }
    ,
    CONTENT("content"){

        @Override
        public DiagnosticPos getPosition(BLangPackage bLangPackage) {
            DiagnosticPos[] pos = new DiagnosticPos[]{new DiagnosticPos(null, 0, 0, 0, 0)};
            bLangPackage.topLevelNodes.forEach(topLevelNode -> {
                if (topLevelNode instanceof BLangNode) {
                    pos[0] = PlaceHolder.getMaximumPosition(((BLangNode)topLevelNode).getPosition(), pos[0]);
                }
            });
            ++pos[0].eLine;
            pos[0].sLine = pos[0].eLine;
            return PlaceHolder.zeroColumnPosition(pos[0]);
        }
    }
    ,
    IMPORTS("imports"){

        @Override
        public DiagnosticPos getPosition(BLangPackage bLangPackage) {
            DiagnosticPos[] pos = new DiagnosticPos[]{new DiagnosticPos(null, 0, 0, 0, 0)};
            bLangPackage.getImports().forEach(pkg -> {
                pos[0] = PlaceHolder.getMaximumPosition(pkg.getPosition(), pos[0]);
            });
            return PlaceHolder.zeroColumnPosition(pos[0]);
        }
    }
    ,
    OTHER("_other_"){

        @Override
        public DiagnosticPos getPosition(BLangPackage bLangPackage) {
            throw new UnsupportedOperationException("Not supported!");
        }

        @Override
        public PlaceHolder get(String name) {
            this.name = name;
            return this;
        }
    };

    protected String name;

    private PlaceHolder(String name) {
        this.name = name;
    }

    private static DiagnosticPos zeroColumnPosition(DiagnosticPos pos) {
        pos.sCol = 0;
        pos.eCol = 0;
        return pos;
    }

    private static DiagnosticPos getMaximumPosition(DiagnosticPos pos1, DiagnosticPos pos2) {
        if (pos1 == null) {
            return pos2;
        }
        if (pos2 == null) {
            return pos1;
        }
        if (pos1.getEndLine() > pos2.getEndLine()) {
            return pos1;
        }
        if (pos1.getEndLine() < pos2.getEndLine()) {
            return pos2;
        }
        if (pos1.getEndColumn() > pos2.getEndColumn()) {
            return pos1;
        }
        return pos2;
    }

    public abstract DiagnosticPos getPosition(BLangPackage var1);

    public String getName() {
        return this.name;
    }

    public PlaceHolder get(String name) {
        throw new UnsupportedOperationException("Not supported!");
    }
}

