/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template.type;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.ballerinalang.langserver.command.testgen.AnnotationConfigsProcessor;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.TemplateBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.template.AbstractTestTemplate;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.ballerinalang.langserver.command.testgen.template.type.HttpResourceTemplate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class HttpServiceTemplate
extends AbstractTestTemplate {
    private final String serviceUri;
    private final boolean isSecure;
    private final String serviceUriStrName;
    private final String testServiceFunctionName;
    private final String serviceBasePath;
    private final List<BLangFunction> resources;

    public HttpServiceTemplate(BLangPackage builtTestFile, BLangService service, BLangTypeInit init, BiConsumer<Integer, Integer> focusLineAcceptor) {
        super(builtTestFile, focusLineAcceptor);
        String serviceName = service.name.value;
        String serviceUriTemp = "http://0.0.0.0:9092";
        boolean isSecureTemp = this.isSecureService(init);
        String protocol = isSecureTemp ? "https://" : "http://";
        Optional<String> optionalPort = this.findServicePort(init);
        serviceUriTemp = optionalPort.map(port -> protocol + "0.0.0.0" + ":" + port).orElse(serviceUriTemp);
        this.isSecure = isSecureTemp;
        this.serviceUri = serviceUriTemp;
        String tempServiceBasePath = "/" + serviceName;
        for (BLangAnnotationAttachment annotation : service.annAttachments) {
            if (!(annotation.expr instanceof BLangRecordLiteral)) continue;
            BLangRecordLiteral record = (BLangRecordLiteral)annotation.expr;
            Optional<String> basePath = AnnotationConfigsProcessor.searchStringField("basePath", record);
            tempServiceBasePath = basePath.orElse(tempServiceBasePath);
        }
        this.serviceUriStrName = this.getSafeName(HttpServiceTemplate.lowerCaseFirstLetter(serviceName) + "Uri");
        this.testServiceFunctionName = this.getSafeName("test" + HttpServiceTemplate.upperCaseFirstLetter(serviceName));
        this.serviceBasePath = tempServiceBasePath;
        this.resources = service.getResources();
    }

    @Override
    public void render(RendererOutput rendererOutput) throws TestGeneratorException {
        String filename = this.isSecure ? "httpsService.bal" : "httpService.bal";
        String httpEndpoint = this.getSafeName("httpEndpoint");
        TemplateBasedRendererOutput serviceOutput = new TemplateBasedRendererOutput(filename);
        serviceOutput.put(PlaceHolder.OTHER.get("testServiceFunctionName"), this.testServiceFunctionName);
        serviceOutput.put(PlaceHolder.OTHER.get("serviceUriStrName"), this.serviceUriStrName);
        serviceOutput.put(PlaceHolder.OTHER.get("endpointName"), httpEndpoint);
        for (BLangFunction resource : this.resources) {
            HttpResourceTemplate resTemplate = new HttpResourceTemplate(this.serviceUriStrName, this.serviceBasePath, resource, httpEndpoint);
            resTemplate.render(serviceOutput);
        }
        rendererOutput.setFocusLineAcceptor(this.testServiceFunctionName, this.focusLineAcceptor);
        rendererOutput.append(PlaceHolder.DECLARATIONS, this.getServiceUriDeclaration() + CommonUtil.LINE_SEPARATOR);
        rendererOutput.append(PlaceHolder.CONTENT, CommonUtil.LINE_SEPARATOR + serviceOutput.getRenderedContent());
    }

    private String getServiceUriDeclaration() {
        return "string " + this.serviceUriStrName + " = \"" + this.serviceUri + "\";";
    }
}

