/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template.type;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.ballerinalang.langserver.command.testgen.AnnotationConfigsProcessor;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.TemplateBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.template.AbstractTestTemplate;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class WSServiceTemplate
extends AbstractTestTemplate {
    private final String serviceUri;
    private final boolean isSecure;
    private final String serviceUriStrName;
    private final String serviceChannelName;
    private final String testServiceFunctionName;
    private final String callbackServiceName;

    public WSServiceTemplate(BLangPackage builtTestFile, BLangService service, BLangTypeInit init, BiConsumer<Integer, Integer> focusLineAcceptor) {
        super(builtTestFile, focusLineAcceptor);
        String tempServiceUri = "ws://0.0.0.0:9092";
        boolean isSecureTemp = this.isSecureService(init);
        String protocol = isSecureTemp ? "wss://" : "ws://";
        Optional<String> optionalPort = this.findServicePort(init);
        tempServiceUri = optionalPort.map(port -> protocol + "0.0.0.0" + ":" + port).orElse(tempServiceUri);
        String serviceBasePath = "/" + service.name.value;
        for (BLangAnnotationAttachment annotation : service.annAttachments) {
            Optional<String> optionalPath = AnnotationConfigsProcessor.searchStringField("path", annotation);
            serviceBasePath = optionalPath.orElse("");
        }
        String serviceName = WSServiceTemplate.upperCaseFirstLetter(service.name.value);
        this.serviceUriStrName = this.getSafeName(WSServiceTemplate.lowerCaseFirstLetter(service.name.value) + "Uri");
        this.serviceChannelName = this.getSafeName(WSServiceTemplate.lowerCaseFirstLetter(service.name.value) + "Reply");
        this.testServiceFunctionName = this.getSafeName("test" + serviceName);
        this.callbackServiceName = this.getSafeName("callback" + serviceName + "Service");
        this.serviceUri = tempServiceUri + serviceBasePath;
        this.isSecure = isSecureTemp;
    }

    @Override
    public void render(RendererOutput rendererOutput) throws TestGeneratorException {
        String filename = this.isSecure ? "wssService.bal" : "wsService.bal";
        TemplateBasedRendererOutput serviceOutput = new TemplateBasedRendererOutput(filename);
        serviceOutput.put(PlaceHolder.OTHER.get("testServiceFunctionName"), this.testServiceFunctionName);
        serviceOutput.put(PlaceHolder.OTHER.get("serviceUriStrName"), this.serviceUriStrName);
        serviceOutput.put(PlaceHolder.OTHER.get("callbackServiceName"), this.callbackServiceName);
        serviceOutput.put(PlaceHolder.OTHER.get("endpointName"), this.getSafeName("wsClient"));
        serviceOutput.put(PlaceHolder.OTHER.get("wsReplyChannel"), this.serviceChannelName);
        rendererOutput.setFocusLineAcceptor(this.testServiceFunctionName, this.focusLineAcceptor);
        rendererOutput.append(PlaceHolder.DECLARATIONS, this.getServiceUriDeclaration() + '\n');
        rendererOutput.append(PlaceHolder.DECLARATIONS, this.getChannelDeclaration() + '\n');
        rendererOutput.append(PlaceHolder.CONTENT, CommonUtil.LINE_SEPARATOR + serviceOutput.getRenderedContent());
    }

    private String getServiceUriDeclaration() {
        return "string " + this.serviceUriStrName + " = \"" + this.serviceUri + "\";";
    }

    private String getChannelDeclaration() {
        return "channel<string> " + this.serviceChannelName + " = new;";
    }
}

