/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaPackage;
import org.ballerinalang.langserver.completions.FieldCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.util.Priority;
import org.ballerinalang.langserver.exception.LSStdlibCacheException;
import org.ballerinalang.langserver.util.definition.LSStandardLibCache;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.types.ConstrainedType;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaLexer;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class CommonUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    public static final String MD_LINE_SEPARATOR = "  " + System.lineSeparator();
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String FILE_SEPARATOR = File.separator;
    public static final String LINE_SEPARATOR_SPLIT = "\\r?\\n";
    public static final Pattern MD_NEW_LINE_PATTERN = Pattern.compile("\\s\\s\\r\\n?|\\s\\s\\n|\\r\\n?|\\n");
    public static final String BALLERINA_HOME;
    public static final String BALLERINA_CMD;
    public static final String MARKDOWN_MARKUP_KIND = "markdown";
    public static final String BALLERINA_ORG_NAME = "ballerina";
    public static final String BALLERINAX_ORG_NAME = "ballerinax";
    public static final String SDK_VERSION;
    public static final Path LS_STDLIB_CACHE_DIR;

    private CommonUtil() {
    }

    public static void calculateEndColumnOfGivenName(DiagnosticPos position, String name, String pkgAlias) {
        position.eCol = position.sCol + name.length() + (!pkgAlias.isEmpty() ? (pkgAlias + ":").length() : 0);
    }

    public static DiagnosticPos toZeroBasedPosition(DiagnosticPos diagnosticPos) {
        int startLine = diagnosticPos.getStartLine() - 1;
        int endLine = diagnosticPos.getEndLine() - 1;
        int startColumn = diagnosticPos.getStartColumn() - 1;
        int endColumn = diagnosticPos.getEndColumn() - 1;
        return new DiagnosticPos(diagnosticPos.getSource(), startLine, endLine, startColumn, endColumn);
    }

    public static DiagnosticPos clonePosition(DiagnosticPos diagnosticPos) {
        int startLine = diagnosticPos.getStartLine();
        int endLine = diagnosticPos.getEndLine();
        int startColumn = diagnosticPos.getStartColumn();
        int endColumn = diagnosticPos.getEndColumn();
        return new DiagnosticPos(diagnosticPos.getSource(), startLine, endLine, startColumn, endColumn);
    }

    public static Optional<Token> getPreviousDefaultToken(TokenStream tokenStream, int startIndex) {
        return CommonUtil.getDefaultTokenToLeftOrRight(tokenStream, startIndex, -1);
    }

    public static Optional<Token> getNextDefaultToken(TokenStream tokenStream, int startIndex) {
        return CommonUtil.getDefaultTokenToLeftOrRight(tokenStream, startIndex, 1);
    }

    public static List<Token> getNDefaultTokensToLeft(TokenStream tokenStream, int n, int startIndex) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (n > 0) {
            Optional<Token> token = CommonUtil.getDefaultTokenToLeftOrRight(tokenStream, startIndex, -1);
            if (!token.isPresent()) {
                return new ArrayList<Token>();
            }
            tokens.add(token.get());
            --n;
            startIndex = token.get().getTokenIndex();
        }
        return Lists.reverse(tokens);
    }

    private static Optional<Token> getDefaultTokenToLeftOrRight(TokenStream tokenStream, int startIndex, int direction) {
        Token token = null;
        while ((startIndex += direction) >= 0 && startIndex != tokenStream.size() && (token = tokenStream.get(startIndex)).getChannel() != 0) {
        }
        return Optional.ofNullable(token);
    }

    public static LSCompletionItem getAnnotationCompletionItem(PackageID packageID, BAnnotationSymbol annotationSymbol, LSContext ctx, CommonToken pkgAlias, Map<String, String> pkgAliasMap) {
        PackageID currentPkgID = (PackageID)ctx.get(DocumentServiceKeys.CURRENT_PACKAGE_ID_KEY);
        String currentProjectOrgName = currentPkgID == null ? "" : currentPkgID.orgName.value;
        String aliasComponent = "";
        if (pkgAliasMap.containsKey(packageID.toString())) {
            aliasComponent = pkgAliasMap.get(packageID.toString());
        } else if (currentPkgID != null && !currentPkgID.name.value.equals(packageID.name.value) && !CommonUtil.isLangLib(packageID)) {
            aliasComponent = ((Name)CommonUtil.getLastItem(packageID.getNameComps())).getValue();
        }
        boolean withAlias = pkgAlias == null && !aliasComponent.isEmpty();
        String label = CommonUtil.getAnnotationLabel(aliasComponent, annotationSymbol, withAlias);
        String insertText = CommonUtil.getAnnotationInsertText(aliasComponent, annotationSymbol, withAlias);
        CompletionItem annotationItem = new CompletionItem();
        annotationItem.setLabel(label);
        annotationItem.setInsertText(insertText);
        annotationItem.setInsertTextFormat(InsertTextFormat.Snippet);
        annotationItem.setDetail("Annotation");
        annotationItem.setKind(CompletionItemKind.Property);
        if (currentPkgID != null && currentPkgID.name.value.equals(packageID.name.value)) {
            return new SymbolCompletionItem(ctx, (BSymbol)annotationSymbol, annotationItem);
        }
        List imports = (List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY);
        Optional<BLangImportPackage> pkgImport = imports.stream().filter(bLangImportPackage -> {
            String orgName = bLangImportPackage.orgName.value;
            String importPkgName = (orgName.equals("") ? currentProjectOrgName : orgName) + "/" + CommonUtil.getPackageNameComponentsCombined(bLangImportPackage);
            String annotationPkgOrgName = packageID.orgName.getValue();
            String annotationPkgName = annotationPkgOrgName + "/" + packageID.nameComps.stream().map(Name::getValue).collect(Collectors.joining("."));
            return importPkgName.equals(annotationPkgName);
        }).findAny();
        if (!pkgImport.isPresent() && !CommonUtil.isLangLib(packageID)) {
            annotationItem.setAdditionalTextEdits(CommonUtil.getAutoImportTextEdits(packageID.orgName.getValue(), packageID.name.getValue(), ctx));
        }
        return new SymbolCompletionItem(ctx, (BSymbol)annotationSymbol, annotationItem);
    }

    public static LSCompletionItem getAnnotationCompletionItem(PackageID packageID, BAnnotationSymbol annotationSymbol, LSContext ctx, Map<String, String> pkgAliasMap) {
        return CommonUtil.getAnnotationCompletionItem(packageID, annotationSymbol, ctx, null, pkgAliasMap);
    }

    public static List<TextEdit> getAutoImportTextEdits(String orgName, String pkgName, LSContext context) {
        List currentFileImports = (List)context.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY);
        Position start = new Position(0, 0);
        if (currentFileImports != null && !currentFileImports.isEmpty()) {
            BLangImportPackage last = (BLangImportPackage)CommonUtil.getLastItem(currentFileImports);
            int endLine = last.getPosition().getEndLine();
            start = new Position(endLine, 0);
        }
        String pkgNameComponent = BALLERINA_ORG_NAME.equals(orgName) && pkgName.startsWith("lang.") ? pkgName.replace(".", ".'") : pkgName;
        String importStatement = "import " + orgName + "/" + pkgNameComponent + ";" + LINE_SEPARATOR;
        return Collections.singletonList(new TextEdit(new Range(start, start), importStatement));
    }

    private static String getAnnotationInsertText(String aliasComponent, BAnnotationSymbol annotationSymbol, boolean withAlias) {
        StringBuilder annotationStart = new StringBuilder();
        if (withAlias) {
            annotationStart.append(aliasComponent).append(":");
        }
        if (annotationSymbol.attachedType != null) {
            BType resultType;
            annotationStart.append(annotationSymbol.getName().getValue());
            BType attachedType = annotationSymbol.attachedType.type;
            BType bType = resultType = attachedType instanceof BArrayType ? ((BArrayType)attachedType).eType : attachedType;
            if (resultType instanceof BRecordType || resultType instanceof BMapType) {
                ArrayList<BField> requiredFields = new ArrayList<BField>();
                annotationStart.append(" ").append("{").append(LINE_SEPARATOR);
                if (resultType instanceof BRecordType) {
                    requiredFields.addAll(CommonUtil.getRecordRequiredFields((BRecordType)resultType));
                }
                ArrayList insertTexts = new ArrayList();
                requiredFields.forEach(field -> {
                    String fieldInsertionText = "\t" + CommonUtil.getRecordFieldCompletionInsertText(field, 1);
                    insertTexts.add(fieldInsertionText);
                });
                annotationStart.append(String.join((CharSequence)("," + LINE_SEPARATOR), insertTexts));
                if (requiredFields.isEmpty()) {
                    annotationStart.append("\t").append("${1}");
                }
                annotationStart.append(LINE_SEPARATOR).append("}");
            }
        } else {
            annotationStart.append(annotationSymbol.getName().getValue());
        }
        return annotationStart.toString();
    }

    public static String getAnnotationLabel(String aliasComponent, BAnnotationSymbol annotation, boolean withAlias) {
        String pkgComponent = withAlias ? aliasComponent + ":" : "";
        return pkgComponent + annotation.getName().getValue();
    }

    public static String getDefaultValueForType(BType bType) {
        String typeString;
        if (bType == null) {
            return "()";
        }
        switch (bType.getKind()) {
            case INT: {
                typeString = Integer.toString(0);
                break;
            }
            case FLOAT: {
                typeString = Float.toString(0.0f);
                break;
            }
            case STRING: {
                typeString = "\"\"";
                break;
            }
            case BOOLEAN: {
                typeString = Boolean.toString(false);
                break;
            }
            case ARRAY: 
            case BLOB: {
                typeString = "[]";
                break;
            }
            case RECORD: 
            case MAP: {
                typeString = "{}";
                break;
            }
            case OBJECT: {
                typeString = "new()";
                break;
            }
            case FINITE: {
                ArrayList valueSpace = new ArrayList(((BFiniteType)bType).getValueSpace());
                String value = ((BLangExpression)valueSpace.get(0)).toString();
                BType type = ((BLangExpression)valueSpace.get((int)0)).type;
                typeString = value;
                if (!type.toString().equals("string")) break;
                typeString = "\"" + typeString + "\"";
                break;
            }
            case UNION: {
                ArrayList memberTypes = new ArrayList(((BUnionType)bType).getMemberTypes());
                typeString = CommonUtil.getDefaultValueForType((BType)memberTypes.get(0));
                break;
            }
            default: {
                typeString = "()";
            }
        }
        return typeString;
    }

    public static boolean isClientObject(BSymbol bSymbol) {
        return bSymbol.type != null && bSymbol.type.tsymbol != null && SymbolKind.OBJECT.equals((Object)bSymbol.type.tsymbol.kind) && (bSymbol.type.tsymbol.flags & 0x20000) == 131072;
    }

    public static boolean isListenerObject(BSymbol bSymbol) {
        if (!(bSymbol instanceof BObjectTypeSymbol)) {
            return false;
        }
        List attachedFunctions = ((BObjectTypeSymbol)bSymbol).attachedFuncs.stream().map(function -> function.funcName.getValue()).collect(Collectors.toList());
        return attachedFunctions.contains("__start") && attachedFunctions.contains("__immediateStop") && attachedFunctions.contains("__immediateStop") && attachedFunctions.contains("__attach");
    }

    public static boolean listContainsPackage(String pkg, List<BallerinaPackage> pkgList) {
        return pkgList.stream().anyMatch(ballerinaPackage -> ballerinaPackage.getFullPackageNameAlias().equals(pkg));
    }

    public static List<LSCompletionItem> getRecordFieldCompletionItems(LSContext context, List<BField> fields) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        fields.forEach(field -> {
            String insertText = CommonUtil.getRecordFieldCompletionInsertText(field, 0);
            CompletionItem fieldItem = new CompletionItem();
            fieldItem.setInsertText(insertText);
            fieldItem.setInsertTextFormat(InsertTextFormat.Snippet);
            fieldItem.setLabel(field.getName().getValue());
            fieldItem.setDetail("Field");
            fieldItem.setKind(CompletionItemKind.Field);
            fieldItem.setSortText(Priority.PRIORITY120.toString());
            completionItems.add(new FieldCompletionItem(context, (BField)field, fieldItem));
        });
        return completionItems;
    }

    public static LSCompletionItem getFillAllStructFieldsItem(LSContext context, List<BField> fields) {
        ArrayList<String> fieldEntries = new ArrayList<String>();
        for (BField bStructField : fields) {
            String defaultFieldEntry = bStructField.getName().getValue() + ":" + " " + CommonUtil.getDefaultValueForType(bStructField.getType());
            fieldEntries.add(defaultFieldEntry);
        }
        String insertText = String.join((CharSequence)("," + LINE_SEPARATOR), fieldEntries);
        String label = "Add All Attributes";
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(label);
        completionItem.setInsertText(insertText);
        completionItem.setDetail("none");
        completionItem.setKind(CompletionItemKind.Property);
        completionItem.setSortText(Priority.PRIORITY110.toString());
        return new StaticCompletionItem(context, completionItem);
    }

    public static String getBTypeName(BType bType, LSContext ctx, boolean doSimplify) {
        if (bType instanceof ConstrainedType) {
            return CommonUtil.getConstrainedTypeName(bType, ctx, doSimplify);
        }
        if (bType instanceof BUnionType) {
            return CommonUtil.getUnionTypeName((BUnionType)bType, ctx, doSimplify);
        }
        if (bType instanceof BTupleType) {
            return CommonUtil.getTupleTypeName((BTupleType)bType, ctx, doSimplify);
        }
        if (bType instanceof BFiniteType || bType instanceof BInvokableType || bType instanceof BNilType) {
            return bType.toString();
        }
        if (bType instanceof BArrayType) {
            return CommonUtil.getArrayTypeName((BArrayType)bType, ctx, doSimplify);
        }
        if (bType instanceof BRecordType) {
            return CommonUtil.getRecordTypeName((BRecordType)bType, ctx, doSimplify);
        }
        return CommonUtil.getShallowBTypeName(bType, ctx);
    }

    public static String getSymbolName(BSymbol bSymbol) {
        String nameValue = bSymbol.name.getValue();
        String[] split = nameValue.split("\\.");
        return split[split.length - 1];
    }

    private static String getShallowBTypeName(BType bType, LSContext ctx) {
        if (bType.tsymbol == null) {
            return bType.toString();
        }
        if (bType instanceof BArrayType) {
            return CommonUtil.getShallowBTypeName(((BArrayType)bType).eType, ctx) + "[]";
        }
        if (bType.tsymbol.pkgID == null) {
            return bType.tsymbol.name.getValue();
        }
        PackageID pkgId = bType.tsymbol.pkgID;
        String[] nameComponents = bType.tsymbol.name.value.split("\\$")[0].split(":");
        if (ctx != null) {
            PackageID currentPkgId = ((BLangPackage)ctx.get((LSContext.Key)DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY)).packageID;
            if (pkgId.toString().equals(currentPkgId.toString()) || pkgId.getName().getValue().startsWith("lang.")) {
                return nameComponents[nameComponents.length - 1];
            }
        }
        if (pkgId.getName().getValue().startsWith("lang.")) {
            return nameComponents[nameComponents.length - 1];
        }
        return pkgId.getName().getValue().replaceAll(".*\\.", "") + ":" + nameComponents[nameComponents.length - 1];
    }

    private static String getUnionTypeName(BUnionType unionType, LSContext ctx, boolean doSimplify) {
        ArrayList nonErrorTypes = new ArrayList();
        ArrayList errorTypes = new ArrayList();
        StringBuilder unionName = new StringBuilder("(");
        unionType.getMemberTypes().forEach(bType -> {
            if (bType instanceof BErrorType) {
                errorTypes.add(bType);
            } else {
                nonErrorTypes.add(bType);
            }
        });
        String nonErrorsName = nonErrorTypes.stream().map(bType -> CommonUtil.getBTypeName(bType, ctx, doSimplify)).collect(Collectors.joining("|"));
        unionName.append(nonErrorsName);
        if (errorTypes.size() > 3 && doSimplify) {
            if (nonErrorTypes.isEmpty()) {
                unionName.append("error");
            } else {
                unionName.append("|error");
            }
        } else if (!errorTypes.isEmpty()) {
            String errorsName = errorTypes.stream().map(bType -> CommonUtil.getBTypeName(bType, ctx, doSimplify)).collect(Collectors.joining("|"));
            if (nonErrorTypes.isEmpty()) {
                unionName.append(errorsName);
            } else {
                unionName.append("|").append(errorsName);
            }
        }
        unionName.append(")");
        return unionName.toString();
    }

    private static String getTupleTypeName(BTupleType tupleType, LSContext ctx, boolean doSimplify) {
        return "[" + tupleType.getTupleTypes().stream().map(bType -> CommonUtil.getBTypeName(bType, ctx, doSimplify)).collect(Collectors.joining(",")) + "]";
    }

    private static String getRecordTypeName(BRecordType recordType, LSContext ctx, boolean doSimplify) {
        if (recordType.tsymbol.kind == SymbolKind.RECORD && recordType.tsymbol.name.value.contains("$anonType")) {
            StringBuilder recordTypeName = new StringBuilder("record {");
            recordTypeName.append(LINE_SEPARATOR);
            String fieldsList = recordType.fields.stream().map(field -> CommonUtil.getBTypeName(field.type, ctx, doSimplify) + " " + field.name.getValue() + ";").collect(Collectors.joining(LINE_SEPARATOR));
            recordTypeName.append(fieldsList).append(LINE_SEPARATOR).append("}");
            return recordTypeName.toString();
        }
        return CommonUtil.getShallowBTypeName((BType)recordType, ctx);
    }

    private static String getArrayTypeName(BArrayType arrayType, LSContext ctx, boolean doSimplify) {
        return CommonUtil.getBTypeName(arrayType.eType, ctx, doSimplify) + "[]";
    }

    private static boolean isLangLib(PackageID packageID) {
        return packageID.getOrgName().getValue().equals(BALLERINA_ORG_NAME) && packageID.getName().getValue().startsWith("lang.");
    }

    private static String getConstrainedTypeName(BType bType, LSContext context, boolean doSimplify) {
        if (!(bType instanceof ConstrainedType)) {
            return "";
        }
        BType constraint = CommonUtil.getConstraintType(bType);
        StringBuilder constraintName = new StringBuilder(CommonUtil.getShallowBTypeName(bType, context));
        constraintName.append("<");
        if (constraint.tsymbol != null && constraint.tsymbol.kind == SymbolKind.RECORD && constraint.tsymbol.name.value.contains("$anonType")) {
            constraintName.append("record {}");
        } else {
            constraintName.append(CommonUtil.getBTypeName(constraint, context, doSimplify));
        }
        constraintName.append(">");
        return constraintName.toString();
    }

    private static BType getConstraintType(BType bType) {
        if (bType instanceof BFutureType) {
            return ((BFutureType)bType).constraint;
        }
        if (bType instanceof BMapType) {
            return ((BMapType)bType).constraint;
        }
        if (bType instanceof BStreamType) {
            return ((BStreamType)bType).constraint;
        }
        if (bType instanceof BTypedescType) {
            return ((BTypedescType)bType).constraint;
        }
        return ((BTableType)bType).constraint;
    }

    public static <T> T getLastItem(List<T> list) {
        return list.size() == 0 ? null : (T)list.get(list.size() - 1);
    }

    public static <T> T getLastItem(T[] list) {
        return list.length == 0 ? null : (T)list[list.length - 1];
    }

    public static boolean isTestSource(String relativeFilePath) {
        return relativeFilePath.startsWith("tests" + FILE_SEPARATOR);
    }

    public static BLangPackage getSourceOwnerBLangPackage(String relativePath, BLangPackage parentPkg) {
        return CommonUtil.isTestSource(relativePath) ? parentPkg.getTestablePkg() : parentPkg;
    }

    public static boolean isValidInvokableSymbol(BSymbol symbol) {
        if (!(symbol instanceof BInvokableSymbol)) {
            return false;
        }
        BInvokableSymbol bInvokableSymbol = (BInvokableSymbol)symbol;
        return (bInvokableSymbol.kind == null && (SymbolKind.RECORD.equals((Object)bInvokableSymbol.owner.kind) || SymbolKind.FUNCTION.equals((Object)bInvokableSymbol.owner.kind)) || SymbolKind.FUNCTION.equals((Object)bInvokableSymbol.kind)) && !bInvokableSymbol.name.value.endsWith("..<init>") && !bInvokableSymbol.name.value.endsWith(".<start>") && !bInvokableSymbol.name.value.endsWith(".<stop>");
    }

    public static List<BLangImportPackage> getCurrentFileImports(LSContext ctx) {
        return CommonUtil.getCurrentModuleImports(ctx).stream().filter(CommonUtil.importInCurrentFilePredicate(ctx)).collect(Collectors.toList());
    }

    public static boolean isInvalidSymbol(BSymbol symbol) {
        return "_".equals(symbol.name.getValue()) || symbol instanceof BAnnotationSymbol || symbol instanceof BOperatorSymbol || CommonUtil.symbolContainsInvalidChars(symbol);
    }

    public static boolean isWorkerDereivative(StatementNode node) {
        return node instanceof BLangSimpleVariableDef && ((BLangSimpleVariableDef)node).var.expr != null && ((BLangSimpleVariableDef)node).var.expr.type instanceof BFutureType && ((BFutureType)((BLangSimpleVariableDef)node).var.expr.type).workerDerivative;
    }

    public static List<TopLevelNode> getCurrentFileTopLevelNodes(BLangPackage pkgNode, LSContext ctx) {
        String relativeFilePath = (String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangCompilationUnit filteredCUnit = pkgNode.compUnits.stream().filter(cUnit -> cUnit.getPosition().getSource().cUnitName.replace("/", FILE_SEPARATOR).equals(relativeFilePath)).findAny().orElse(null);
        ArrayList topLevelNodes = filteredCUnit == null ? new ArrayList() : new ArrayList(filteredCUnit.getTopLevelNodes());
        return topLevelNodes.stream().filter(topLevelNode -> !(topLevelNode instanceof BLangFunction && ((BLangFunction)topLevelNode).flagSet.contains(Flag.LAMBDA) || topLevelNode instanceof BLangSimpleVariable && ((BLangSimpleVariable)topLevelNode).flagSet.contains(Flag.SERVICE) || topLevelNode instanceof BLangImportPackage && topLevelNode.getWS() == null)).collect(Collectors.toList());
    }

    public static String getPackageNameComponentsCombined(BLangImportPackage importPackage) {
        return importPackage.pkgNameComps.stream().map(id -> id.value).collect(Collectors.joining("."));
    }

    public static String getPlainTextSnippet(String snippet) {
        return snippet.replaceAll("\\$\\{\\d+:([^\\{^\\}]*)\\}", "$1").replaceAll("(\\$\\{\\d+\\})", "");
    }

    public static BallerinaParser prepareParser(String content) {
        CommonTokenStream commonTokenStream = CommonUtil.getTokenStream(content);
        BallerinaParser parser = new BallerinaParser((TokenStream)commonTokenStream);
        parser.removeErrorListeners();
        return parser;
    }

    static CommonTokenStream getTokenStream(String content) {
        ANTLRInputStream inputStream = new ANTLRInputStream(content);
        BallerinaLexer lexer = new BallerinaLexer((CharStream)inputStream);
        lexer.removeErrorListeners();
        return new CommonTokenStream((TokenSource)lexer);
    }

    public static List<Token> getTokenList(String content) {
        CommonTokenStream tokenStream = CommonUtil.getTokenStream(content);
        tokenStream.fill();
        return new ArrayList<Token>(tokenStream.getTokens());
    }

    public static boolean symbolContainsInvalidChars(BSymbol bSymbol) {
        List<String> symbolNameComponents = Arrays.asList(bSymbol.getName().getValue().split("\\."));
        String symbolName = CommonUtil.getLastItem(symbolNameComponents);
        return symbolName != null && (symbolName.contains("<") || symbolName.contains(">") || symbolName.contains("$") || symbolName.equals("main") || symbolName.endsWith(".new") || symbolName.startsWith("0"));
    }

    public static String getFunctionNameFromSymbol(BInvokableSymbol bInvokableSymbol) {
        String[] funcNameComponents = bInvokableSymbol.getName().getValue().split("\\.");
        String functionName = funcNameComponents[funcNameComponents.length - 1];
        if (bInvokableSymbol.receiverSymbol != null) {
            String receiverType = bInvokableSymbol.receiverSymbol.getType().toString();
            functionName = functionName.replace(receiverType + ".", "");
        }
        return functionName;
    }

    public static Pair<String, String> getFunctionInvocationSignature(BInvokableSymbol symbol, String functionName, LSContext ctx) {
        if (symbol == null) {
            return ImmutablePair.of((Object)(functionName + "();"), (Object)(functionName + "()"));
        }
        StringBuilder signature = new StringBuilder(functionName + "(");
        StringBuilder insertText = new StringBuilder(functionName + "(");
        List<String> funcArguments = FunctionGenerator.getFuncArguments(symbol, ctx);
        if (!funcArguments.isEmpty()) {
            signature.append(String.join((CharSequence)", ", funcArguments));
            insertText.append("${1}");
        }
        signature.append(")");
        insertText.append(")");
        if (symbol.type.getReturnType() == null || symbol.type.getReturnType() instanceof BNilType) {
            insertText.append(";");
        }
        String initString = "(";
        String endString = ")";
        BType returnType = symbol.type.getReturnType();
        if (returnType != null && !(returnType instanceof BNilType)) {
            signature.append(initString).append(CommonUtil.getBTypeName(returnType, ctx, false));
            signature.append(endString);
        }
        return new ImmutablePair((Object)insertText.toString(), (Object)signature.toString());
    }

    public static List<Scope.ScopeEntry> getWorkerSymbols(LSContext context) {
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        return visibleSymbols.stream().filter(scopeEntry -> {
            BType bType = scopeEntry.symbol.type;
            return bType instanceof BFutureType && ((BFutureType)bType).workerDerivative;
        }).collect(Collectors.toList());
    }

    private static List<BField> getRecordRequiredFields(BRecordType recordType) {
        return recordType.fields.stream().filter(field -> (field.symbol.flags & 0x100) == 256).collect(Collectors.toList());
    }

    private static String getRecordFieldCompletionInsertText(BField bField, int tabOffset) {
        BType fieldType = bField.getType();
        StringBuilder insertText = new StringBuilder(bField.getName().getValue() + ": ");
        if (fieldType instanceof BRecordType) {
            List<BField> requiredFields = CommonUtil.getRecordRequiredFields((BRecordType)fieldType);
            if (requiredFields.isEmpty()) {
                insertText.append("{").append("${1}}");
                return insertText.toString();
            }
            insertText.append("{").append(LINE_SEPARATOR);
            int tabCount = tabOffset;
            ArrayList<String> requiredFieldInsertTexts = new ArrayList<String>();
            for (BField requiredField : requiredFields) {
                String fieldText = String.join((CharSequence)"", Collections.nCopies(tabCount + 1, "\t")) + CommonUtil.getRecordFieldCompletionInsertText(requiredField, tabCount) + String.join((CharSequence)"", Collections.nCopies(tabCount, "\t"));
                requiredFieldInsertTexts.add(fieldText);
                ++tabCount;
            }
            insertText.append(String.join((CharSequence)LINE_SEPARATOR, requiredFieldInsertTexts));
            insertText.append(LINE_SEPARATOR).append(String.join((CharSequence)"", Collections.nCopies(tabOffset, "\t"))).append("}");
        } else if (fieldType instanceof BArrayType) {
            insertText.append("[").append("${1}").append("]");
        } else if (fieldType.tsymbol != null && fieldType.tsymbol.name.getValue().equals("string")) {
            insertText.append("\"").append("${1}").append("\"");
        } else {
            insertText.append("${1:").append(CommonUtil.getDefaultValueForType(bField.getType())).append("}");
        }
        return insertText.toString();
    }

    public static List<BLangImportPackage> getCurrentModuleImports(LSContext ctx) {
        String relativePath = (String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        BLangPackage currentPkg = (BLangPackage)ctx.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        BLangPackage ownerPkg = CommonUtil.getSourceOwnerBLangPackage(relativePath, currentPkg);
        return ownerPkg.imports;
    }

    public static Predicate<Scope.ScopeEntry> invalidSymbolsPredicate() {
        return scopeEntry -> scopeEntry != null && CommonUtil.isInvalidSymbol(scopeEntry.symbol);
    }

    public static Predicate<BLangImportPackage> importInCurrentFilePredicate(LSContext ctx) {
        String currentFile = (String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        return importPkg -> importPkg.pos.getSource().cUnitName.replace("/", FILE_SEPARATOR).equals(currentFile) && importPkg.getWS() != null;
    }

    public static Predicate<BLangImportPackage> stdLibImportsNotCachedPredicate(LSContext ctx) {
        String currentFile = (String)ctx.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
        return importPkg -> importPkg.pos.getSource().cUnitName.replace("/", FILE_SEPARATOR).equals(currentFile) && importPkg.getWS() != null && (importPkg.orgName.value.equals(BALLERINA_ORG_NAME) || importPkg.orgName.value.equals(BALLERINAX_ORG_NAME));
    }

    public static Predicate<TopLevelNode> checkInvalidTypesDefs() {
        return topLevelNode -> {
            if (topLevelNode instanceof BLangTypeDefinition) {
                BLangTypeDefinition typeDefinition = (BLangTypeDefinition)topLevelNode;
                return !typeDefinition.flagSet.contains(Flag.SERVICE) && !typeDefinition.flagSet.contains(Flag.RESOURCE);
            }
            return true;
        };
    }

    public static String generateName(int value, Set<String> argNames) {
        StringBuilder result = new StringBuilder();
        int index = value;
        while (--index >= 0) {
            result.insert(0, (char)(97 + index % 26));
            index /= 26;
        }
        while (argNames.contains(result.toString())) {
            result = new StringBuilder(CommonUtil.generateName(++value, argNames));
        }
        return result.toString();
    }

    public static String generateVariableName(BLangNode bLangNode, Set<String> names) {
        String newName = CommonUtil.generateName(1, names);
        if (bLangNode instanceof BLangInvocation) {
            return CommonUtil.generateVariableName(1, ((BLangInvocation)bLangNode).name.value, names);
        }
        return newName;
    }

    public static String generateVariableName(BType bType, Set<String> names) {
        String value = bType.name.getValue();
        if (value.isEmpty() && bType.tsymbol != null) {
            value = bType.tsymbol.name.value;
        }
        return CommonUtil.generateVariableName(1, value, names);
    }

    private static String generateVariableName(int value, String name, Set<String> names) {
        String newName = CommonUtil.generateName(value, names);
        if (value == 1 && !name.isEmpty()) {
            newName = name;
            BiFunction<String, String, String> replacer = (search, text) -> text.startsWith((String)search) ? text.replaceFirst((String)search, "") : text;
            newName = replacer.apply("get", newName);
            newName = replacer.apply("put", newName);
            newName = replacer.apply("delete", newName);
            newName = replacer.apply("update", newName);
            newName = replacer.apply("set", newName);
            newName = replacer.apply("add", newName);
            newName = replacer.apply("create", newName);
            while (newName.contains("_")) {
                String[] parts = newName.split("_");
                List restParts = Arrays.stream(parts, 1, parts.length).collect(Collectors.toList());
                newName = parts[0] + StringUtils.capitalize((String)String.join((CharSequence)"", restParts));
            }
            if (newName.isEmpty()) {
                newName = name;
            }
            newName = newName.substring(0, 1).toLowerCase(Locale.getDefault()) + newName.substring(1);
            Iterator<String> iterator = names.iterator();
            boolean alreadyExists = false;
            boolean appendResult = true;
            boolean appendOut = true;
            String suffixResult = "Result";
            String suffixOut = "Out";
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (next.equals(newName)) {
                    alreadyExists = true;
                    continue;
                }
                if (next.equals(newName + suffixResult)) {
                    appendResult = false;
                    continue;
                }
                if (!next.equals(newName + suffixOut)) continue;
                appendOut = false;
            }
            if (alreadyExists && appendResult) {
                newName = newName + suffixResult;
            } else if (alreadyExists && appendOut) {
                newName = newName + suffixOut;
            }
            while (names.contains(newName)) {
                newName = CommonUtil.generateVariableName(++value, name, names);
            }
        }
        return newName;
    }

    public static BLangPackage getPackageNode(BLangNode bLangNode) {
        BLangNode parent = bLangNode.parent;
        if (parent != null) {
            return parent instanceof BLangPackage ? (BLangPackage)parent : CommonUtil.getPackageNode(parent);
        }
        return null;
    }

    public static String getPackagePrefix(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, PackageID typePkgId) {
        String pkgPrefix = "";
        if (!(typePkgId.equals((Object)currentPkgId) || typePkgId.orgName.value.equals(BALLERINA_ORG_NAME) && typePkgId.name.value.startsWith("lang."))) {
            pkgPrefix = typePkgId.name.value.replaceAll(".*\\.", "") + ":";
            if (importsAcceptor != null) {
                importsAcceptor.accept(typePkgId.orgName.value, typePkgId.name.value);
            }
        }
        return pkgPrefix;
    }

    public static boolean skipFirstParam(BInvokableSymbol invokableSymbol, int invocationType) {
        return CommonUtil.isLangLibSymbol((BSymbol)invokableSymbol) && invocationType != 96;
    }

    public static Set<String> getAllNameEntries(CompilerContext context) {
        HashSet<String> strings = new HashSet<String>();
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)context);
        Map pkgEnvMap = symbolTable.pkgEnvMap;
        pkgEnvMap.values().forEach(env -> env.scope.entries.keySet().forEach(key -> strings.add(key.value)));
        return strings;
    }

    public static boolean isLangLibSymbol(BSymbol symbol) {
        return (symbol.flags & 0x800000) == 0x800000;
    }

    public static Optional<Path> getPathFromURI(String uri) {
        try {
            return Optional.of(Paths.get(new URL(uri).toURI()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return Optional.empty();
        }
    }

    public static void updateStdLibCache(LSContext context) throws LSStdlibCacheException {
        Boolean enabled = (Boolean)context.get(DocumentServiceKeys.ENABLE_STDLIB_DEFINITION_KEY);
        if (enabled == null || !enabled.booleanValue()) {
            return;
        }
        List<BLangImportPackage> stdLibImports = CommonUtil.getCurrentModuleImports(context).stream().filter(CommonUtil.stdLibImportsNotCachedPredicate(context)).collect(Collectors.toList());
        LSStandardLibCache.getInstance().updateCache(stdLibImports);
    }

    public static boolean isCachedExternalSource(String fileUri) {
        try {
            Path path = Paths.get(new URI(fileUri));
            return path.toAbsolutePath().toString().startsWith(LS_STDLIB_CACHE_DIR.toAbsolutePath().toString());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    static {
        SDK_VERSION = System.getProperty("ballerina.version");
        LS_STDLIB_CACHE_DIR = TEMP_DIR.resolve("ls_stdlib_cache").resolve(SDK_VERSION);
        BALLERINA_HOME = System.getProperty("ballerina.home");
        BALLERINA_CMD = BALLERINA_HOME + File.separator + "bin" + File.separator + BALLERINA_ORG_NAME + (SystemUtils.IS_OS_WINDOWS ? ".bat" : "");
    }

    public static class BLangNodeComparator
    implements Comparator<BLangNode> {
        @Override
        public int compare(BLangNode node1, BLangNode node2) {
            return node1.getPosition().getStartLine() - node2.getPosition().getStartLine();
        }
    }
}

