/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class FilterUtils {
    public static List<Scope.ScopeEntry> filterVariableEntriesOnDelimiter(LSContext context, String varName, int delimiter, List<CommonToken> defaultTokens, int delimIndex) {
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        visibleSymbols.removeIf(CommonUtil.invalidSymbolsPredicate());
        if (129 == delimiter) {
            Scope.ScopeEntry variable = FilterUtils.getVariableByName(varName, visibleSymbols);
            if (variable != null && CommonUtil.isClientObject(variable.symbol)) {
                return FilterUtils.getClientActions((BObjectTypeSymbol)variable.symbol.type.tsymbol);
            }
            visibleSymbols.removeIf(scopeEntry -> scopeEntry.symbol instanceof BTypeSymbol);
            return visibleSymbols;
        }
        if (130 == delimiter) {
            visibleSymbols.removeIf(scopeEntry -> scopeEntry.symbol instanceof BTypeSymbol);
            return visibleSymbols;
        }
        if (97 == delimiter || 106 == delimiter || 115 == delimiter) {
            return FilterUtils.getInvocationsAndFields(context, defaultTokens, delimIndex);
        }
        if (96 == delimiter) {
            String moduleName = varName;
            for (BLangImportPackage importModule : (List)context.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY)) {
                if (!importModule.alias.getValue().equals(varName)) continue;
                moduleName = CommonUtil.getSymbolName((BSymbol)importModule.symbol);
                break;
            }
            String finalModuleName = moduleName;
            Optional<Scope.ScopeEntry> pkgSymbol = visibleSymbols.stream().filter(item -> CommonUtil.getSymbolName(item.symbol).equals(finalModuleName) && item.symbol instanceof BPackageSymbol).findFirst();
            if (!pkgSymbol.isPresent()) {
                return new ArrayList<Scope.ScopeEntry>();
            }
            Map scopeEntryMap = pkgSymbol.get().symbol.scope.entries;
            return FilterUtils.loadActionsFunctionsAndTypesFromScope(scopeEntryMap);
        }
        return new ArrayList<Scope.ScopeEntry>();
    }

    public static List<Scope.ScopeEntry> getClientActions(BObjectTypeSymbol objectTypeSymbol) {
        return objectTypeSymbol.methodScope.entries.values().stream().filter(scopeEntry -> (scopeEntry.symbol.flags & 0x10000) == 65536).collect(Collectors.toList());
    }

    private static List<Scope.ScopeEntry> getInvocationsAndFields(LSContext ctx, List<CommonToken> defaultTokens, int delimIndex) {
        ArrayList<Scope.ScopeEntry> resultList = new ArrayList<Scope.ScopeEntry>();
        List<ChainedFieldModel> invocationFieldList = FilterUtils.getInvocationFieldList(defaultTokens, delimIndex, false);
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)((CompilerContext)ctx.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY)));
        ChainedFieldModel startField = invocationFieldList.get(0);
        ArrayList<Scope.ScopeEntry> symbolList = new ArrayList<Scope.ScopeEntry>((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        BSymbol bSymbol = FilterUtils.getVariableByName((String)startField.name.getText(), symbolList).symbol;
        if (bSymbol instanceof BPackageSymbol) {
            return resultList;
        }
        BType modifiedBType = FilterUtils.getModifiedBType(bSymbol, ctx, startField.fieldType);
        Map<Name, Scope.ScopeEntry> scopeEntries = FilterUtils.getInvocationsAndFieldsForSymbol(startField.name.getText(), modifiedBType, ctx);
        for (int itr = 1; itr < invocationFieldList.size(); ++itr) {
            Optional<Scope.ScopeEntry> entry;
            ChainedFieldModel fieldModel = invocationFieldList.get(itr);
            if (modifiedBType instanceof BJSONType) {
                modifiedBType = BUnionType.create(null, (BType[])new BType[]{modifiedBType, symbolTable.errorType});
                scopeEntries = FilterUtils.getInvocationsAndFieldsForSymbol(fieldModel.name.getText(), modifiedBType, ctx);
                continue;
            }
            if (scopeEntries == null || !(entry = FilterUtils.getScopeEntryWithName(scopeEntries, fieldModel)).isPresent()) break;
            bSymbol = entry.get().symbol;
            modifiedBType = FilterUtils.getModifiedBType(bSymbol, ctx, fieldModel.fieldType);
            scopeEntries = FilterUtils.getInvocationsAndFieldsForSymbol(fieldModel.name.getText(), modifiedBType, ctx);
        }
        if (scopeEntries == null) {
            return new ArrayList<Scope.ScopeEntry>();
        }
        scopeEntries.forEach((entryName, fieldEntry) -> resultList.add((Scope.ScopeEntry)fieldEntry));
        return resultList;
    }

    public static Scope.ScopeEntry getVariableByName(String name, List<Scope.ScopeEntry> symbols) {
        return symbols.stream().filter(scopeEntry -> scopeEntry.symbol.name.getValue().equals(name)).findFirst().orElse(null);
    }

    public static Optional<BSymbol> getBTypeEntry(Scope.ScopeEntry entry) {
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xC) == 12 && !CommonUtil.symbolContainsInvalidChars(entry.symbol) && entry.symbol instanceof BTypeSymbol) {
                return Optional.of(entry.symbol);
            }
            entry = entry.next;
        }
        return Optional.empty();
    }

    public static boolean isBTypeEntry(Scope.ScopeEntry entry) {
        return FilterUtils.getBTypeEntry(entry).isPresent();
    }

    private static BType getBTypeForUnionType(BUnionType bType) {
        ArrayList<BType> memberTypeList = new ArrayList<BType>(bType.getMemberTypes());
        memberTypeList.removeIf(type -> type.tsymbol instanceof BErrorTypeSymbol || type instanceof BNilType);
        if (memberTypeList.size() == 1) {
            return (BType)memberTypeList.get(0);
        }
        return bType;
    }

    private static List<Scope.ScopeEntry> loadActionsFunctionsAndTypesFromScope(Map<Name, Scope.ScopeEntry> entryMap) {
        ArrayList<Scope.ScopeEntry> actionFunctionList = new ArrayList<Scope.ScopeEntry>();
        entryMap.forEach((name, scopeEntry) -> {
            BSymbol symbol = scopeEntry.symbol;
            if ((symbol instanceof BInvokableSymbol && ((BInvokableSymbol)symbol).receiverSymbol == null || FilterUtils.isBTypeEntry(scopeEntry) || symbol instanceof BVarSymbol) && (symbol.flags & 1) == 1) {
                actionFunctionList.add((Scope.ScopeEntry)scopeEntry);
            }
        });
        return actionFunctionList;
    }

    private static BType getModifiedBType(BSymbol bSymbol, LSContext context, InvocationFieldType fieldType) {
        BTypedescType actualType;
        Integer invocationType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if ((bSymbol.tag & 0xC) == 12) {
            actualType = new BTypedescType(bSymbol.type, null);
        } else if (bSymbol instanceof BInvokableSymbol) {
            actualType = ((BInvokableSymbol)bSymbol).retType;
        } else {
            if (bSymbol.type instanceof BArrayType && fieldType == InvocationFieldType.ARRAY_ACCESS) {
                return ((BArrayType)bSymbol.type).eType;
            }
            if (bSymbol.type instanceof BMapType && fieldType == InvocationFieldType.ARRAY_ACCESS) {
                LinkedHashSet<Object> types = new LinkedHashSet<Object>();
                types.add(((BMapType)bSymbol.type).constraint);
                types.add(new BNilType());
                actualType = BUnionType.create((BTypeSymbol)((BMapType)bSymbol.type).constraint.tsymbol, types);
            } else {
                actualType = bSymbol.type;
            }
        }
        return actualType instanceof BUnionType && invocationType == 115 ? FilterUtils.getBTypeForUnionType((BUnionType)actualType) : actualType;
    }

    private static List<ChainedFieldModel> getInvocationFieldList(List<CommonToken> defaultTokens, int startIndex, boolean captureValidField) {
        int traverser = startIndex;
        int rightBracketCount = 0;
        int gtCount = 0;
        boolean invocation = false;
        boolean arrayAccess = false;
        ArrayList<ChainedFieldModel> fieldList = new ArrayList<ChainedFieldModel>();
        Pattern pattern = Pattern.compile("^\\w+$");
        boolean captureNextValidField = captureValidField;
        while (traverser >= 0) {
            InvocationFieldType fieldType;
            CommonToken token = defaultTokens.get(traverser);
            int type = token.getType();
            Matcher matcher = pattern.matcher(token.getText());
            boolean foundMatch = matcher.find();
            if (type == 102) {
                Pair<Boolean, Integer> isGroupedExpr = FilterUtils.isGroupedExpression(defaultTokens, traverser - 1);
                if (((Boolean)isGroupedExpr.getLeft()).booleanValue()) {
                    List<CommonToken> subList = defaultTokens.subList((Integer)isGroupedExpr.getRight() + 1, traverser);
                    List<ChainedFieldModel> groupedFields = FilterUtils.getInvocationFieldList(subList, subList.size() - 1, captureNextValidField);
                    fieldList.addAll(Lists.reverse(groupedFields));
                } else {
                    invocation = true;
                }
                traverser = (Integer)isGroupedExpr.getRight() - 1;
                continue;
            }
            if (type == 104) {
                if (!arrayAccess) {
                    arrayAccess = true;
                }
                ++rightBracketCount;
                --traverser;
                continue;
            }
            if (type == 101 || type == 113 || type == 112 || foundMatch && gtCount > 0) {
                --traverser;
                continue;
            }
            if (type == 103 && rightBracketCount > 0) {
                --rightBracketCount;
                --traverser;
                continue;
            }
            if (type == 118) {
                ++gtCount;
                --traverser;
                continue;
            }
            if (type == 119) {
                --gtCount;
                --traverser;
                continue;
            }
            if (type == 97 || type == 115 || type == 106 || rightBracketCount > 0) {
                captureNextValidField = true;
                --traverser;
                continue;
            }
            if (!foundMatch || rightBracketCount != 0 || !captureNextValidField) break;
            CommonToken packageAlias = null;
            --traverser;
            if (invocation) {
                fieldType = InvocationFieldType.INVOCATION;
                invocation = false;
            } else if (arrayAccess) {
                fieldType = InvocationFieldType.ARRAY_ACCESS;
                arrayAccess = false;
            } else {
                fieldType = InvocationFieldType.FIELD;
            }
            if (traverser > 0 && defaultTokens.get(traverser).getType() == 96) {
                packageAlias = defaultTokens.get(traverser - 1);
            }
            ChainedFieldModel model = new ChainedFieldModel(fieldType, token, packageAlias);
            fieldList.add(model);
            captureNextValidField = false;
        }
        return Lists.reverse(fieldList);
    }

    private static Pair<Boolean, Integer> isGroupedExpression(List<CommonToken> defaultTokens, int startIndex) {
        int traverser = startIndex;
        int rightParenCount = 0;
        Pattern pattern = Pattern.compile("^\\w+$");
        while (true) {
            int type;
            if ((type = defaultTokens.get(traverser).getType()) == 102) {
                ++rightParenCount;
            } else if (type == 101) {
                if (rightParenCount == 0) {
                    if (traverser <= 0) {
                        return Pair.of((Object)true, (Object)traverser);
                    }
                    CommonToken tokenBefore = defaultTokens.get(traverser - 1);
                    Matcher matcher = pattern.matcher(tokenBefore.getText());
                    return Pair.of((Object)(!matcher.find() ? 1 : 0), (Object)traverser);
                }
                --rightParenCount;
            }
            --traverser;
        }
    }

    private static Map<Name, Scope.ScopeEntry> getInvocationsAndFieldsForSymbol(String symbolName, BType symbolType, LSContext context) {
        Integer invocationToken = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        Types types = Types.getInstance((CompilerContext)compilerContext);
        HashMap<Name, Scope.ScopeEntry> entries = new HashMap<Name, Scope.ScopeEntry>();
        if (symbolType.tsymbol instanceof BObjectTypeSymbol) {
            BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)symbolType.tsymbol;
            entries.putAll(FilterUtils.getObjectMethodsAndFields(context, objectTypeSymbol, symbolName));
            entries.putAll(FilterUtils.getLangLibScopeEntries(symbolType, symbolTable, types));
            return entries.entrySet().stream().filter(entry -> !(((Scope.ScopeEntry)entry.getValue()).symbol instanceof BInvokableSymbol) || (((Scope.ScopeEntry)entry.getValue()).symbol.flags & 0x10000) != 65536).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (symbolType instanceof BUnionType) {
            entries.putAll(FilterUtils.getInvocationsAndFieldsForUnionType((BUnionType)symbolType, context));
        } else if (symbolType.tsymbol != null && symbolType.tsymbol.scope != null) {
            entries.putAll(FilterUtils.getLangLibScopeEntries(symbolType, symbolTable, types));
            Map<Name, Scope.ScopeEntry> filteredEntries = symbolType.tsymbol.scope.entries.entrySet().stream().filter(FilterUtils.optionalFieldFilter(symbolType, invocationToken, context)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            entries.putAll(filteredEntries);
        } else {
            entries.putAll(FilterUtils.getLangLibScopeEntries(symbolType, symbolTable, types));
        }
        return entries.entrySet().stream().filter(entry -> !(((Scope.ScopeEntry)entry.getValue()).symbol instanceof BTypeSymbol) && (!(((Scope.ScopeEntry)entry.getValue()).symbol instanceof BInvokableSymbol) || (((Scope.ScopeEntry)entry.getValue()).symbol.flags & 0x10000) != 65536)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<Name, Scope.ScopeEntry> getObjectMethodsAndFields(LSContext context, BObjectTypeSymbol objectSymbol, String symbolName) {
        String currentModule = (String)context.get(DocumentServiceKeys.CURRENT_PKG_NAME_KEY);
        String objectOwnerModule = objectSymbol.pkgID.getName().getValue();
        boolean symbolInCurrentModule = currentModule.equals(objectOwnerModule);
        Map<Name, Scope.ScopeEntry> entries = objectSymbol.methodScope.entries.entrySet().stream().filter(entry -> {
            BSymbol entrySymbol = ((Scope.ScopeEntry)entry.getValue()).symbol;
            boolean isPrivate = (entrySymbol.flags & 0x400) == 1024;
            boolean isPublic = (entrySymbol.flags & 1) == 1;
            return !(entrySymbol.getName().getValue().contains(".__init") && !"self".equals(symbolName) || isPrivate && !"self".equals(symbolName) || !isPrivate && !isPublic && !symbolInCurrentModule);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Name, Scope.ScopeEntry> fieldEntries = objectSymbol.scope.entries.entrySet().stream().filter(entry -> {
            BSymbol entrySymbol = ((Scope.ScopeEntry)entry.getValue()).symbol;
            boolean isPrivate = (entrySymbol.flags & 0x400) == 1024;
            boolean isPublic = (entrySymbol.flags & 1) == 1;
            return !(isPrivate && !"self".equals(symbolName) || !isPrivate && !isPublic && !symbolInCurrentModule);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        entries.putAll(fieldEntries);
        return entries;
    }

    private static Map<Name, Scope.ScopeEntry> getInvocationsAndFieldsForUnionType(BUnionType unionType, LSContext context) {
        ArrayList memberTypes = new ArrayList(unionType.getMemberTypes());
        HashMap<Name, Scope.ScopeEntry> resultEntries = new HashMap<Name, Scope.ScopeEntry>();
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        Types types = Types.getInstance((CompilerContext)compilerContext);
        Integer invocationTokenType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        BType firstMemberType = (BType)memberTypes.get(0);
        boolean allMatch = memberTypes.stream().allMatch(bType -> bType.tag == firstMemberType.tag);
        if (!allMatch) {
            resultEntries.putAll(FilterUtils.getLangLibScopeEntries((BType)unionType, symbolTable, types));
            return resultEntries;
        }
        resultEntries.putAll(FilterUtils.getLangLibScopeEntries(firstMemberType, symbolTable, types));
        if (firstMemberType.tag == 12) {
            LinkedHashMap memberOccurrenceCounts = new LinkedHashMap();
            ArrayList firstMemberFieldKeys = new ArrayList();
            for (int memberCounter = 0; memberCounter < memberTypes.size(); ++memberCounter) {
                int finalMemberCounter = memberCounter;
                ((BRecordType)memberTypes.get((int)memberCounter)).tsymbol.scope.entries.keySet().forEach(name -> {
                    if (memberOccurrenceCounts.containsKey(name.value)) {
                        memberOccurrenceCounts.put(name.value, (Integer)memberOccurrenceCounts.get(name.value) + 1);
                    } else if (finalMemberCounter == 0) {
                        firstMemberFieldKeys.add(name);
                        memberOccurrenceCounts.put(name.value, 1);
                    }
                });
            }
            if (memberOccurrenceCounts.size() == 0) {
                return resultEntries;
            }
            ArrayList counts = new ArrayList(memberOccurrenceCounts.values());
            Map firstMemberEntries = ((BRecordType)firstMemberType).tsymbol.scope.entries;
            for (int i = 0; i < counts.size(); ++i) {
                if (((Integer)counts.get(i)).intValue() != memberTypes.size()) continue;
                Name name2 = (Name)firstMemberFieldKeys.get(i);
                BSymbol symbol = ((Scope.ScopeEntry)firstMemberEntries.get((Object)name2)).symbol;
                if (firstMemberType.tag == 12 && (invocationTokenType == 97 || invocationTokenType == 115) && Flags.isFlagOn((int)symbol.flags, (int)8192)) continue;
                resultEntries.put(name2, (Scope.ScopeEntry)firstMemberEntries.get(name2));
            }
        }
        return resultEntries;
    }

    private static Optional<Scope.ScopeEntry> getScopeEntryWithName(Map<Name, Scope.ScopeEntry> entries, ChainedFieldModel fieldModel) {
        return entries.values().stream().filter(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            String[] symbolNameComponents = symbol.getName().getValue().split("\\.");
            String symbolName = symbolNameComponents[symbolNameComponents.length - 1];
            if (!symbolName.equals(fieldModel.name.getText())) {
                return false;
            }
            return fieldModel.fieldType == InvocationFieldType.INVOCATION && symbol instanceof BInvokableSymbol || fieldModel.fieldType == InvocationFieldType.FIELD && !(symbol instanceof BInvokableSymbol);
        }).findAny();
    }

    public static Map<Name, Scope.ScopeEntry> getLangLibScopeEntries(BType bType, SymbolTable symTable, Types types) {
        HashMap<Name, Scope.ScopeEntry> entries = new HashMap<Name, Scope.ScopeEntry>(symTable.langValueModuleSymbol.scope.entries);
        switch (bType.tag) {
            case 19: 
            case 29: {
                entries.putAll(symTable.langArrayModuleSymbol.scope.entries);
                break;
            }
            case 4: {
                entries.putAll(symTable.langDecimalModuleSymbol.scope.entries);
                break;
            }
            case 27: {
                entries.putAll(symTable.langErrorModuleSymbol.scope.entries);
                break;
            }
            case 3: {
                entries.putAll(symTable.langFloatModuleSymbol.scope.entries);
                break;
            }
            case 30: {
                entries.putAll(symTable.langFutureModuleSymbol.scope.entries);
                break;
            }
            case 1: {
                entries.putAll(symTable.langIntModuleSymbol.scope.entries);
                break;
            }
            case 12: 
            case 15: {
                entries.putAll(symTable.langMapModuleSymbol.scope.entries);
                return entries;
            }
            case 32: {
                entries.putAll(symTable.langObjectModuleSymbol.scope.entries);
                break;
            }
            case 14: {
                entries.putAll(symTable.langStreamModuleSymbol.scope.entries);
                break;
            }
            case 5: {
                entries.putAll(symTable.langStringModuleSymbol.scope.entries);
                break;
            }
            case 9: {
                entries.putAll(symTable.langTableModuleSymbol.scope.entries);
                break;
            }
            case 13: {
                entries.putAll(symTable.langTypedescModuleSymbol.scope.entries);
                break;
            }
            case 8: {
                entries.putAll(symTable.langXmlModuleSymbol.scope.entries);
                break;
            }
            case 6: {
                entries.putAll(symTable.langBooleanModuleSymbol.scope.entries);
                break;
            }
        }
        return entries.entrySet().stream().filter(entry -> {
            BSymbol symbol = ((Scope.ScopeEntry)entry.getValue()).symbol;
            if (symbol instanceof BInvokableSymbol) {
                List params = ((BInvokableSymbol)symbol).params;
                return params.isEmpty() || ((BVarSymbol)params.get((int)0)).type.tag == bType.tag || types.isAssignable(bType, ((BVarSymbol)params.get((int)0)).type);
            }
            return symbol.kind != null && symbol.kind != SymbolKind.OBJECT;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Predicate<Map.Entry<Name, Scope.ScopeEntry>> optionalFieldFilter(BType symbolType, Integer invocationTkn, LSContext context) {
        BLangNode scope = (BLangNode)context.get(CompletionKeys.SCOPE_NODE_KEY);
        List defaultTokenTypes = ((List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY)).stream().map(CommonToken::getType).collect(Collectors.toList());
        return entry -> {
            if (symbolType.tag == 12 && (invocationTkn == 97 || invocationTkn == 115) && (scope instanceof BLangBlockStmt || scope instanceof BLangFunctionBody) && defaultTokenTypes.contains(109)) {
                return !Flags.isFlagOn((int)((Scope.ScopeEntry)entry.getValue()).symbol.flags, (int)8192);
            }
            return true;
        };
    }

    public static enum InvocationFieldType {
        FIELD,
        INVOCATION,
        ARRAY_ACCESS;

    }

    private static class ChainedFieldModel {
        InvocationFieldType fieldType;
        CommonToken name;
        CommonToken pkgAlias;

        ChainedFieldModel(InvocationFieldType fieldType, CommonToken name, CommonToken pkgAlias) {
            this.fieldType = fieldType;
            this.name = name;
            this.pkgAlias = pkgAlias;
        }
    }
}

