/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.ballerinalang.langserver.command.testgen.TestGenerator;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class FunctionGenerator {
    public static String createFunction(String name, String args, String returnType, String returnDefaultValue, String modifiers, boolean prependLineFeed, String padding) {
        String funcBody = CommonUtil.LINE_SEPARATOR;
        String funcReturnSignature = "";
        if (returnType != null) {
            funcBody = returnDefaultValue + funcBody;
            funcReturnSignature = " returns " + returnType + " ";
        }
        String lineFeed = prependLineFeed ? CommonUtil.LINE_SEPARATOR + CommonUtil.LINE_SEPARATOR : CommonUtil.LINE_SEPARATOR;
        return lineFeed + padding + modifiers + "function " + name + "(" + args + ")" + funcReturnSignature + "{" + CommonUtil.LINE_SEPARATOR + funcBody + padding + "}" + CommonUtil.LINE_SEPARATOR;
    }

    public static String generateReturnValue(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangNode bLangNode, String template) {
        if (bLangNode.type == null && bLangNode instanceof BLangTupleDestructure) {
            ArrayList<String> list = new ArrayList<String>();
            for (BLangExpression bLangExpression : ((BLangTupleDestructure)bLangNode).varRef.expressions) {
                if (bLangExpression.type == null) continue;
                list.add(FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, bLangExpression.type, "{%1}"));
            }
            return template.replace("{%1}", "(" + String.join((CharSequence)", ", list) + ")");
        }
        if (bLangNode instanceof BLangLiteral) {
            return template.replace("{%1}", ((BLangLiteral)bLangNode).getValue().toString());
        }
        if (bLangNode instanceof BLangAssignment) {
            return template.replace("{%1}", "0");
        }
        return bLangNode.type != null ? FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, bLangNode.type, template) : null;
    }

    public static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangNode bLangNode) {
        return FunctionGenerator.generateTypeDefinition(importsAcceptor, 1, currentPkgId, bLangNode);
    }

    public static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BType bType) {
        return FunctionGenerator.generateTypeDefinition(importsAcceptor, 1, currentPkgId, bType);
    }

    public static List<String> getFuncArguments(BInvokableSymbol symbol, LSContext ctx) {
        ArrayList<String> list = new ArrayList<String>();
        int invocationType = ctx == null || ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY) == null ? -1 : (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        boolean skipFirstParam = CommonUtil.skipFirstParam(symbol, invocationType);
        BVarSymbol restParam = symbol.restParam;
        if (symbol.kind == null && SymbolKind.RECORD == symbol.owner.kind || SymbolKind.FUNCTION == symbol.owner.kind) {
            if (symbol.type instanceof BInvokableType) {
                BInvokableType bInvokableType = (BInvokableType)symbol.type;
                if (bInvokableType.paramTypes.isEmpty()) {
                    return list;
                }
                int argCounter = 1;
                HashSet<String> argNames = new HashSet<String>();
                List parameterTypes = bInvokableType.getParameterTypes();
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    if (i == 0 && skipFirstParam) continue;
                    BType bType = (BType)parameterTypes.get(i);
                    String argName = CommonUtil.generateName(argCounter++, argNames);
                    String argType = FunctionGenerator.generateTypeDefinition(null, symbol.pkgID, bType);
                    list.add(argType + " " + argName);
                    argNames.add(argName);
                }
                if (restParam != null && restParam.type instanceof BArrayType) {
                    list.add(CommonUtil.getBTypeName(((BArrayType)restParam.type).eType, ctx, false) + "... " + restParam.getName().getValue());
                }
            }
        } else {
            ArrayList parameterDefs = new ArrayList(symbol.getParameters());
            for (int i = 0; i < parameterDefs.size(); ++i) {
                if (i == 0 && skipFirstParam) continue;
                BVarSymbol param = (BVarSymbol)parameterDefs.get(i);
                list.add(CommonUtil.getBTypeName(param.type, ctx, true) + " " + param.getName());
            }
            if (restParam != null && restParam.type instanceof BArrayType) {
                list.add(CommonUtil.getBTypeName(((BArrayType)restParam.type).eType, ctx, false) + "... " + restParam.getName().getValue());
            }
        }
        return !list.isEmpty() ? list : new ArrayList<String>();
    }

    public static List<String> getFuncArguments(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BLangNode parent, LSContext context) {
        ArrayList<String> list = new ArrayList<String>();
        if (parent instanceof BLangInvocation) {
            BLangInvocation bLangInvocation = (BLangInvocation)parent;
            if (bLangInvocation.argExprs.isEmpty()) {
                return null;
            }
            int argCounter = 1;
            CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
            for (BLangExpression bLangExpression : bLangInvocation.argExprs) {
                String argName;
                String argType;
                Set<String> argNames = CommonUtil.getAllNameEntries(compilerContext);
                if (bLangExpression instanceof BLangSimpleVarRef) {
                    BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)bLangExpression;
                    String varName = simpleVarRef.variableName.value;
                    String argType2 = FunctionGenerator.lookupVariableReturnType(importsAcceptor, currentPkgId, varName, parent);
                    list.add(argType2 + " " + varName);
                    argNames.add(varName);
                    continue;
                }
                if (bLangExpression instanceof BLangInvocation) {
                    argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, (BLangNode)bLangExpression);
                    argName = CommonUtil.generateVariableName((BLangNode)bLangExpression, argNames);
                    list.add(argType + " " + argName);
                    argNames.add(argName);
                    continue;
                }
                argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, (BLangNode)bLangExpression);
                argName = CommonUtil.generateName(argCounter++, argNames);
                list.add(argType + " " + argName);
                argNames.add(argName);
            }
        }
        return !list.isEmpty() ? list : null;
    }

    private static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, int wsOffset, PackageID currentPkgId, BLangNode bLangNode) {
        if (bLangNode instanceof BLangTupleDestructure && bLangNode.type == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (BLangExpression bLangExpression : ((BLangTupleDestructure)bLangNode).varRef.expressions) {
                if (bLangExpression.type == null) continue;
                list.add(FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bLangExpression.type));
            }
            return "[" + String.join((CharSequence)", ", list) + "]";
        }
        if (bLangNode instanceof BLangAssignment) {
            if (((BLangAssignment)bLangNode).declaredWithVar) {
                return "any";
            }
        } else if (bLangNode instanceof BLangFunctionTypeNode) {
            BLangFunctionTypeNode funcType = (BLangFunctionTypeNode)bLangNode;
            TestGenerator.TestFunctionGenerator generator = new TestGenerator.TestFunctionGenerator(importsAcceptor, currentPkgId, funcType);
            String[] typeSpace = generator.getTypeSpace();
            String[] nameSpace = generator.getNamesSpace();
            StringJoiner params = new StringJoiner(", ");
            IntStream.range(0, typeSpace.length - 1).forEach(index -> {
                String type = typeSpace[index];
                String name = nameSpace[index];
                params.add(type + " " + name);
            });
            return "function (" + params.toString() + ") returns (" + typeSpace[typeSpace.length - 1] + ")";
        }
        return bLangNode != null && bLangNode.type != null ? FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bLangNode.type) : null;
    }

    private static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, int wsOffset, PackageID currentPkgId, BType bType) {
        if ((bType.tsymbol == null || bType.tsymbol.name.value.isEmpty()) && bType instanceof BArrayType) {
            return FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, ((BArrayType)bType).eType) + "[]";
        }
        if (bType instanceof BMapType && ((BMapType)bType).constraint != null) {
            BTypeSymbol tSymbol = ((BMapType)bType).constraint.tsymbol;
            if (tSymbol != null) {
                String constraint = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, tSymbol);
                return "any".equals(constraint) ? "map" : "map<" + constraint + ">";
            }
        } else {
            if (bType instanceof BUnionType) {
                Optional<BType> type;
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<BType> memberTypes = new ArrayList<BType>(((BUnionType)bType).getMemberTypes());
                if (memberTypes.size() == 2 && memberTypes.stream().anyMatch(bType1 -> bType1 instanceof BNilType) && (type = memberTypes.stream().filter(bType1 -> !(bType1 instanceof BNilType)).findFirst()).isPresent()) {
                    return FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, type.get()) + "?";
                }
                long errorTypesCount = memberTypes.stream().filter(t -> t instanceof BErrorType).count();
                boolean addErrorTypeAtEnd = false;
                if (errorTypesCount > 1L) {
                    memberTypes.removeIf(s -> s instanceof BErrorType);
                    if (memberTypes.size() == 1 && memberTypes.get(0) instanceof BNilType) {
                        return "error?";
                    }
                    addErrorTypeAtEnd = true;
                }
                for (BType memberType : memberTypes) {
                    list.add(FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, memberType));
                }
                if (addErrorTypeAtEnd) {
                    list.add("error");
                }
                return String.join((CharSequence)"|", list);
            }
            if (bType instanceof BTupleType) {
                ArrayList<String> list = new ArrayList<String>();
                for (BType memberType : ((BTupleType)bType).tupleTypes) {
                    list.add(FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, memberType));
                }
                return "[" + String.join((CharSequence)", ", list) + "]";
            }
            if (bType instanceof BNilType) {
                return "()";
            }
            if (bType instanceof BTableType) {
                return "table<record {}>";
            }
            if (bType instanceof BStreamType) {
                BStreamType streamType = (BStreamType)bType;
                String constraint = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, streamType.constraint);
                String error = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, streamType.error);
                return "stream<" + constraint + ", " + error + ">";
            }
            if (bType instanceof BRecordType) {
                BRecordType recordType = (BRecordType)bType;
                if (recordType.tsymbol != null && recordType.tsymbol.name != null && (recordType.tsymbol.name.value.isEmpty() || recordType.tsymbol.name.value.startsWith("$"))) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("record").append(" ").append("{|");
                    for (BField field : recordType.fields) {
                        sb.append(" ").append(field.type).append(" ").append(field.name).append(Symbols.isOptional((BSymbol)field.symbol) ? "?" : "").append(";");
                    }
                    if (recordType.sealed) {
                        sb.append(" ").append("|}");
                        return sb.toString();
                    }
                    sb.append(" ").append(recordType.restFieldType).append("...").append(";").append(" ").append("|}");
                    return sb.toString();
                }
                return FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bType.tsymbol);
            }
        }
        return bType.tsymbol != null ? FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bType.tsymbol) : "any";
    }

    private static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, int wsOffset, PackageID currentPkgId, BTypeSymbol tSymbol) {
        if (tSymbol != null) {
            if (tSymbol instanceof BInvokableTypeSymbol) {
                BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)tSymbol;
                StringJoiner params = new StringJoiner(", ");
                int argCounter = 1;
                HashSet<String> argNames = new HashSet<String>();
                for (BVarSymbol param : invokableTypeSymbol.params) {
                    BType bType = param.type;
                    String argName = CommonUtil.generateName(argCounter++, argNames);
                    String argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bType);
                    params.add(argType + " " + argName);
                    argNames.add(argName);
                }
                BVarSymbol restParam = invokableTypeSymbol.restParam;
                if (restParam != null && restParam.type instanceof BArrayType) {
                    BArrayType type = (BArrayType)restParam.type;
                    params.add(FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, type.eType.tsymbol.pkgID, type.eType) + "... " + restParam.getName().getValue());
                }
                String returnType = invokableTypeSymbol.returnType != null ? FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, invokableTypeSymbol.returnType) : "";
                return "function (" + params.toString() + ")" + (returnType.isEmpty() ? "" : " returns " + returnType);
            }
            if (tSymbol instanceof BObjectTypeSymbol && tSymbol.name.value.startsWith("$")) {
                boolean isAbstract;
                StringBuilder builder = new StringBuilder();
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)tSymbol;
                boolean bl = isAbstract = (objectTypeSymbol.flags & 0x1000) == 4096;
                if (isAbstract) {
                    builder.append("abstract ");
                }
                builder.append("object {");
                if (objectTypeSymbol.attachedFuncs != null && !objectTypeSymbol.attachedFuncs.isEmpty()) {
                    builder.append(CommonUtil.LINE_SEPARATOR);
                    String objWS = new String(new char[wsOffset]).replace("\u0000", "\t");
                    int newOffset = ++wsOffset;
                    String funcWS = new String(new char[wsOffset]).replace("\u0000", "\t");
                    objectTypeSymbol.attachedFuncs.forEach(func -> {
                        builder.append(funcWS);
                        builder.append(FunctionGenerator.generateTypeDefinition(importsAcceptor, newOffset, currentPkgId, func));
                        builder.append(";");
                        builder.append(CommonUtil.LINE_SEPARATOR);
                    });
                    builder.append(objWS);
                    builder.append("}");
                } else {
                    builder.append("}");
                }
                return builder.toString();
            }
            String pkgPrefix = CommonUtil.getPackagePrefix(importsAcceptor, currentPkgId, tSymbol.pkgID);
            return pkgPrefix + tSymbol.name.getValue();
        }
        return "any";
    }

    private static String generateTypeDefinition(BiConsumer<String, String> importsAcceptor, int wsOffset, PackageID currentPkgId, BAttachedFunction func) {
        String argName;
        StringBuilder builder = new StringBuilder();
        String modifiers = FunctionGenerator.parseModifiers(func.symbol.flags);
        modifiers = modifiers.isEmpty() ? "" : modifiers + " ";
        builder.append(modifiers);
        builder.append("function ");
        builder.append(func.funcName);
        builder.append("(");
        BInvokableType type = func.type;
        StringJoiner params = new StringJoiner(", ");
        int argCounter = 1;
        HashSet<String> argNames = new HashSet<String>();
        List parameterTypes = type.getParameterTypes();
        for (BType bType : parameterTypes) {
            argName = CommonUtil.generateName(argCounter++, argNames);
            String argType = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, bType);
            params.add(argType + " " + argName);
            argNames.add(argName);
        }
        BType restParam = type.restType;
        if (restParam instanceof BArrayType) {
            String restType = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, ((BArrayType)restParam).eType);
            argName = CommonUtil.generateName(argCounter++, argNames);
            params.add(restType + "... " + argName);
        }
        builder.append(")");
        if (type.retType != null) {
            builder.append(" returns (");
            String retType = FunctionGenerator.generateTypeDefinition(importsAcceptor, wsOffset, currentPkgId, type.retType);
            builder.append(retType);
            builder.append(")");
        }
        return builder.toString();
    }

    private static String parseModifiers(int flagValue) {
        StringJoiner joiner = new StringJoiner(" ");
        if ((flagValue & 1) == 1) {
            joiner.add("public");
        }
        if ((flagValue & 0x400) == 1024) {
            joiner.add("private");
        }
        if ((flagValue & 0x1000) == 4096) {
            joiner.add("abstract");
        }
        if ((flagValue & 0x10000) == 65536) {
            joiner.add("remote");
        }
        return joiner.toString();
    }

    private static String lookupVariableReturnType(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, String variableName, BLangNode parent) {
        if (parent instanceof BLangBlockStmt || parent instanceof BLangFunctionBody) {
            Scope scope;
            Scope scope2 = scope = parent instanceof BLangBlockStmt ? ((BLangBlockStmt)parent).scope : ((BLangFunctionBody)parent).scope;
            if (scope != null) {
                for (Map.Entry entry : scope.entries.entrySet()) {
                    String key = ((Name)entry.getKey()).getValue();
                    BSymbol symbol = ((Scope.ScopeEntry)entry.getValue()).symbol;
                    if (!variableName.equals(key) || !(symbol instanceof BVarSymbol)) continue;
                    return FunctionGenerator.generateTypeDefinition(importsAcceptor, currentPkgId, symbol.type);
                }
            }
        }
        return parent != null && parent.parent != null ? FunctionGenerator.lookupVariableReturnType(importsAcceptor, currentPkgId, variableName, parent.parent) : "any";
    }

    private static String lookupFunctionReturnType(String functionName, BLangNode parent) {
        if (parent instanceof BLangPackage) {
            BLangPackage blockStmt = (BLangPackage)parent;
            List functions = blockStmt.functions;
            for (BLangFunction function : functions) {
                if (!functionName.equals(function.name.getValue())) continue;
                return FunctionGenerator.generateTypeDefinition(null, ((BLangPackage)parent).packageID, (BLangNode)function.returnTypeNode);
            }
        }
        return parent != null && parent.parent != null ? FunctionGenerator.lookupFunctionReturnType(functionName, parent.parent) : "any";
    }

    public static String generateReturnValue(BiConsumer<String, String> importsAcceptor, PackageID currentPkgId, BType bType, String template) {
        if (bType instanceof BArrayType) {
            String arrDef = "[" + FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, ((BArrayType)bType).eType, "{%1}") + "]";
            return template.replace("{%1}", arrDef);
        }
        if (bType instanceof BFiniteType) {
            BFiniteType bFiniteType = (BFiniteType)bType;
            Set valueSpace = bFiniteType.getValueSpace();
            if (!valueSpace.isEmpty()) {
                return FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, (BLangNode)valueSpace.stream().findFirst().get(), template);
            }
        } else {
            if (bType instanceof BMapType && ((BMapType)bType).constraint != null) {
                BType constraintType = ((BMapType)bType).constraint;
                String mapDef = "{key: " + FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, constraintType, "{%1}") + "}";
                return template.replace("{%1}", mapDef);
            }
            if (bType instanceof BUnionType) {
                Optional<BType> type;
                BUnionType bUnionType = (BUnionType)bType;
                Set memberTypes = bUnionType.getMemberTypes();
                if (memberTypes.size() == 2 && memberTypes.stream().anyMatch(bType1 -> bType1 instanceof BNilType) && (type = memberTypes.stream().filter(bType1 -> !(bType1 instanceof BNilType)).findFirst()).isPresent()) {
                    return FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, type.get(), template);
                }
                if (!memberTypes.isEmpty()) {
                    BType firstBType = (BType)memberTypes.stream().findFirst().get();
                    return FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, firstBType, template);
                }
            } else {
                if (bType instanceof BTupleType) {
                    BTupleType bTupleType = (BTupleType)bType;
                    List tupleTypes = bTupleType.tupleTypes;
                    ArrayList<String> list = new ArrayList<String>();
                    for (BType type : tupleTypes) {
                        list.add(FunctionGenerator.generateReturnValue(importsAcceptor, currentPkgId, type, "{%1}"));
                    }
                    return template.replace("{%1}", "(" + String.join((CharSequence)", ", list) + ")");
                }
                if (bType instanceof BObjectType && ((BObjectType)bType).tsymbol instanceof BObjectTypeSymbol) {
                    BObjectTypeSymbol bStruct = (BObjectTypeSymbol)((BObjectType)bType).tsymbol;
                    ArrayList<String> list = new ArrayList<String>();
                    for (BVarSymbol param : bStruct.initializerFunc.symbol.params) {
                        list.add(FunctionGenerator.generateReturnValue(param.type.tsymbol, "{%1}"));
                    }
                    String pkgPrefix = CommonUtil.getPackagePrefix(importsAcceptor, currentPkgId, bStruct.pkgID);
                    String paramsStr = String.join((CharSequence)", ", list);
                    String newObjStr = "new " + pkgPrefix + bStruct.name.getValue() + "(" + paramsStr + ")";
                    return template.replace("{%1}", newObjStr);
                }
            }
        }
        return bType.tsymbol != null ? FunctionGenerator.generateReturnValue(bType.tsymbol, template) : template.replace("{%1}", "()");
    }

    private static String generateReturnValue(BTypeSymbol tSymbol, String template) {
        String result;
        switch (tSymbol.name.getValue()) {
            case "int": 
            case "any": {
                result = "0";
                break;
            }
            case "string": {
                result = "\"\"";
                break;
            }
            case "float": {
                result = "0.0";
                break;
            }
            case "json": {
                result = "{}";
                break;
            }
            case "map": {
                result = "<map>{}";
                break;
            }
            case "boolean": {
                result = "false";
                break;
            }
            case "xml": {
                result = "xml ` `";
                break;
            }
            case "byte": {
                result = "0";
                break;
            }
            case "table": {
                result = "table{}";
                break;
            }
            case "error": {
                result = "error(\"\")";
                break;
            }
            default: {
                result = "()";
            }
        }
        return template.replace("{%1}", result);
    }
}

