/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class BTypeCompletionItemBuilder {
    private BTypeCompletionItemBuilder() {
    }

    public static CompletionItem build(BSymbol bSymbol, String label) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        String[] delimiterSeparatedTokens = label.split("\\.");
        item.setInsertText(delimiterSeparatedTokens[delimiterSeparatedTokens.length - 1]);
        BTypeCompletionItemBuilder.setMeta(item, bSymbol);
        return item;
    }

    private static void setMeta(CompletionItem item, BSymbol bSymbol) {
        if (bSymbol == null) {
            item.setKind(CompletionItemKind.Class);
            return;
        }
        if (bSymbol instanceof BPackageSymbol) {
            item.setKind(CompletionItemKind.Module);
        } else if (bSymbol.type instanceof BFiniteType) {
            item.setKind(CompletionItemKind.TypeParameter);
        } else if (bSymbol.type instanceof BUnionType) {
            ArrayList memberTypes = new ArrayList(((BUnionType)bSymbol.type).getMemberTypes());
            boolean allMatch = memberTypes.stream().allMatch(bType -> bType.tag == ((BType)memberTypes.get((int)0)).tag);
            if (allMatch) {
                switch (((BType)memberTypes.get((int)0)).tag) {
                    case 27: {
                        item.setKind(CompletionItemKind.Event);
                        break;
                    }
                    case 12: {
                        item.setKind(CompletionItemKind.Struct);
                        break;
                    }
                    case 32: {
                        item.setKind(CompletionItemKind.Interface);
                        break;
                    }
                }
            } else {
                item.setKind(CompletionItemKind.Enum);
            }
        } else if (bSymbol instanceof BRecordTypeSymbol) {
            item.setKind(CompletionItemKind.Struct);
        } else if (bSymbol instanceof BObjectTypeSymbol) {
            item.setKind(CompletionItemKind.Interface);
        } else if (bSymbol instanceof BErrorTypeSymbol) {
            item.setKind(CompletionItemKind.Event);
        } else if (bSymbol.kind != null) {
            item.setKind(CompletionItemKind.Class);
        } else {
            item.setKind(CompletionItemKind.Unit);
        }
        if (bSymbol.markdownDocumentation != null) {
            item.setDocumentation(bSymbol.markdownDocumentation.description);
        }
        String name = bSymbol.type.getKind().name();
        String detail = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
        item.setDetail(detail);
    }
}

