/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.LSAnnotationCache;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.model.elements.PackageID;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.Name;

public class AnnotationAccessExpressionContextProvider
extends AbstractCompletionProvider {
    public AnnotationAccessExpressionContextProvider() {
        this.attachmentPoints.add(AnnotationAccessExpressionContextProvider.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        return this.filterAnnotations(ctx);
    }

    private List<LSCompletionItem> filterAnnotations(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List defaultTokenTypes = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        List defaultTokens = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        int annotationAccessIndex = defaultTokenTypes.indexOf(150);
        int pkgDelimiterIndex = defaultTokenTypes.lastIndexOf(96);
        CommonToken pkgAlias = null;
        if (pkgDelimiterIndex > annotationAccessIndex) {
            pkgAlias = (CommonToken)defaultTokens.get(pkgDelimiterIndex - 1);
        }
        Map<String, String> pkgAliasMap = ((List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY)).stream().collect(Collectors.toMap(pkg -> pkg.alias.value, pkg -> pkg.symbol.pkgID.toString()));
        if (pkgAlias != null) {
            CommonToken finalPkgAlias = pkgAlias;
            LSAnnotationCache.getInstance().getAnnotations().forEach(annotation -> {
                String annotationPkgAlias = ((Name)annotation.pkgID.nameComps.get((int)(annotation.pkgID.nameComps.size() - 1))).value;
                String annotationPkg = annotation.pkgID.toString();
                if (finalPkgAlias.getText().equals(annotationPkgAlias) || annotationPkg.equals(pkgAliasMap.get(finalPkgAlias.getText()))) {
                    completionItems.add(this.getAnnotationCompletionItem(annotation.pkgID, (BAnnotationSymbol)annotation, ctx, finalPkgAlias, pkgAliasMap));
                }
            });
            return completionItems;
        }
        completionItems.addAll(this.getAnnotationsInModule(ctx));
        completionItems.addAll(this.getPackagesCompletionItems(ctx));
        return completionItems;
    }

    private List<LSCompletionItem> getAnnotationsInModule(LSContext ctx) {
        BLangPackage bLangPackage = (BLangPackage)ctx.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<BLangAnnotation> annotations = bLangPackage.topLevelNodes.stream().filter(topLevelNode -> topLevelNode instanceof BLangAnnotation).map(topLevelNode -> (BLangAnnotation)topLevelNode).collect(Collectors.toList());
        annotations.forEach(bLangAnnotation -> {
            BAnnotationSymbol symbol = (BAnnotationSymbol)bLangAnnotation.symbol;
            CompletionItem annotationItem = new CompletionItem();
            annotationItem.setLabel(symbol.getName().getValue());
            annotationItem.setInsertText(symbol.getName().getValue());
            annotationItem.setInsertTextFormat(InsertTextFormat.Snippet);
            annotationItem.setDetail("Annotation");
            annotationItem.setKind(CompletionItemKind.Property);
            completionItems.add(new SymbolCompletionItem(ctx, (BSymbol)symbol, annotationItem));
        });
        return completionItems;
    }

    private LSCompletionItem getAnnotationCompletionItem(PackageID packageID, BAnnotationSymbol annotationSymbol, LSContext ctx, CommonToken pkgAlias, Map<String, String> pkgAliasMap) {
        PackageID currentPkgID = (PackageID)ctx.get(DocumentServiceKeys.CURRENT_PACKAGE_ID_KEY);
        String currentProjectOrgName = currentPkgID == null ? "" : currentPkgID.orgName.value;
        String aliasComponent = "";
        if (pkgAliasMap.containsKey(packageID.toString())) {
            aliasComponent = pkgAliasMap.get(packageID.toString());
        } else if (!currentPkgID.name.value.equals(packageID.name.value)) {
            aliasComponent = ((Name)CommonUtil.getLastItem(packageID.getNameComps())).getValue();
        }
        boolean withAlias = pkgAlias == null && !aliasComponent.isEmpty();
        String label = CommonUtil.getAnnotationLabel(aliasComponent, annotationSymbol, withAlias);
        String insertText = this.getInsertText(aliasComponent, annotationSymbol, withAlias);
        CompletionItem annotationItem = new CompletionItem();
        annotationItem.setLabel(label);
        annotationItem.setInsertText(insertText);
        annotationItem.setInsertTextFormat(InsertTextFormat.Snippet);
        annotationItem.setDetail("Annotation");
        annotationItem.setKind(CompletionItemKind.Property);
        if (currentPkgID != null && currentPkgID.name.value.equals(packageID.name.value)) {
            return new SymbolCompletionItem(ctx, (BSymbol)annotationSymbol, annotationItem);
        }
        List imports = (List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY);
        Optional<BLangImportPackage> pkgImport = imports.stream().filter(bLangImportPackage -> {
            String orgName = bLangImportPackage.orgName.value;
            String importPkgName = (orgName.equals("") ? currentProjectOrgName : orgName) + "/" + CommonUtil.getPackageNameComponentsCombined(bLangImportPackage);
            String annotationPkgOrgName = packageID.orgName.getValue();
            String annotationPkgName = annotationPkgOrgName + "/" + packageID.nameComps.stream().map(Name::getValue).collect(Collectors.joining("."));
            return importPkgName.equals(annotationPkgName);
        }).findAny();
        if (!pkgImport.isPresent()) {
            annotationItem.setAdditionalTextEdits(CommonUtil.getAutoImportTextEdits(packageID.orgName.getValue(), packageID.name.getValue(), ctx));
        }
        return new SymbolCompletionItem(ctx, (BSymbol)annotationSymbol, annotationItem);
    }

    private String getInsertText(String aliasComponent, BAnnotationSymbol annotationSymbol, boolean withAlias) {
        StringBuilder annotationStart = new StringBuilder();
        if (withAlias) {
            annotationStart.append(aliasComponent).append(":");
        }
        annotationStart.append(annotationSymbol.getName().getValue());
        return annotationStart.toString();
    }
}

