/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;

public class GlobalVarDefContextProvider
extends AbstractCompletionProvider {
    public GlobalVarDefContextProvider() {
        this.attachmentPoints.add(BallerinaParser.GlobalVariableDefinitionContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<CommonToken> lhsDefaultTokens = ((List)ctx.get(SourcePruneKeys.LHS_TOKENS_KEY)).stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        Optional<CommonToken> assignToken = lhsDefaultTokens.stream().filter(commonToken -> commonToken.getType() == 109).findAny();
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        if (lhsDefaultTokens.isEmpty()) {
            return completionItems;
        }
        int firstToken = ((CommonToken)lhsDefaultTokens.get(0)).getType();
        int invocationOrDelimiterTokenType = (Integer)ctx.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (this.suggestListeners(lhsDefaultTokens)) {
            if (invocationOrDelimiterTokenType > -1) {
                int pkgDelimiterIndex = lhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList()).indexOf(96);
                String pkgAlias = lhsDefaultTokens.get(pkgDelimiterIndex - 1).getText();
                completionItems.addAll(this.getListenersFromPackage(ctx, pkgAlias));
                return completionItems;
            }
            completionItems.addAll(this.getListenersAndPackagesItems(ctx));
            return completionItems;
        }
        if (lhsDefaultTokens.size() <= 2) {
            if (firstToken == 6) {
                completionItems.addAll(this.getBasicTypesItems(ctx, visibleSymbols));
                completionItems.addAll(this.getPackagesCompletionItems(ctx));
            } else if (96 == invocationOrDelimiterTokenType) {
                Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> pkgContent = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(ctx);
                completionItems.addAll(this.getCompletionItemList(pkgContent, ctx));
            } else {
                completionItems.addAll(this.getAllTopLevelItems(ctx));
                completionItems.addAll(this.getPackagesCompletionItems(ctx));
            }
        } else if (invocationOrDelimiterTokenType > -1) {
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(ctx);
            completionItems.addAll(this.getCompletionItemList(filteredList, ctx));
        } else if (assignToken.isPresent()) {
            completionItems.addAll(this.getVarDefExpressionCompletions(ctx, true));
        } else {
            completionItems.addAll(this.getAllTopLevelItems(ctx));
            completionItems.addAll(this.getPackagesCompletionItems(ctx));
        }
        return completionItems;
    }

    private List<LSCompletionItem> getListenersAndPackagesItems(LSContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getPackagesCompletionItems(context));
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        List listeners = visibleSymbols.stream().filter(scopeEntry -> CommonUtil.isListenerObject(scopeEntry.symbol)).collect(Collectors.toList());
        completionItems.addAll(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(listeners), context));
        return completionItems;
    }

    private List<LSCompletionItem> getListenersFromPackage(LSContext context, String alias) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        Optional<Scope.ScopeEntry> packageSymbolInfo = visibleSymbols.stream().filter(scopeEntry -> scopeEntry.symbol instanceof BPackageSymbol && scopeEntry.symbol.name.getValue().equals(alias)).findAny();
        if (!packageSymbolInfo.isPresent() || !(packageSymbolInfo.get().symbol instanceof BPackageSymbol)) {
            return completionItems;
        }
        List<Scope.ScopeEntry> listeners = ((BPackageSymbol)packageSymbolInfo.get().symbol).scope.entries.values().stream().filter(scopeEntry -> CommonUtil.isListenerObject(scopeEntry.symbol)).collect(Collectors.toList());
        completionItems.addAll(this.getCompletionItemList(listeners, context));
        return completionItems;
    }

    private List<LSCompletionItem> getAllTopLevelItems(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        completionItems.addAll(this.addTopLevelItems(ctx));
        completionItems.addAll(this.getBasicTypesItems(ctx, visibleSymbols));
        return completionItems;
    }

    private boolean suggestListeners(List<CommonToken> lhsDefaultTokens) {
        List tokenTypes = lhsDefaultTokens.stream().map(CommonToken::getType).collect(Collectors.toList());
        int assignToken = tokenTypes.indexOf(109);
        int listenerToken = tokenTypes.indexOf(16);
        return assignToken == -1 && listenerToken > -1;
    }
}

