/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSPackageLoader;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaPackage;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.util.Names;

public class ImportDeclarationContextProvider
extends AbstractCompletionProvider {
    public ImportDeclarationContextProvider() {
        this.attachmentPoints.add(BallerinaParser.ImportDeclarationContext.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList<BallerinaPackage> packagesList = new ArrayList<BallerinaPackage>();
        Stream.of(LSPackageLoader.getSdkPackages(), LSPackageLoader.getHomeRepoPackages()).forEach(packagesList::addAll);
        List lhsTokens = (List)ctx.get(SourcePruneKeys.LHS_TOKENS_KEY);
        List lhsDefaultTokens = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        List lhsDefaultTokenTypes = (List)ctx.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        int divIndex = lhsDefaultTokenTypes.indexOf(113);
        int importTokenIndex = lhsDefaultTokenTypes.indexOf(1);
        CommonToken lastToken = (CommonToken)CommonUtil.getLastItem(lhsTokens);
        if (divIndex > -1 && (divIndex == lhsDefaultTokenTypes.size() - 1 || divIndex == lhsDefaultTokenTypes.size() - 2)) {
            String orgName = ((CommonToken)lhsDefaultTokens.get(lhsDefaultTokenTypes.indexOf(113) - 1)).getText();
            completionItems.addAll(this.getPackageNameCompletions(ctx, orgName, packagesList));
        } else if (importTokenIndex > -1 && (importTokenIndex == lhsDefaultTokenTypes.size() - 1 || importTokenIndex == lhsDefaultTokenTypes.size() - 2)) {
            completionItems.addAll(this.getItemsIncludingOrgName(packagesList, ctx));
        } else if (importTokenIndex > -1 && lhsDefaultTokenTypes.size() >= 2 && (lastToken.getChannel() == 1 || ((CommonToken)lhsTokens.get(lhsTokens.size() - 2)).getChannel() == 1)) {
            completionItems.add(ImportDeclarationContextProvider.getAsKeyword(ctx));
        }
        return completionItems;
    }

    private ArrayList<LSCompletionItem> getItemsIncludingOrgName(List<BallerinaPackage> packagesList, LSContext ctx) {
        ArrayList orgNames = new ArrayList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        packagesList.forEach(pkg -> {
            if (this.isAnnotationLangLib((BallerinaPackage)pkg)) {
                return;
            }
            String fullPkgNameLabel = pkg.getOrgName() + "/" + pkg.getPackageName();
            String insertText = pkg.getOrgName() + "/";
            insertText = pkg.getOrgName().equals(Names.BALLERINA_ORG.value) && pkg.getPackageName().startsWith(Names.LANG.value + ".") ? insertText + this.getLangLibModuleNameInsertText(pkg.getPackageName()) : insertText + pkg.getPackageName();
            LSCompletionItem fullPkgImport = ImportDeclarationContextProvider.getImportCompletion(ctx, fullPkgNameLabel, insertText);
            completionItems.add(fullPkgImport);
            if (!orgNames.contains(pkg.getOrgName())) {
                LSCompletionItem orgNameImport = ImportDeclarationContextProvider.getImportCompletion(ctx, pkg.getOrgName(), pkg.getOrgName() + "/");
                completionItems.add(orgNameImport);
                orgNames.add(pkg.getOrgName());
            }
        });
        LSDocumentIdentifier lsDocument = (LSDocumentIdentifier)ctx.get(DocumentServiceKeys.LS_DOCUMENT_KEY);
        if (lsDocument != null && lsDocument.isWithinProject()) {
            String ownerModule = lsDocument.getOwnerModule();
            List projectModules = lsDocument.getProjectModules();
            projectModules.forEach(module -> {
                if (!module.equals(ownerModule)) {
                    completionItems.add(ImportDeclarationContextProvider.getImportCompletion(ctx, module, module));
                }
            });
        }
        return completionItems;
    }

    private String getLangLibModuleNameInsertText(String pkgName) {
        return pkgName.replace(".", ".'") + ";";
    }

    private ArrayList<LSCompletionItem> getPackageNameCompletions(LSContext context, String orgName, List<BallerinaPackage> packagesList) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList pkgNameLabels = new ArrayList();
        packagesList.forEach(ballerinaPackage -> {
            if (this.isAnnotationLangLib((BallerinaPackage)ballerinaPackage)) {
                return;
            }
            String packageName = ballerinaPackage.getPackageName();
            if (orgName.equals(ballerinaPackage.getOrgName()) && !pkgNameLabels.contains(packageName)) {
                String insertText = orgName.equals(Names.BALLERINA_ORG.value) && packageName.startsWith(Names.LANG.value + ".") ? this.getLangLibModuleNameInsertText(packageName) : packageName;
                pkgNameLabels.add(packageName);
                completionItems.add(ImportDeclarationContextProvider.getImportCompletion(context, packageName, insertText));
            }
        });
        return completionItems;
    }

    private static LSCompletionItem getImportCompletion(LSContext context, String label, String insertText) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setInsertText(insertText);
        item.setKind(CompletionItemKind.Module);
        item.setDetail("Module");
        return new StaticCompletionItem(context, item);
    }

    private static LSCompletionItem getAsKeyword(LSContext context) {
        CompletionItem item = new CompletionItem();
        item.setLabel("as");
        item.setInsertText("as ");
        item.setKind(CompletionItemKind.Keyword);
        item.setDetail("Keyword");
        return new StaticCompletionItem(context, item);
    }

    private boolean isAnnotationLangLib(BallerinaPackage ballerinaPackage) {
        return "ballerina".equals(ballerinaPackage.getOrgName()) && "lang.annotations".equals(ballerinaPackage.getPackageName());
    }
}

